/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.banktrans;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UpdateStateSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("company");
        selector.add("skipproc");
        selector.add("sourcetype");
        selector.add("sourcebillid");
        selector.add("entrys");
        selector.add("entrys.confirmuser");
        selector.add("entrys.confirmtime");
        selector.add("entrys.confirmcontent");
        selector.add("entrys.statusnew");
        selector.add("entrys.paystatus");
        selector.add("entrys.e_sourcebillid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        PayStateUpdateHelper.setIsUpdatingStatus((DynamicObject[])dataEntities, (String)"1");
        for (DynamicObject dataEntity : dataEntities) {
            if (!this.needApprove(dataEntity).booleanValue()) {
                dataEntity.set("skipproc", (Object)"1");
            } else {
                dataEntity.set("skipproc", (Object)"0");
            }
            DynamicObjectCollection currEntries = dataEntity.getDynamicObjectCollection("entrys");
            for (DynamicObject currEntrie : currEntries) {
                currEntrie.set("confirmuser", (Object)RequestContext.get().getCurrUserId());
                currEntrie.set("confirmtime", (Object)DateUtils.getCurrentTime());
                currEntrie.set("confirmcontent", (Object)ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"UpdateStateSubmitService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            String appId;
            if (this.needApprove(dataEntity).booleanValue()) continue;
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isStrict", "false");
            Map operationVariable = this.getOperationVariable();
            if (null != operationVariable && operationVariable.size() > 0 && EmptyUtil.isNotEmpty((CharSequence)(appId = (String)operationVariable.get("appnumber")))) {
                operateOption.setVariableValue("currbizappid", appId);
            }
            TmcOperateServiceHelper.execOperate((String)"audit", (String)dataEntity.getDataEntityType().getName(), (Object[])new Object[]{dataEntity.getPkValue()}, (OperateOption)operateOption);
        }
    }

    private Boolean needApprove(DynamicObject info) {
        Long compId = (Long)info.getDynamicObject("company").getPkValue();
        String statusStr = (String)TmcParameterHelper.getAppParameter((String)TmcAppEnum.BEI.getId(), (Long)compId, (String)"bei014");
        if (EmptyUtil.isEmpty((String)statusStr)) {
            return false;
        }
        boolean need = false;
        List billStatusList = Stream.of(statusStr.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        DynamicObjectCollection currEntries = info.getDynamicObjectCollection("entrys");
        List updatedRecStream = currEntries.stream().filter(o -> !Objects.equals(o.get("statusnew"), o.get("paystatus"))).collect(Collectors.toList());
        for (String status : billStatusList) {
            need = updatedRecStream.stream().anyMatch(o -> Objects.equals(o.get("statusnew"), status));
            if (!need) continue;
            return need;
        }
        return need;
    }
}

