/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.claim;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.RecClaimHelper;
import kd.tmc.bei.common.enums.ClaimAuthorityEnum;
import kd.tmc.bei.common.enums.ClaimStatusEnum;
import kd.tmc.bei.common.enums.MergeStatusEnum;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.helper.ExtendConfigHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CancelNoticeClaimService
extends AbstractTmcBizOppService {
    private static final String TMC_BEI_BUSINESS = "tmc-bei-business";
    private static final String CLAIM_NO = "claimno";

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("claimnoticebillno");
        selector.add("receredtype");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set<Object> claimCenterIds;
        String claimCenterSelect;
        Object[] noticeBills;
        this.operationResult.setBillCount(dataEntities.length);
        if (EmptyUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        String billType = dataEntities[0].getDataEntityType().getName();
        List<String> noticeNos = this.validTradeDetails(dataEntities);
        if (noticeNos.size() > 0 && EmptyUtil.isNoEmpty((Object[])(noticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)(claimCenterSelect = "id,billno,claimstatus,sourceid,currency,mergestatus,reamount,payamount,oppunit,description,tradetime,tradedetailno,claimnoticebillno,receredtype,entryentity1.claimtype,entryentity1.claimtypeid"), (QFilter[])new QFilter[]{new QFilter("billno", "in", noticeNos)}))) && (claimCenterIds = this.validClaimCenterBills((DynamicObject[])noticeBills, noticeNos)).size() > 0) {
            this.execCancelOp(claimCenterIds, (DynamicObject[])noticeBills, billType);
        }
    }

    private List<String> validTradeDetails(DynamicObject[] dataEntities) {
        ArrayList<String> noticeNos = new ArrayList<String>(dataEntities.length);
        for (DynamicObject transdetail : dataEntities) {
            String claimBillno = transdetail.getString("claimnoticebillno");
            String transDetailno = transdetail.getString("billno");
            if (!EmptyUtil.isEmpty((String)claimBillno)) {
                String receredtype = transdetail.getString("receredtype");
                if ("3".equals(receredtype)) {
                    this.operationResult.addErrorInfo(BeiHelper.getOperateErrorInfo((Object)transdetail.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\u5df2\u786e\u8ba4\uff0c\u4e0d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_8", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]), transDetailno), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_0", (String)TMC_BEI_BUSINESS, (Object[])new Object[0])));
                    continue;
                }
                noticeNos.add(transdetail.getString("claimnoticebillno"));
                continue;
            }
            this.operationResult.addErrorInfo(BeiHelper.getOperateErrorInfo((Object)transdetail.getPkValue(), (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25\u3002\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u5904\u4e8e\u201c\u5f85\u8ba4\u9886\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_1", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]), transDetailno), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_0", (String)TMC_BEI_BUSINESS, (Object[])new Object[0])));
        }
        return noticeNos;
    }

    private Set<Object> validClaimCenterBills(DynamicObject[] noticeBills, List<String> noticeNos) {
        Set claimBillNumbers = QueryServiceHelper.query((String)"cas_claimbill", (String)"id,claimno", (QFilter[])new QFilter(CLAIM_NO, "in", noticeNos).toArray()).stream().map(claimbill -> claimbill.getString(CLAIM_NO)).collect(Collectors.toSet());
        HashSet<Object> claimIds = new HashSet<Object>(noticeBills.length);
        for (DynamicObject noticeBill : noticeBills) {
            if (claimBillNumbers != null && claimBillNumbers.contains(noticeBill.getString("billno"))) {
                this.operationResult.addErrorInfo(BeiHelper.getOperateErrorInfo((Object)noticeBill.getLong("sourceid"), (String)String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u53d1\u8d77\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u4e0d\u5b58\u5728\u672a\u5904\u7406\u7684\u8ba4\u9886\u5355\uff0c\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff01\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%s\uff09\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25\u3002", (String)"CancelNoticeClaimService_10", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]), noticeBill.getString("tradedetailno")), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_0", (String)TMC_BEI_BUSINESS, (Object[])new Object[0])));
                continue;
            }
            if (!ClaimStatusEnum.WAIT.getValue().equals(noticeBill.getString("claimstatus"))) {
                this.operationResult.addErrorInfo(BeiHelper.getOperateErrorInfo((Object)noticeBill.getLong("sourceid"), (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25\u3002\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u5904\u4e8e\u201c\u5f85\u8ba4\u9886\u201d\u72b6\u6001\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_1", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]), noticeBill.getString("tradedetailno")), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_0", (String)TMC_BEI_BUSINESS, (Object[])new Object[0])));
                continue;
            }
            if (MergeStatusEnum.MARFED.getValue().equals(noticeBill.getString("mergestatus"))) {
                this.operationResult.addErrorInfo(BeiHelper.getOperateErrorInfo((Object)noticeBill.getLong("sourceid"), (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u5931\u8d25\u3002\u53ea\u6709\u5df2\u53d1\u8d77\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\uff0c\u4e14\u672a\u88ab\u5408\u5e76\u7684\u4ea4\u6613\u660e\u7ec6\u624d\u80fd\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_9", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]), noticeBill.getString("tradedetailno")), (String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_0", (String)TMC_BEI_BUSINESS, (Object[])new Object[0])));
                continue;
            }
            claimIds.add(noticeBill.getPkValue());
        }
        return claimIds;
    }

    private void execCancelOp(Set<Object> claimCenterIds, DynamicObject[] noticeBills, String billType) {
        OperationResult execOperate = null;
        try (TXHandle tx = TX.requiresNew();){
            execOperate = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)"cas_claimcenterbill", (Object[])claimCenterIds.toArray(), (OperateOption)OperateOption.create());
            if (!execOperate.isSuccess() && execOperate.getAllErrorInfo().size() > 0) {
                this.operationResult.addErrorInfo((OperateErrorInfo)execOperate.getAllErrorInfo().get(0));
            }
        }
        List successPkIds = execOperate.getSuccessPkIds();
        HashMap<Object, Map<String, List<Object>>> messageMap = new HashMap<Object, Map<String, List<Object>>>(successPkIds.size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject noticeBill : noticeBills) {
            if (!successPkIds.contains(noticeBill.getPkValue())) continue;
            Map<String, List<Object>> message = this.genMessage(noticeBill, sdf, billType);
            messageMap.put(noticeBill.getPkValue(), message);
        }
        if (ExtendConfigHelper.shouldSendCancelClaimMsg()) {
            RecClaimHelper.sendClaimNoticeMessage(messageMap, "cancel");
        }
    }

    private Map<String, List<Object>> genMessage(DynamicObject noticeBill, SimpleDateFormat sdf, String billType) {
        DynamicObjectCollection dycoll = noticeBill.getDynamicObjectCollection("entryentity1");
        HashMap<String, List<Object>> message = new HashMap<String, List<Object>>();
        message.put("userids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
        message.put("usergroupids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERGROUP.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
        message.put("orgids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERORG.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
        message.put("roleids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.ROLER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
        BigDecimal amount = "bei_intelrec".equals(billType) ? noticeBill.getBigDecimal("reamount") : noticeBill.getBigDecimal("payamount");
        String amountStr = BeiHelper.formatDecimal((BigDecimal)amount, (int)2);
        String curSign = noticeBill.getDynamicObject("currency").getString("sign");
        String bizType = "bei_intelrec".equals(billType) ? ResManager.loadKDString((String)"\u6536\u6b3e", (String)"CancelNoticeClaimService_3", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"CancelNoticeClaimService_4", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]);
        String title = String.format(ResManager.loadKDString((String)"1\u7b14%1$s\uff08\u91d1\u989d\uff1a%2$s%3$s\uff09\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"CancelNoticeClaimService_5", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]), bizType, curSign, amountStr);
        message.put("title", Collections.singletonList(title));
        String dateStr = "";
        if (EmptyUtil.isNoEmpty((Object)noticeBill.getDate("tradetime"))) {
            dateStr = sdf.format(noticeBill.getDate("tradetime"));
        }
        StringBuilder msgContent = new StringBuilder();
        msgContent.append(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b%1$s\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u8fdb\u5165%2$s\u5165\u8d26\u4e2d\u5fc3\u67e5\u770b\u8be6\u60c5\uff1a", (String)"CancelNoticeClaimService_6", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]), bizType, bizType)).append("\n");
        String content = String.format(ResManager.loadKDString((String)"%1$s\u91d1\u989d\uff1a%2$s%3$s\uff0c\u5bf9\u65b9\u6237\u540d\uff1a%4$s\uff0c\u6458\u8981\uff1a%5$s\uff0c\u4ea4\u6613\u65f6\u95f4\uff1a%6$s\uff0c\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%7$s\uff0c\u8bf7\u77e5\u6089\u3002", (String)"CancelNoticeClaimService_7", (String)TMC_BEI_BUSINESS, (Object[])new Object[0]), bizType, curSign, amountStr, noticeBill.getString("oppunit"), noticeBill.getString("description"), dateStr, noticeBill.getString("tradedetailno"));
        msgContent.append(content);
        message.put("content", Collections.singletonList(msgContent.toString()));
        message.put("billtype", Collections.singletonList(billType + "_list"));
        return message;
    }
}

