/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.bei.business.ebservice.EBBalanceQueryService;
import kd.tmc.bei.business.opservice.helper.ErrorInfoHelper;
import kd.tmc.bei.business.opservice.param.BalanceQueryParam;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;

public class CheckdetailOnlineService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(CheckdetailOnlineService.class);

    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("id");
        list.add("currency");
        list.add("bizdate");
        return list;
    }

    public void process(DynamicObject[] data) throws KDException {
        List seqList = (List)SerializationUtils.fromJsonString((String)((String)this.operationVariable.get("selected")), List.class);
        DynamicObjectCollection balances = (DynamicObjectCollection)data[0].get("entryentity");
        ArrayList<OperateErrorInfo> errors = new ArrayList<OperateErrorInfo>();
        for (DynamicObject balance : balances) {
            List<Long> idList;
            Date bizdate;
            if (!seqList.contains((Integer)balance.get("seq") - 1)) continue;
            OperationResult operationResult = new OperationResult();
            DynamicObject currency = balance.getDynamicObject("currency");
            BalanceQueryParam balanceQueryParam = new BalanceQueryParam(currency, bizdate = balance.getDate("bizdate"), bizdate, idList = Collections.singletonList((Long)balance.getDynamicObject("accountbank").getPkValue()));
            List<BalanceResult> balanceResults = new EBBalanceQueryService(balanceQueryParam).queryBatchBalance();
            List<OperateErrorInfo> operateErrorInfos = ErrorInfoHelper.convertBalanceErrorInfos(balanceResults);
            if (!CollectionUtils.isEmpty(operateErrorInfos)) {
                this.operationResult.setSuccess(false);
                this.operationResult.setAllErrorInfo(operateErrorInfos);
                this.operationResult.setShowMessage(false);
                errors.addAll(operateErrorInfos);
                continue;
            }
            this.operationResult.setSuccess(true);
        }
        if (errors.size() > 0) {
            StringBuilder s = new StringBuilder();
            for (IOperateInfo iOperateInfo : errors) {
                s.append('\n').append(iOperateInfo.getMessage());
            }
            this.operationResult.setShowMessage(false);
            throw new BEBizException(new BeErrorCode().ONLINEQUERY_ERROR(), (Object[])new String[]{s.toString()});
        }
    }
}

