/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.sdk.tmc.bei.extpoint.balance.IGenHistoryBalanceInterface;
import kd.tmc.bei.business.helper.TransDetailHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DetailGenerateBalanceService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(DetailGenerateBalanceService.class);
    private static ExecutorService service = ThreadPools.newExecutorService((String)"DetailGenerateBalanceService", (int)3);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("issetbankinterface");
        selector.add("bank");
        selector.add("company");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set<Long> extAccountBankIds = this.getExtAccountBankIds();
        String cycle = (String)this.operationVariable.get("schedule_cycle");
        HashSet<Object> totalQueryBankIds = new HashSet<Object>(16);
        List accountBankSet = Arrays.stream(dataEntities).filter(e -> !e.getBoolean("issetbankinterface")).collect(Collectors.toList());
        Set accountBankIds = accountBankSet.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFilter settCenterSetting = new QFilter("settlecenter", "is not null", null);
        DynamicObjectCollection setCenterSettings = QueryServiceHelper.query((String)"ifm_settcentersetting", (String)"settlecenter.id as settlecenter", (QFilter[])new QFilter[]{settCenterSetting});
        Set settlecenter = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)setCenterSettings)) {
            settlecenter = setCenterSettings.stream().map(s -> s.getLong("settlecenter")).collect(Collectors.toSet());
        }
        if (EmptyUtil.isNoEmpty(settlecenter)) {
            Set finalSettlecenter = settlecenter;
            accountBankIds = accountBankSet.stream().filter(e -> !finalSettlecenter.contains(e.getDynamicObject("bank").getLong("id"))).map(t -> t.getLong("id")).collect(Collectors.toSet());
        }
        if (!EmptyUtil.isEmpty(accountBankIds)) {
            totalQueryBankIds.addAll(accountBankIds);
        }
        if (!EmptyUtil.isEmpty(extAccountBankIds)) {
            totalQueryBankIds.addAll(extAccountBankIds);
        }
        if (!EmptyUtil.isEmpty(totalQueryBankIds)) {
            QFilter qFilter = new QFilter("id", "in", totalQueryBankIds);
            DynamicObjectCollection accountbanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,company.id", (QFilter[])new QFilter[]{qFilter});
            Map<Long, List<DynamicObject>> accountbanksGroupByCompany = accountbanks.stream().collect(Collectors.groupingBy(e -> e.getLong("company.id")));
            for (Map.Entry<Long, List<DynamicObject>> entry : accountbanksGroupByCompany.entrySet()) {
                Long companyId = entry.getKey();
                List<DynamicObject> accountList = entry.getValue();
                logger.info("DetailGenerateBalanceService\u7684companyId\uff1a{}", (Object)companyId);
                String genBanlanceWay = (String)TmcParameterHelper.getAppParameter((String)TmcAppEnum.BEI.getId(), (Long)companyId, (String)"bei010");
                logger.info("DetailGenerateBalanceService\u7684genBanlanceWay\uff1a{}", (Object)genBanlanceWay);
                if (!StringUtils.equals((CharSequence)genBanlanceWay, (CharSequence)"1")) continue;
                Long companyStartTime = System.currentTimeMillis();
                logger.info("\u5f53\u524d\u7ec4\u7ec7ID=[{}]\uff0c\u5f00\u59cb\u6267\u884c\u3002\u3002\u3002", (Object)companyId);
                List acctIds = accountList.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
                int taskSize = 200;
                List taskList = Lists.partition(acctIds, (int)taskSize);
                CountDownLatch countDownLatch = new CountDownLatch(taskList.size());
                logger.info("DetailGenerateBalanceService,\u5f53\u524d\u7ec4\u7ec7ID=[{}],\u6b64\u6b21\u4efb\u52a1\u603b\u6570=[{}],\u5904\u7406\u6279\u6b21=[{}],\u7ebf\u7a0b\u4efb\u52a1\u6570=[{}]", new Object[]{companyId, acctIds.size(), taskList.size(), taskSize});
                QFilter genBalanceLogQfilter = new QFilter("accountbank", "in", acctIds);
                DynamicObject[] genBalanceLogArray = BusinessDataServiceHelper.load((String)"bei_genbalance_log", (String)"id,accountbank,currency,lastupdatetime,deletetime,balancedeletetime,initdate", (QFilter[])new QFilter[]{genBalanceLogQfilter});
                Map<String, List<DynamicObject>> genBalanceLogGroupByAccCurr = Arrays.stream(genBalanceLogArray).collect(Collectors.groupingBy(e -> e.getDynamicObject("accountbank").getString("bankaccountnumber") + "#" + e.getDynamicObject("currency").getString("number")));
                int i = 0;
                while (i < taskList.size()) {
                    List partOfAcctIds = (List)taskList.get(i);
                    int index = i++;
                    service.submit(() -> TransDetailHelper.detailGenerateBalance(companyId, partOfAcctIds, cycle, countDownLatch, index, genBalanceLogGroupByAccCurr));
                }
                try {
                    countDownLatch.await();
                }
                catch (Exception e2) {
                    logger.info("DetailGenerateBalanceService\u6267\u884c\u5f02\u5e38\uff1a", (Object)e2);
                    throw new KDBizException(e2.getMessage());
                }
                finally {
                    logger.info("\u5f53\u524d\u7ec4\u7ec7ID=[{}]\uff0c\u6267\u884c\u7ed3\u675f\uff0c\u8017\u65f6=[{}]", (Object)companyId, (Object)(System.currentTimeMillis() - companyStartTime));
                }
            }
        }
    }

    public Set<Long> getExtAccountBankIds() {
        PluginProxy pluginProxy = PluginProxy.create(IGenHistoryBalanceInterface.class, (String)"kd.sdk.tmc.bei.extpoint.balance.IGenHistoryBalanceInterface");
        List resultList = pluginProxy.callReplace(IGenHistoryBalanceInterface::getExtAccountBankIds);
        if (EmptyUtil.isNoEmpty((Object)resultList)) {
            return (Set)resultList.get(0);
        }
        return null;
    }
}

