/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sdk.tmc.bei.util.MatchResultBean;
import kd.sdk.tmc.bei.util.RecPayRuleMatchUtil;
import kd.tmc.bei.business.helper.CasFlowConfirmLogHelper;
import kd.tmc.bei.business.helper.RecClaimHelper;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.helper.ExtendConfigHelper;
import kd.tmc.bei.common.helper.OperateServiceHelper;
import kd.tmc.bei.common.param.ClaimNoticeMesParam;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcAppCache;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class NoticeClaimService
extends AbstractTmcBizOppService {
    private static final IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");
    private static final Log LOGGER = LogFactory.getLog(NoticeClaimService.class);
    private List<Object> successPkIdList = new ArrayList<Object>(10);

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(3);
        lst.add("receredtype");
        lst.add("claimnoticebillno");
        lst.add("debitamount");
        lst.add("creditamount");
        lst.add("rulename");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> successDetails = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> failIds = new ArrayList<DynamicObject>(10);
        HashMap<String, String> ruleNotice = new HashMap<String, String>(16);
        Object[] unNoticeIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        List matchResultBeanList = RecPayRuleMatchUtil.matchNoticeClaim((Object[])unNoticeIds);
        Set entryRuleIdSet = matchResultBeanList.stream().map(MatchResultBean::getEntryRuleId).collect(Collectors.toSet());
        Map<Object, MatchResultBean> matchResultBeanMap = matchResultBeanList.stream().collect(Collectors.toMap(MatchResultBean::getId, e -> e, (v1, v2) -> v2));
        DynamicObjectCollection ruleList = QueryServiceHelper.query((String)"cas_recpayrule", (String)"entryentity.id,entryentity.e_savenotifi_TAG", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", entryRuleIdSet)});
        Map<Object, DynamicObject> ruleMap = ruleList.stream().collect(Collectors.toMap(e -> e.get("entryentity.id"), e -> e, (v1, v2) -> v2));
        for (DynamicObject dataEntity : dataEntities) {
            Object id = dataEntity.getPkValue();
            DynamicObject ruleResult = null;
            MatchResultBean matchResultBean = matchResultBeanMap.get(id);
            String ruleName = " ";
            if (matchResultBean != null) {
                ruleResult = ruleMap.get(matchResultBean.getEntryRuleId());
                ruleName = matchResultBean.getNewRuleName();
            }
            if (ruleResult != null) {
                String notify = ruleResult.getString("entryentity.e_savenotifi_TAG");
                if (StringUtils.isNotBlank((CharSequence)notify)) {
                    successDetails.add(dataEntity);
                    cache.put(id.toString(), (Object)notify);
                    ruleNotice.put(id.toString(), notify);
                    cache.put(id + "rulesname", (Object)ruleName);
                    continue;
                }
                failIds.add(dataEntity);
                continue;
            }
            failIds.add(dataEntity);
        }
        if (!successDetails.isEmpty()) {
            LOGGER.info("pushandsave:{}", successDetails);
            OperationResult operationResult = OperateServiceHelper.execOperateWithoutThrow((String)"pushandsave", (String)"bei_transdetail_cas", (Object[])successDetails.stream().map(e -> e.get("id")).toArray(), (OperateOption)OperateOption.create());
            this.successPkIdList = operationResult.getSuccessPkIds();
            LOGGER.info("notice");
            List allErrorOrValidateInfoList = operationResult.getAllErrorOrValidateInfo();
            if (!allErrorOrValidateInfoList.isEmpty()) {
                allErrorOrValidateInfoList.forEach(errInfo -> {
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setPkValue(errInfo.getPkValue());
                    operateErrorInfo.setTitle(errInfo.getTitle());
                    operateErrorInfo.setMessage(errInfo.getMessage());
                    this.operationResult.addErrorInfo(operateErrorInfo);
                });
            }
            if (ExtendConfigHelper.shouldSendClaimMsg()) {
                this.noticeMessage(ruleNotice);
            }
        }
        if (!failIds.isEmpty()) {
            failIds.forEach(detail -> {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setPkValue(detail.getPkValue());
                operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u6309\u65b9\u6848\u901a\u77e5\u8ba4\u9886\uff0c\u53ef\u80fd\u662f\u672a\u8fdb\u884c\u89c4\u5219\u8bbe\u7f6e\uff0c\u6216\u672a\u9002\u914d\u5230\u65b9\u6848\u3002\u53ef\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f\u540e\u53d1\u8d77\u901a\u77e5\u3002", (String)"ClaimRecWorkbenchList_1", (String)"tmc-bei-business", (Object[])new Object[0]), detail.get("billno")));
                this.operationResult.addErrorInfo(operateErrorInfo);
            });
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        this.operationResult.setSuccessPkIds(this.successPkIdList);
        try (TXHandle tx = TX.requiresNew();){
            CasFlowConfirmLogHelper.saveNoticeLog(this.successPkIdList.stream().map(id -> (Long)id).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void noticeMessage(Map<String, String> ruleNotice) {
        ArrayList ruleList = new ArrayList(ruleNotice.size());
        HashSet allUserId = new HashSet();
        for (Map.Entry<String, String> rule : ruleNotice.entrySet()) {
            Map map = (Map)SerializationUtils.fromJsonString((String)rule.getValue(), Map.class);
            List userGroupids = (List)map.get("usergroupids");
            List list = (List)map.get("orgids");
            List list2 = (List)map.get("roleids");
            List userids = (List)map.get("userids");
            HashSet userIds = new HashSet();
            if (!EmptyUtil.isEmpty((Collection)userGroupids)) {
                for (Long userGroupid : userGroupids) {
                    DynamicObjectCollection userGroups = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userGroupid).and("enable", "=", (Object)"1")}, null);
                    Map enableMap = UserServiceHelper.isUserEnable(userGroups.stream().map(o -> o.getLong("entryentity.userfield")).collect(Collectors.toList()));
                    List enableUserIds = enableMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                    userIds.addAll(enableUserIds);
                }
            }
            if (!EmptyUtil.isEmpty((Collection)list)) {
                userIds.addAll(UserServiceHelper.getAllUsersOfOrg((int)0, (List)list, (boolean)true, (boolean)false));
            }
            if (!EmptyUtil.isEmpty((Collection)list2)) {
                for (String roleid : list2) {
                    userIds.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(roleid)));
                }
            }
            if (!EmptyUtil.isEmpty((Collection)userids)) {
                List selectUserIds = userids.stream().filter(EmptyUtil::isNoEmpty).map(u -> Long.valueOf(u.toString())).collect(Collectors.toList());
                Map enableMap = UserServiceHelper.isUserEnable(selectUserIds);
                List enableUserIds = enableMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                userIds.addAll(enableUserIds);
            }
            ruleList.add(userIds);
            allUserId.addAll(userIds);
        }
        HashMap<Object, Integer> userCount = new HashMap<Object, Integer>(allUserId.size());
        int count = 0;
        for (Object userId : allUserId) {
            count = 0;
            for (Set set : ruleList) {
                if (!set.contains(userId)) continue;
                ++count;
            }
            userCount.put(userId, count);
        }
        HashMap noticeUsers = new HashMap(userCount.size());
        for (Map.Entry entry : userCount.entrySet()) {
            void var9_21;
            Set set = (Set)noticeUsers.get(entry.getValue());
            if (EmptyUtil.isEmpty((Collection)set)) {
                HashSet hashSet = new HashSet();
            }
            var9_21.add(entry.getKey());
            noticeUsers.put(entry.getValue(), var9_21);
        }
        StringBuilder msgContent = new StringBuilder();
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"claimnoticebillno,creditamount,debitamount,bizdate,oppunit,billno,currency.sign currencysign", (QFilter[])new QFilter("id", "in", this.successPkIdList).toArray());
        msgContent.append(ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165\u201c\u8d44\u91d1\u7ed3\u7b97\u201d\u6216\u201c\u51fa\u7eb3\u201d\u5e94\u7528\uff0c\u201c\u6536\u4ed8\u8ba4\u9886->\u8ba4\u9886\u516c\u544a\u201d\u83dc\u5355\u8fdb\u884c\u5904\u7406\u3002", (String)"NoticeClaimService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
        for (DynamicObject detail : dynamicObjectCollection) {
            msgContent.append("\n");
            BigDecimal recAmount = detail.getBigDecimal("creditamount");
            BigDecimal payAmount = detail.getBigDecimal("debitamount");
            String claimBillNo = detail.getString("claimnoticebillno");
            String currencySign = detail.getString("currencysign");
            String bizType = recAmount.compareTo(BigDecimal.ZERO) != 0 ? ResManager.loadKDString((String)"\u6536\u6b3e", (String)"NoticeClaimService_2", (String)"tmc-bei-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"NoticeClaimService_3", (String)"tmc-bei-business", (Object[])new Object[0]);
            BigDecimal amount = recAmount.compareTo(BigDecimal.ZERO) != 0 ? recAmount : payAmount;
            String amountStr = BeiHelper.formatDecimal((BigDecimal)amount, (int)2);
            String msg = String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\uff1a%1$s\uff0c%2$s\u91d1\u989d\uff1a%3$s%4$s\uff0c\u5bf9\u65b9\u6237\u540d\uff1a%5$s\uff0c\u4ea4\u6613\u65f6\u95f4\uff1a%6$s\uff0c\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%7$s\u3002", (String)"NoticeClaimService_4", (String)"tmc-bei-business", (Object[])new Object[0]), claimBillNo, bizType, currencySign, amountStr, detail.getString("oppunit"), DateUtils.formatString((Date)detail.getDate("bizdate"), (String)"yyyy-MM-dd"), detail.getString("billno"));
            msgContent.append(msg);
        }
        for (Map.Entry notice : noticeUsers.entrySet()) {
            ClaimNoticeMesParam param = new ClaimNoticeMesParam();
            param.setTag(ResManager.loadKDString((String)"\u6536\u4ed8\u8ba4\u9886", (String)"NoticeClaimService_5", (String)"tmc-bei-business", (Object[])new Object[0]));
            param.setTitle(String.format(ResManager.loadKDString((String)"%s\u7b14\u6b3e\u9879\u9700\u8981\u8ba4\u9886\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406", (String)"NoticeClaimService_6", (String)"tmc-bei-business", (Object[])new Object[0]), notice.getKey()));
            param.setContent(msgContent.toString());
            param.setUserIds((Set)notice.getValue());
            param.setNoticeType("notice");
            RecClaimHelper.sendNoticeMessage(param);
        }
    }
}

