/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.bei.business.ebservice.EBBalanceQueryService;
import kd.tmc.bei.business.opservice.helper.ErrorInfoHelper;
import kd.tmc.bei.business.opservice.param.BalanceQueryParam;
import kd.tmc.bei.business.opservice.result.BalanceResult;

public class SyncBalanceTask
implements Runnable {
    private static Log logger = LogFactory.getLog(SyncBalanceTask.class);
    private Date startDate;
    private Date endDate;
    private OperationResult operationResult;
    private List<DynamicObject> accountBanks;

    public SyncBalanceTask(Date startDate, Date endDate, OperationResult operationResult, List<DynamicObject> accountBanks) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.operationResult = operationResult;
        this.accountBanks = accountBanks;
    }

    @Override
    public void run() {
        try {
            List<Long> idList = this.accountBanks.stream().map(d -> (Long)d.getPkValue()).collect(Collectors.toList());
            logger.info("\u5f02\u6b65\u4e0b\u8f7d\u4f59\u989d\u5f00\u59cb\uff0caccountBankIds:{}, startDate:{}, endDate:{}", new Object[]{idList, this.startDate, this.endDate});
            BalanceQueryParam balanceQueryParam = new BalanceQueryParam(null, this.startDate, this.endDate, idList);
            List<BalanceResult> balanceResults = new EBBalanceQueryService(balanceQueryParam).queryBatchBalance();
            List<OperateErrorInfo> operateErrorInfos = ErrorInfoHelper.convertBalanceErrorInfos(balanceResults);
            if (!CollectionUtils.isEmpty(operateErrorInfos)) {
                this.operationResult.setSuccess(false);
                this.operationResult.setAllErrorInfo(operateErrorInfos);
                this.operationResult.setShowMessage(false);
            } else {
                this.operationResult.setSuccess(true);
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u6b65\u4e0b\u8f7d\u4f59\u989d\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(this.accountBanks.size());
            for (DynamicObject dataEntity : this.accountBanks) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.FatalError);
                operateErrorInfo.setMessage(e.getMessage());
                operateErrorInfo.setPkValue(dataEntity.getPkValue());
                errorInfos.add(operateErrorInfo);
            }
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        }
    }
}

