/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;
import kd.tmc.fbp.service.ebservice.exception.BEBizException;

public class SyncReceiptTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(SyncReceiptTask.class);
    private Date beginDate;
    private Date endDate;
    private OperationResult operationResult;
    private List<DynamicObject> accountBanks;

    public SyncReceiptTask(Date startdate, Date enddate, OperationResult operationResult, List<DynamicObject> accountBanks) {
        this.beginDate = startdate;
        this.endDate = enddate;
        this.operationResult = operationResult;
        this.accountBanks = accountBanks;
    }

    @Override
    public void run() {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        ErrorCode errorCode = new BeErrorCode().COMMON();
        String receiptLock = new BeiBizResource().getReceipt_Lock();
        for (DynamicObject accountBank : this.accountBanks) {
            if (accountBank == null) continue;
            String bankNumber = accountBank.getString("bankaccountnumber");
            String bankAcctId = accountBank.getString("id");
            boolean isSuccess = MutexServiceHelper.request((String)bankAcctId, (String)"bd_accountbanks", (String)"op_receipt");
            if (isSuccess) {
                try {
                    DynamicObjectCollection currencyColl = accountBank.getDynamicObjectCollection("currency");
                    for (DynamicObject currency : currencyColl) {
                        try {
                            OperateErrorInfo operateErrorInfo = AccountBankHelper.downReceipt(accountBank, currency = currency.getDynamicObject("fbasedataid"), this.beginDate, this.endDate);
                            if (null == operateErrorInfo) continue;
                            errorInfos.add(operateErrorInfo);
                        }
                        catch (Exception e) {
                            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                            operateErrorInfo.setLevel(ErrorLevel.Error);
                            operateErrorInfo.setMessage("\n" + String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u540c\u6b65\u8d26\u53f7%1$s\uff0c\u5e01\u79cd%2$s\uff0c\u9519\u8bef\u65e5\u5fd7\uff1a%3$s\u3002", (String)"SyncReceiptTask_0", (String)"tmc-bei-business", (Object[])new Object[0]), bankNumber, currency.getString("number"), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                            operateErrorInfo.setPkValue((Object)Long.valueOf(bankAcctId));
                            errorInfos.add(operateErrorInfo);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    this.operationResult.setMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    this.operationResult.setSuccess(false);
                    throw new BEBizException(errorCode, (Object[])new String[]{e.getMessage()});
                }
                finally {
                    MutexServiceHelper.release((String)bankAcctId, (String)"bd_accountbanks", (String)"op_receipt");
                    continue;
                }
            }
            String message = String.format(receiptLock, bankNumber);
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(message);
            operateErrorInfo.setPkValue((Object)Long.valueOf(bankAcctId));
            errorInfos.add(operateErrorInfo);
        }
        if (!errorInfos.isEmpty()) {
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        } else {
            this.operationResult.setSuccess(true);
        }
    }
}

