/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.bei.business.helper.AccountBankHelper;

public class SyncTransDetailTask
implements Runnable {
    private Date startdate;
    private Date enddate;
    private OperationResult operationResult;
    private DynamicObjectCollection accountbanks;
    private boolean downloadFromBank;

    public SyncTransDetailTask(Date startdate, Date enddate, OperationResult operationResult, DynamicObjectCollection accountbanks) {
        this.startdate = startdate;
        this.enddate = enddate;
        this.operationResult = operationResult;
        this.accountbanks = accountbanks;
    }

    public SyncTransDetailTask(Date startdate, Date enddate, OperationResult operationResult, DynamicObjectCollection accountbanks, boolean downloadFromBank) {
        this.startdate = startdate;
        this.enddate = enddate;
        this.operationResult = operationResult;
        this.accountbanks = accountbanks;
        this.downloadFromBank = downloadFromBank;
    }

    @Override
    public void run() {
        int len = 0;
        try {
            DynamicObjectCollection list = new ArrayList();
            if (this.accountbanks instanceof MulBasedataDynamicObjectCollection) {
                for (DynamicObject acctbanks : this.accountbanks) {
                    list.add(acctbanks.getDynamicObject("fbasedataid"));
                }
            } else {
                list = this.accountbanks;
            }
            len = list.size();
            List<OperateErrorInfo> operateErrorInfos = AccountBankHelper.downTransDetailsSync((List<DynamicObject>)list, this.startdate, this.enddate, false, this.downloadFromBank);
            if (!CollectionUtils.isEmpty(operateErrorInfos)) {
                this.operationResult.setSuccess(false);
                this.operationResult.setAllErrorInfo(operateErrorInfos);
                this.operationResult.setShowMessage(false);
            } else {
                this.operationResult.setSuccess(true);
            }
        }
        catch (Exception e) {
            ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(len);
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(e.getMessage());
            errorInfos.add(operateErrorInfo);
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfos);
            this.operationResult.setShowMessage(false);
        }
    }
}

