/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.tmc.bei.util.MatchResultBean;
import kd.sdk.tmc.bei.util.RecPayRuleMatchUtil;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.CasFlowConfirmLogHelper;
import kd.tmc.bei.business.service.factory.AutoMatchServiceFactory;
import kd.tmc.bei.common.enums.FlowOperateTypeEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.helper.AmountHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.GenBankcheckCode;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailMatchBillService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(TransDetailMatchBillService.class);
    List<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(10);

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(26);
        lst.add("bankcheckflag");
        lst.add("recedbillnumber");
        lst.add("recedbilltype");
        lst.add("bizdate");
        lst.add("detailid");
        lst.add("debitamount");
        lst.add("creditamount");
        lst.add("receredway");
        lst.add("receredtype");
        lst.add("iskdretflag");
        lst.add("rulename");
        lst.add("accountbank.id");
        lst.add("accountbank");
        lst.add("currency");
        lst.add("isdowntobankstate");
        lst.add("receredtype");
        lst.add("company");
        lst.add("oppbanknumber");
        lst.add("oppunit");
        lst.addAll(AutoMatchHelper.getMatchFieldKeys());
        return lst;
    }

    /*
     * WARNING - void declaration
     */
    public void process(DynamicObject[] dynamicObjects) throws KDException {
        DynamicObject[] transUpBillArr;
        DynamicObject[] recBillArr;
        DynamicObject[] transHandleBillArr;
        DynamicObject[] transDownBillArr;
        DynamicObject[] agentBillArr;
        Map detailBankCheckFlagMap = new HashMap(1);
        boolean isFromDownLoad = false;
        if (this.getOperationVariable().containsKey("fromDownload") && null != this.getOperationVariable().get("fromDownload")) {
            isFromDownLoad = true;
            String detailBankCheckFlagMapJsonStr = (String)this.getOperationVariable().get("detailBankCheckFlagMap");
            if (StringUtils.isNotEmpty((String)detailBankCheckFlagMapJsonStr)) {
                detailBankCheckFlagMap = (Map)SerializationUtils.fromJsonString((String)detailBankCheckFlagMapJsonStr, Map.class);
            }
        }
        logger.info("process isFromDownLoad is that:" + isFromDownLoad);
        HashSet<String> bankCheckFlagSet = new HashSet<String>(detailBankCheckFlagMap.size() + dynamicObjects.length);
        bankCheckFlagSet.addAll(detailBankCheckFlagMap.values());
        bankCheckFlagSet.addAll(Arrays.stream(dynamicObjects).map(o -> o.getString("bankcheckflag")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
        Set<Object> accountIdSet = Arrays.stream(dynamicObjects).map(d -> {
            Long aId = 0L;
            if (d.get("accountbank") instanceof Long) {
                aId = d.getLong("accountbank");
            } else if (d.get("accountbank") instanceof DynamicObject) {
                aId = d.getDynamicObject("accountbank").getLong("id");
            }
            return aId;
        }).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        DynamicObject[] payBillArr = this.getBills(MatchBizTypeEnum.PAY, bankCheckFlagSet, accountIdSet);
        if (null != payBillArr) {
            logger.info("process payBillArr size is:" + payBillArr.length);
        }
        if (null != (agentBillArr = this.getBills(MatchBizTypeEnum.AGENTPAY, bankCheckFlagSet, accountIdSet))) {
            logger.info("process agentBillArr size is that:" + agentBillArr.length);
        }
        if (null != (transDownBillArr = this.getBills(MatchBizTypeEnum.TRANSDOWN, bankCheckFlagSet, accountIdSet))) {
            logger.info("process transdownBillArr size is that:" + transDownBillArr.length);
        }
        if (null != (transHandleBillArr = this.getBills(MatchBizTypeEnum.TRANSHANDLE, bankCheckFlagSet, accountIdSet))) {
            logger.info("process transhandleBillArr size is that:" + transHandleBillArr.length);
        }
        if (null != (recBillArr = this.getBills(MatchBizTypeEnum.REC, bankCheckFlagSet, accountIdSet))) {
            logger.info("process recBillArr size is:" + recBillArr.length);
        }
        if (null != (transUpBillArr = this.getBills(MatchBizTypeEnum.TRANSUP, bankCheckFlagSet, accountIdSet))) {
            logger.info("process transupBillArr size is that:" + transUpBillArr.length);
        }
        String opNumber = DB.genGlobalLongId() + "";
        if (isFromDownLoad) {
            void var16_23;
            List matchResultBeanList;
            String operationType = (String)this.getOperationVariable().get("operationType");
            logger.info("process operationType is:{}", (Object)operationType);
            Set matchBizDetailIds = new HashSet(1);
            Set matchRuleDetailIds = new HashSet(1);
            if (Objects.equals(operationType, "update")) {
                String matchRuleDetailIdsStr;
                String string = (String)this.getOperationVariable().get("matchBizDetailIds");
                if (StringUtils.isNotEmpty((String)string)) {
                    matchBizDetailIds = (Set)SerializationUtils.fromJsonString((String)string, Set.class);
                }
                if (StringUtils.isNotEmpty((String)(matchRuleDetailIdsStr = (String)this.getOperationVariable().get("matchRuleDetailIds")))) {
                    matchRuleDetailIds = (Set)SerializationUtils.fromJsonString((String)matchRuleDetailIdsStr, Set.class);
                }
            }
            for (DynamicObject info : dynamicObjects) {
                logger.info("TransDetailMatchBillService,params:{}", (Object)info.getString("billno"));
                String detailId = info.getString("detailid");
                if (Objects.equals(operationType, "update") && !matchBizDetailIds.contains(detailId) && StringUtils.isNotEmpty((String)info.getString("recedbillnumber"))) continue;
                String billNo = info.getString("billno");
                String bankCheckFlagStr = (String)detailBankCheckFlagMap.get(detailId);
                if (StringUtils.isNotEmpty((String)bankCheckFlagStr)) {
                    logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u7801\uff1a{},\u4e0b\u8f7d\u56de\u6765\u7684\u5bf9\u8d26\u6807\u8bc6\u7801\u4e3a\uff1a{}", (Object)billNo, (Object)bankCheckFlagStr);
                    info.set("iskdretflag", (Object)"1");
                    info.set("bankcheckflag", (Object)bankCheckFlagStr);
                    this.dealDetailDataByCasBills(payBillArr, agentBillArr, recBillArr, transDownBillArr, transHandleBillArr, transUpBillArr, info, opNumber);
                } else {
                    String bankCheckFlag = info.getString("bankcheckflag");
                    logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u7801:{},\u5bf9\u8d26\u6807\u8bc6\u7801\uff1a{}", (Object)billNo, (Object)bankCheckFlag);
                    if (StringUtils.isEmpty((String)bankCheckFlag)) {
                        String genCode = GenBankcheckCode.genCode();
                        logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u7801:{},\u81ea\u5df1\u751f\u6210\u7684\u5bf9\u8d26\u6807\u8bc6\u7801\u4e3a\uff1a{}" + genCode, (Object)billNo, (Object)genCode);
                        info.set("bankcheckflag", (Object)genCode);
                    }
                }
                this.updateReceivedType(info);
            }
            Object var16_21 = null;
            List matchIds = this.tAutoMatchInfoList.stream().map(AutoMatchInfoParam::getTransDetailId).collect(Collectors.toList());
            HashSet finalMatchRuleDetailIds = matchRuleDetailIds;
            Object[] ids = Arrays.stream(dynamicObjects).filter(o -> !o.getString("receredtype").equals(ReceredtypeEnum.ACCOUNTED.getValue()) && !matchIds.contains(o.getLong("id")) && !Objects.equals(operationType, "update") || finalMatchRuleDetailIds.contains(o.getString("detailid"))).map(DataEntityBase::getPkValue).distinct().toArray();
            if (ids.length != 0 && (matchResultBeanList = RecPayRuleMatchUtil.match((Object[])ids)) != null) {
                Map<Object, String> map = matchResultBeanList.stream().collect(Collectors.toMap(MatchResultBean::getId, MatchResultBean::getNewRuleName, (a, b) -> a));
            }
            if (var16_23 != null) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (!var16_23.containsKey(dynamicObject.getPkValue())) continue;
                    dynamicObject.set("rulename", var16_23.get(dynamicObject.getPkValue()));
                }
            }
            TmcDataServiceHelper.save((DynamicObject[])dynamicObjects);
        } else {
            logger.info("\u5185\u90e8\u91d1\u878d\u6216\u8005\u5217\u8868\u4fa7\u5904\u7406\u540e\u7684\u4ea4\u6613\u660e\u7ec6\u7684\u96c6\u5408newDetailSet\u6570\u91cf\u4e3a{}", (Object)dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                String bankCheckFlagStr = dynamicObject.getString("bankcheckflag");
                logger.info("\u4ea4\u6613\u660e\u7ec6\u7f16\u7801:{},\u5185\u90e8\u91d1\u878d\u6216\u8005\u5217\u8868\u4fa7\u8fdb\u6765\u7684\u5bf9\u8d26\u6807\u8bc6\u7801\u4e3a\uff1a{}", (Object)dynamicObject.getString("billno"), (Object)bankCheckFlagStr);
                if (StringUtils.isEmpty((String)bankCheckFlagStr) || StringUtils.isNotEmpty((String)dynamicObject.getString("recedbillnumber"))) continue;
                this.dealDetailDataByCasBills(payBillArr, agentBillArr, recBillArr, transDownBillArr, transHandleBillArr, transUpBillArr, dynamicObject, opNumber);
            }
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        if (!this.tAutoMatchInfoList.isEmpty()) {
            AutoMatchServiceFactory.getAutoMatchService().execute(this.tAutoMatchInfoList, ReceredWayEnum.BEIPAY.getValue(), null, true, null);
            CasFlowConfirmLogHelper.saveAutoMatchLog(Arrays.asList(dataEntities), this.tAutoMatchInfoList, FlowOperateTypeEnum.BEIPAY.getValue());
        }
    }

    private DynamicObject[] getBills(MatchBizTypeEnum tMatchBizType, Set<String> bankcheckflagSet, Set<Object> accountIdSet) {
        String tBillEntityKey = this.getBillEntityKey(tMatchBizType);
        if (tBillEntityKey == null) {
            return new DynamicObject[0];
        }
        QFilter billFilter = AutoMatchHelper.getBillFilter(tMatchBizType, true, accountIdSet, null);
        QFilter bankcheckflagFilter = AutoMatchHelper.getBankCheckFlagFilter(tMatchBizType, false);
        if (bankcheckflagFilter != null) {
            bankcheckflagFilter.and(AutoMatchHelper.getBankCheckFlagFilter(tMatchBizType, bankcheckflagSet));
        } else {
            bankcheckflagFilter = AutoMatchHelper.getBankCheckFlagFilter(tMatchBizType, bankcheckflagSet);
        }
        String billMatchField = String.join((CharSequence)",", AutoMatchHelper.getBillFieldList(tBillEntityKey));
        String billField = this.getBillField(tBillEntityKey);
        return BusinessDataServiceHelper.load((String)tBillEntityKey, (String)String.join((CharSequence)",", billField, billMatchField), (QFilter[])new QFilter[]{billFilter, bankcheckflagFilter});
    }

    private String getBillField(String tBillEntityKey) {
        if ("cas_paybill".equals(tBillEntityKey)) {
            return "id,billno,billtype,acttradedate,bankcheckflag,actpayamt,paydate,dpcurrency,payeracctbank,bankcheckentity.ebankcheckflag";
        }
        if ("cas_agentpaybill".equals(tBillEntityKey)) {
            return "id,billno,billtype,acttradedate,bankcheckflag,payamount,paytime,dpcurrency,payeracctbank,entry,entry.e_bankcheckflag,entry.e_encryptamount,entry.e_paytime,bankcheckentity.ebankcheckflag";
        }
        if ("fca_transdownbill".equals(tBillEntityKey)) {
            return "id,billno,currency,accountbank,entrys.transamt,entrys.bankcheckflag";
        }
        if ("ifm_transhandlebill".equals(tBillEntityKey)) {
            return "id,billno,currency,agentpayeraccount,actpayamt,beibankcheckflag";
        }
        if ("cas_recbill".equals(tBillEntityKey)) {
            return "id,billno,currency,acttradedate,bankcheckflag,payeedate,actrecamt,accountbank,bankcheckentity.ebankcheckflag";
        }
        if ("fca_transupbill".equals(tBillEntityKey)) {
            return "id,billno,currency,accountbank,entrys.transamt,entrys.bankcheckflag";
        }
        return EntityMetadataCache.getDataEntityType((String)tBillEntityKey).getProperties().stream().map(IMetadata::getName).collect(Collectors.joining(","));
    }

    private String getBillEntityKey(MatchBizTypeEnum tMatchBizType) {
        if (MatchBizTypeEnum.PAY == tMatchBizType) {
            return "cas_paybill";
        }
        if (MatchBizTypeEnum.AGENTPAY == tMatchBizType) {
            return "cas_agentpaybill";
        }
        if (MatchBizTypeEnum.TRANSDOWN == tMatchBizType) {
            return "fca_transdownbill";
        }
        if (MatchBizTypeEnum.TRANSHANDLE == tMatchBizType) {
            return "ifm_transhandlebill";
        }
        if (MatchBizTypeEnum.REC == tMatchBizType) {
            return "cas_recbill";
        }
        if (MatchBizTypeEnum.TRANSUP == tMatchBizType) {
            return "fca_transupbill";
        }
        return null;
    }

    private void dealDetailDataByCasBills(DynamicObject[] payBillArr, DynamicObject[] agentBillArr, DynamicObject[] recBillArr, DynamicObject[] transDownBillArr, DynamicObject[] transHandleBillArr, DynamicObject[] transUpBillArr, DynamicObject info, String opNumber) {
        BigDecimal amount;
        String direction;
        String bankCheckFlagStr = info.getString("bankcheckflag");
        Object accountbank = info.get("accountbank");
        long aId = 0L;
        if (accountbank instanceof Long) {
            aId = (Long)accountbank;
        } else if (accountbank instanceof DynamicObject) {
            aId = ((DynamicObject)accountbank).getLong("id");
        }
        Long accountbankId = aId;
        accountbank = info.get("currency");
        aId = 0L;
        if (accountbank instanceof Long) {
            aId = (Long)accountbank;
        } else if (accountbank instanceof DynamicObject) {
            aId = ((DynamicObject)accountbank).getLong("id");
        }
        Long currencyId = aId;
        logger.info("bankcheckflag:" + bankCheckFlagStr + ",accountbankId:" + accountbankId + ",currencyId:" + currencyId);
        if (info.getBigDecimal("debitamount").compareTo(Constants.ZERO) > 0) {
            DynamicObject agentPayBillEntry;
            direction = "pay";
            amount = info.getBigDecimal("debitamount");
            DynamicObject transDownBill = this.getTransDownData(transDownBillArr, bankCheckFlagStr, amount, accountbankId, currencyId);
            if (transDownBill != null) {
                DynamicObject transDownEntryBill = this.getTransDownEntryData(transDownBill, bankCheckFlagStr, amount);
                if (transDownEntryBill != null) {
                    this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", info.getString("billno"), Long.valueOf(info.getLong("id")), "fca_transdownbill", transDownBill.getString("billno"), Long.valueOf(transDownBill.getLong("id")), Long.valueOf(transDownEntryBill.getLong("id")), Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                }
                return;
            }
            DynamicObject payBillDO = Arrays.stream(payBillArr).filter(o -> {
                DynamicObjectCollection bankCheckFlagEntity = o.getDynamicObjectCollection("bankcheckentity");
                boolean bankCheckFlagMatch = Boolean.FALSE;
                if (bankCheckFlagEntity != null && !bankCheckFlagEntity.isEmpty()) {
                    bankCheckFlagMatch = bankCheckFlagEntity.stream().anyMatch(r -> bankCheckFlagStr.equals(r.getString("ebankcheckflag")));
                }
                return bankCheckFlagMatch && amount.compareTo(o.getBigDecimal("actpayamt")) == 0 && currencyId.longValue() == o.getLong("dpcurrency.id") && accountbankId.longValue() == o.getLong("payeracctbank.id");
            }).findFirst().orElse(null);
            if (payBillDO != null) {
                this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", info.getString("billno"), Long.valueOf(info.getLong("id")), "cas_paybill", payBillDO.getString("billno"), Long.valueOf(payBillDO.getLong("id")), null, Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                return;
            }
            DynamicObject tTransHandleBill = this.getTransHandleData(transHandleBillArr, bankCheckFlagStr, amount, accountbankId, currencyId);
            if (tTransHandleBill != null) {
                this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", info.getString("billno"), Long.valueOf(info.getLong("id")), "ifm_transhandlebill", tTransHandleBill.getString("billno"), Long.valueOf(tTransHandleBill.getLong("id")), null, Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                return;
            }
            String encodeAmountStr = AmountHelper.encodeAmount((BigDecimal)amount);
            DynamicObject agentPayBill = this.getAgentData(agentBillArr, bankCheckFlagStr, encodeAmountStr, accountbankId, currencyId);
            if (agentPayBill != null && (agentPayBillEntry = this.getAgentEntryData(agentPayBill, bankCheckFlagStr, encodeAmountStr)) != null) {
                this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelpay", info.getString("billno"), Long.valueOf(info.getLong("id")), "cas_agentpaybill", agentPayBill.getString("billno"), Long.valueOf(agentPayBill.getLong("id")), Long.valueOf(agentPayBillEntry.getLong("id")), Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                return;
            }
        }
        if (info.getBigDecimal("creditamount").compareTo(BigDecimal.ZERO) > 0) {
            direction = "rec";
            amount = info.getBigDecimal("creditamount");
            DynamicObject transUpBill = this.getTransUpData(transUpBillArr, bankCheckFlagStr, amount, accountbankId, currencyId);
            if (transUpBill != null) {
                DynamicObject transUpBillEntry = this.getTransUpEntryData(transUpBill, bankCheckFlagStr, amount);
                if (transUpBillEntry != null) {
                    this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelrec", info.getString("billno"), Long.valueOf(info.getLong("id")), "fca_transupbill", transUpBill.getString("billno"), Long.valueOf(transUpBill.getLong("id")), Long.valueOf(transUpBillEntry.getLong("id")), Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction));
                }
                return;
            }
            Arrays.stream(recBillArr).filter(o -> {
                DynamicObjectCollection bankCheckFlagEntity = o.getDynamicObjectCollection("bankcheckentity");
                boolean bankCheckFlagMatch = Boolean.FALSE;
                if (bankCheckFlagEntity != null && !bankCheckFlagEntity.isEmpty()) {
                    bankCheckFlagMatch = bankCheckFlagEntity.stream().anyMatch(r -> bankCheckFlagStr.equals(r.getString("ebankcheckflag")));
                }
                return bankCheckFlagMatch && amount.compareTo(o.getBigDecimal("actrecamt")) == 0 && currencyId.longValue() == o.getLong("currency.id") && accountbankId.longValue() == o.getLong("accountbank.id");
            }).findFirst().ifPresent(recBillDo -> this.tAutoMatchInfoList.add(new AutoMatchInfoParam("bei_intelrec", info.getString("billno"), Long.valueOf(info.getLong("id")), "cas_recbill", recBillDo.getString("billno"), Long.valueOf(recBillDo.getLong("id")), null, Long.valueOf(info.getLong("currency.id")), null, amount, info.getString("bankcheckflag"), info.getDate("bizdate"), opNumber, direction)));
        }
    }

    private DynamicObject getAgentData(DynamicObject[] agentBillArr, String bankCheckFlagStr, String encodeAmountStr, Long accountbankId, Long currencyId) {
        return Arrays.stream(agentBillArr).filter(agentBill -> accountbankId.longValue() == agentBill.getLong("payeracctbank.id") && currencyId.longValue() == agentBill.getLong("dpcurrency.id") && agentBill.getDynamicObjectCollection("entry").stream().anyMatch(entry -> bankCheckFlagStr.equals(entry.getString("e_bankcheckflag")) && encodeAmountStr.equals(entry.getString("e_encryptamount")))).findFirst().orElse(null);
    }

    private DynamicObject getAgentEntryData(DynamicObject agentBill, String bankCheckFlagStr, String encodeAmountStr) {
        return agentBill.getDynamicObjectCollection("entry").stream().filter(entry -> bankCheckFlagStr.equals(entry.getString("e_bankcheckflag")) && encodeAmountStr.equals(entry.getString("e_encryptamount"))).findFirst().orElse(null);
    }

    private DynamicObject getTransUpData(DynamicObject[] tBillArr, String bankCheckFlagStr, BigDecimal amount, Long accountbankId, Long currencyId) {
        return Arrays.stream(tBillArr).filter(tBill -> accountbankId.longValue() == tBill.getLong("accountbank.id") && currencyId.longValue() == tBill.getLong("currency.id") && tBill.getDynamicObjectCollection("entrys").stream().anyMatch(entry -> bankCheckFlagStr.equals(entry.getString("bankcheckflag")) && amount.compareTo(entry.getBigDecimal("transamt")) == 0)).findFirst().orElse(null);
    }

    private DynamicObject getTransUpEntryData(DynamicObject transUpBill, String bankCheckFlagStr, BigDecimal amount) {
        return transUpBill.getDynamicObjectCollection("entrys").stream().filter(entry -> bankCheckFlagStr.equals(entry.getString("bankcheckflag")) && amount.compareTo(entry.getBigDecimal("transamt")) == 0).findFirst().orElse(null);
    }

    private DynamicObject getTransDownData(DynamicObject[] tBillArr, String bankCheckFlagStr, BigDecimal amount, Long accountbankId, Long currencyId) {
        return Arrays.stream(tBillArr).filter(tBill -> accountbankId.longValue() == tBill.getLong("accountbank.id") && currencyId.longValue() == tBill.getLong("currency.id") && tBill.getDynamicObjectCollection("entrys").stream().anyMatch(entry -> bankCheckFlagStr.equals(entry.getString("bankcheckflag")) && amount.compareTo(entry.getBigDecimal("transamt")) == 0)).findFirst().orElse(null);
    }

    private DynamicObject getTransDownEntryData(DynamicObject transDownBill, String bankCheckFlagStr, BigDecimal amount) {
        return transDownBill.getDynamicObjectCollection("entrys").stream().filter(entry -> bankCheckFlagStr.equals(entry.getString("bankcheckflag")) && amount.compareTo(entry.getBigDecimal("transamt")) == 0).findFirst().orElse(null);
    }

    private DynamicObject getTransHandleData(DynamicObject[] tBillArr, String bankCheckFlagStr, BigDecimal amount, Long accountbankId, Long currencyId) {
        return Arrays.stream(tBillArr).filter(tBill -> accountbankId.longValue() == tBill.getLong("agentpayeraccount.id") && currencyId.longValue() == tBill.getLong("currency.id") && bankCheckFlagStr.equals(tBill.getString("beibankcheckflag")) && amount.compareTo(tBill.getBigDecimal("actpayamt")) == 0).findFirst().orElse(null);
    }

    private void updateReceivedType(DynamicObject detail) {
        String bankCheckFlag = detail.getString("bankcheckflag");
        Long currencyId = null;
        Long bankAccountId = null;
        Long companyId = null;
        if (detail.get("company") != null) {
            if (detail.get("company") instanceof Long) {
                companyId = detail.getLong("company");
            } else if (detail.get("company") instanceof DynamicObject) {
                DynamicObject company = detail.getDynamicObject("company");
                companyId = company.getLong("id");
            }
        }
        if (companyId == null) {
            return;
        }
        if (detail.get("currency") != null) {
            if (detail.get("currency") instanceof Long) {
                currencyId = detail.getLong("currency");
            } else if (detail.get("currency") instanceof DynamicObject) {
                DynamicObject currency = detail.getDynamicObject("currency");
                currencyId = currency.getLong("id");
            }
        }
        if (detail.get("accountbank") != null) {
            if (detail.get("accountbank") instanceof Long) {
                bankAccountId = detail.getLong("accountbank");
            } else if (detail.get("accountbank") instanceof DynamicObject) {
                DynamicObject bankAccount = detail.getDynamicObject("accountbank");
                bankAccountId = bankAccount.getLong("id");
            }
        }
        String oppBankNumber = detail.getString("oppbanknumber");
        BigDecimal creditAmount = detail.getBigDecimal("creditamount");
        BigDecimal debitAmount = detail.getBigDecimal("debitamount");
        String oppUnit = detail.getString("oppunit");
        boolean isExists = false;
        if (debitAmount != null && debitAmount.compareTo(BigDecimal.ZERO) == 0) {
            boolean isIfm;
            boolean isBookifm = TransDetailMatchBillService.getParameterBoolean(companyId, "is_book_ifm");
            boolean cs1047 = TransDetailMatchBillService.getParameterBoolean(companyId, "cs1047");
            boolean bl = isIfm = !isBookifm || cs1047;
            if (isIfm) {
                QFilter qFilter = new QFilter("billstatus", "<>", (Object)"A");
                if (currencyId != null) {
                    qFilter.and(new QFilter("currency", "=", (Object)currencyId));
                }
                qFilter.and("paidstatus", "<>", (Object)"C");
                qFilter.and("transtype", "=", (Object)"14");
                qFilter.and(new QFilter("actpayamt", "=", (Object)creditAmount));
                qFilter.and(new QFilter("agentpayeraccount.bankaccountnumber", "=", (Object)oppBankNumber));
                if (bankAccountId != null) {
                    qFilter.and(new QFilter("payeracctbank.id", "=", (Object)bankAccountId));
                }
                isExists = QueryServiceHelper.exists((String)"ifm_transhandlebill", (QFilter[])new QFilter[]{qFilter});
            }
        } else {
            boolean isBookInner = TransDetailMatchBillService.getParameterBoolean(companyId, "is_book_inner");
            if (isBookInner) {
                QFilter qFilter = new QFilter("billstatus", "not in", Arrays.asList("A", "G"));
                qFilter.and("bankcheckflag", "=", (Object)bankCheckFlag);
                qFilter.and(new QFilter("actpayamt", "=", (Object)debitAmount));
                qFilter.and(new QFilter("org", "=", (Object)companyId));
                qFilter.and(new QFilter("payeename", "=", (Object)oppUnit));
                isExists = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{qFilter});
            }
        }
        if (isExists) {
            detail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
            detail.set("isdowntobankstate", (Object)Character.valueOf('1'));
        }
    }

    private static boolean getParameterBoolean(long orgId, String key) {
        AppParam appParam = new AppParam(TmcAppEnum.CAS.getId(), "08", Long.valueOf(orgId), Long.valueOf(0L));
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
        if (value == null) {
            return false;
        }
        return value instanceof Boolean ? ((Boolean)value).booleanValue() : "true".equals(value);
    }
}

