/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detail;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.common.enums.ReceredTypeEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class WriteBackFromClaimService {
    public Boolean writeBack(Object[] detailId, DynamicObject bill) {
        if (bill == null) {
            return Boolean.FALSE;
        }
        Object[] details = TmcDataServiceHelper.load((Object[])detailId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        if (!EmptyUtil.isEmpty((Object[])details)) {
            String thisOpnumber = DB.genGlobalLongId() + "";
            for (Object detail : details) {
                AutoMatchHelper.deleteRecedBillEntry((DynamicObject)detail);
                detail.set("recedbilltype", (Object)"recbill");
                detail.set("recedbillnumber", (Object)bill.getString("billno"));
                detail.set("receredtype", (Object)ReceredTypeEnum.RECERED.getValue());
                detail.set("receredway", (Object)ReceredWayEnum.CLAIM.getValue());
                detail.set("isreced", (Object)"1");
                BigDecimal amt = BigDecimal.ZERO;
                String direction = "";
                if ("cas_recbill".equals(bill.getDataEntityType().getName())) {
                    amt = detail.getBigDecimal("creditamount");
                    direction = "rec";
                } else {
                    amt = detail.getBigDecimal("debitamount");
                    direction = "pay";
                }
                AutoMatchHelper.setRecedBillEntry((DynamicObject)detail, bill.getDataEntityType().getName(), bill.getString("billno"), bill.getLong("id"), 0L, "", amt, thisOpnumber, direction);
            }
            try (TXHandle tx = TX.requiresNew();){
                TmcDataServiceHelper.save((DynamicObject[])details);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void writeBackBatch(Map<Long, Map<String, Object>> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        List ids = map.keySet().stream().collect(Collectors.toList());
        Object[] details = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        if (!EmptyUtil.isEmpty((Object[])details)) {
            String thisOpnumber = DB.genGlobalLongId() + "";
            for (Object detail : details) {
                AutoMatchHelper.deleteRecedBillEntry((DynamicObject)detail);
                detail.set("recedbilltype", map.get(detail.getLong("id")).get("recedbilltype"));
                detail.set("recedbillnumber", map.get(detail.getLong("id")).get("recedbillnumber"));
                detail.set("receredtype", (Object)ReceredTypeEnum.RECERED.getValue());
                detail.set("receredway", (Object)ReceredWayEnum.CLAIM.getValue());
                detail.set("isreced", (Object)"1");
                BigDecimal amt = BigDecimal.ZERO;
                String direction = "";
                if ("cas_recbill".equals(map.get(detail.getLong("id")).get("recedbilltype"))) {
                    amt = detail.getBigDecimal("creditamount");
                    direction = "rec";
                } else {
                    amt = detail.getBigDecimal("debitamount");
                    direction = "pay";
                }
                AutoMatchHelper.setRecedBillEntry((DynamicObject)detail, (String)map.get(detail.getLong("id")).get("recedbilltype"), (String)map.get(detail.getLong("id")).get("recedbillnumber"), (Long)map.get(detail.getLong("id")).get("billId"), 0L, "", amt, thisOpnumber, direction);
            }
            TmcDataServiceHelper.save((DynamicObject[])details);
        }
    }

    public void cancelWriteBackBatch(Object[] detailIds) {
        DynamicObject[] details = TmcDataServiceHelper.load((Object[])detailIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        if (details == null || details.length == 0) {
            return;
        }
        for (DynamicObject detail : details) {
            AutoMatchHelper.deleteRecedBillEntry(detail);
            detail.set("recedbilltype", (Object)"");
            detail.set("recedbillnumber", (Object)"");
            detail.set("receredtype", (Object)ReceredTypeEnum.UNRECERED.getValue());
            detail.set("receredway", null);
            detail.set("isreced", (Object)"0");
        }
        TmcDataServiceHelper.save((DynamicObject[])details);
    }

    public Boolean cancelWriteBack(Object[] detailId, DynamicObject bill) {
        if (bill == null) {
            return Boolean.FALSE;
        }
        Object[] details = TmcDataServiceHelper.load((Object[])detailId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        if (!EmptyUtil.isEmpty((Object[])details)) {
            for (Object detail : details) {
                AutoMatchHelper.deleteRecedBillEntry((DynamicObject)detail);
                detail.set("recedbilltype", (Object)"");
                detail.set("recedbillnumber", (Object)"");
                detail.set("receredtype", (Object)ReceredTypeEnum.UNRECERED.getValue());
                detail.set("receredway", null);
                detail.set("isreced", (Object)"0");
            }
            try (TXHandle tx = TX.requiresNew();){
                TmcDataServiceHelper.save((DynamicObject[])details);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean cancelWriteBackBillno(Map<Object, String> detailIdRuleName) {
        if (detailIdRuleName == null || detailIdRuleName.size() == 0) {
            return Boolean.FALSE;
        }
        Object[] details = TmcDataServiceHelper.load((Object[])detailIdRuleName.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        if (!EmptyUtil.isEmpty((Object[])details)) {
            for (Object detail : details) {
                detail.set("rulename", (Object)detailIdRuleName.get(detail.getLong("id")));
            }
            try (TXHandle tx = TX.requiresNew();){
                TmcDataServiceHelper.save((DynamicObject[])details);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

