/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.detailschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.AutoMatchScheDuleHelper;
import kd.tmc.bei.business.task.recpayintel.IntelRecPayAutoMatchTaskHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.MatchBizTypeEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayAutoMatchScheduleService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(PayAutoMatchScheduleService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws TmcBizException {
        ArrayList<Object> succIdList = new ArrayList<Object>();
        HashSet failIdSet = new HashSet();
        ArrayList<OperateErrorInfo> errors = new ArrayList<OperateErrorInfo>();
        List allDetailIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        logger.info("allDetailIds is:" + allDetailIds.size());
        try {
            List<DynamicObject> firstFailList;
            String direction = "pay";
            String opNumber = DB.genGlobalLongId() + "";
            HashSet<Object> transDownSuccessIds = AutoMatchScheDuleHelper.autoMatch(Arrays.asList(dataEntities), MatchBizTypeEnum.TRANSDOWN, true, direction);
            logger.info("transDownSuccessIds is:" + transDownSuccessIds.size());
            for (Object id : allDetailIds) {
                if (transDownSuccessIds.contains(id)) continue;
                failIdSet.add(id);
            }
            logger.info("failIdSet is:" + failIdSet.size());
            if (!EmptyUtil.isEmpty(transDownSuccessIds)) {
                List<DynamicObject> downSuccList = Arrays.stream(dataEntities).filter(e -> transDownSuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("transDownSuccList size is:" + downSuccList.size());
                IntelRecPayAutoMatchTaskHelper.autoMatch(downSuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.TRANSDOWN.getValue(), direction, opNumber);
                succIdList.addAll(transDownSuccessIds);
                this.getOperationResult().setSuccessPkIds(succIdList);
                this.getOperationResult().setSuccess(true);
            }
            if (!EmptyUtil.isEmpty(failIdSet)) {
                firstFailList = Arrays.stream(dataEntities).filter(e -> failIdSet.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("firstFailList size is:" + firstFailList.size());
                HashSet<Object> paySuccessIds = AutoMatchScheDuleHelper.autoMatch(firstFailList, MatchBizTypeEnum.PAY, true, direction);
                if (!EmptyUtil.isEmpty(paySuccessIds)) {
                    List<DynamicObject> paySuccList = Arrays.stream(dataEntities).filter(e -> paySuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                    logger.info("paySuccList size is:" + paySuccList.size());
                    IntelRecPayAutoMatchTaskHelper.autoMatch(paySuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.PAY.getValue(), direction, opNumber);
                    succIdList.addAll(paySuccessIds);
                    this.getOperationResult().setSuccessPkIds(succIdList);
                    this.getOperationResult().setSuccess(true);
                    failIdSet.removeAll(paySuccessIds);
                }
            }
            if (!EmptyUtil.isEmpty(failIdSet)) {
                firstFailList = Arrays.stream(dataEntities).filter(e -> failIdSet.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("firstFailList size is:" + firstFailList.size());
                HashSet<Object> transHandleSuccessIds = AutoMatchScheDuleHelper.autoMatch(firstFailList, MatchBizTypeEnum.TRANSHANDLE, true, direction);
                if (!EmptyUtil.isEmpty(transHandleSuccessIds)) {
                    List<DynamicObject> transHandleSuccList = Arrays.stream(dataEntities).filter(e -> transHandleSuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                    logger.info("transHandleSuccList size is:" + transHandleSuccList.size());
                    IntelRecPayAutoMatchTaskHelper.autoMatch(transHandleSuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.TRANSHANDLE.getValue(), direction, opNumber);
                    succIdList.addAll(transHandleSuccessIds);
                    this.getOperationResult().setSuccessPkIds(succIdList);
                    this.getOperationResult().setSuccess(true);
                    failIdSet.removeAll(transHandleSuccessIds);
                }
            }
            if (!EmptyUtil.isEmpty(failIdSet)) {
                firstFailList = Arrays.stream(dataEntities).filter(e -> failIdSet.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("firstFailList size is:" + firstFailList.size());
                HashSet<Object> agentSuccessIds = AutoMatchScheDuleHelper.autoMatch(firstFailList, MatchBizTypeEnum.AGENTPAY, true, direction);
                if (!EmptyUtil.isEmpty(agentSuccessIds)) {
                    List<DynamicObject> agentSuccList = Arrays.stream(dataEntities).filter(e -> agentSuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                    logger.info("agentSuccList size is:" + agentSuccList.size());
                    IntelRecPayAutoMatchTaskHelper.autoMatch(agentSuccList.toArray(new DynamicObject[0]), "agentpay", direction, opNumber);
                    succIdList.addAll(agentSuccessIds);
                    this.getOperationResult().setSuccessPkIds(succIdList);
                    this.getOperationResult().setSuccess(true);
                    failIdSet.removeAll(agentSuccessIds);
                }
            }
            if (!EmptyUtil.isEmpty(failIdSet)) {
                firstFailList = Arrays.stream(dataEntities).filter(e -> failIdSet.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("firstFailList size is:" + firstFailList.size());
                HashSet<Object> exchangeSuccessIds = AutoMatchScheDuleHelper.autoMatch(firstFailList, MatchBizTypeEnum.EXCHANGE, true, direction);
                if (!EmptyUtil.isEmpty(exchangeSuccessIds)) {
                    List<DynamicObject> exchangeSuccList = Arrays.stream(dataEntities).filter(e -> exchangeSuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                    logger.info("exchangeSuccList size is:" + exchangeSuccList.size());
                    IntelRecPayAutoMatchTaskHelper.autoMatch(exchangeSuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.EXCHANGE.getValue(), direction, opNumber);
                    succIdList.addAll(exchangeSuccessIds);
                    this.getOperationResult().setSuccessPkIds(succIdList);
                    this.getOperationResult().setSuccess(true);
                    failIdSet.removeAll(exchangeSuccessIds);
                }
            }
            if (!EmptyUtil.isEmpty(failIdSet)) {
                firstFailList = Arrays.stream(dataEntities).filter(e -> failIdSet.contains(e.getPkValue())).collect(Collectors.toList());
                logger.info("firstFailList size is:" + firstFailList.size());
                HashSet<Object> recSuccessIds = AutoMatchScheDuleHelper.autoMatch(firstFailList, MatchBizTypeEnum.REC, true, direction);
                if (!EmptyUtil.isEmpty(recSuccessIds)) {
                    List<DynamicObject> recSuccList = Arrays.stream(dataEntities).filter(e -> recSuccessIds.contains(e.getPkValue())).collect(Collectors.toList());
                    logger.info("recSuccList size is:" + recSuccList.size());
                    IntelRecPayAutoMatchTaskHelper.autoMatch(recSuccList.toArray(new DynamicObject[0]), MatchBizTypeEnum.REC.getValue(), direction, opNumber);
                    succIdList.addAll(recSuccessIds);
                    this.getOperationResult().setSuccessPkIds(succIdList);
                    this.getOperationResult().setSuccess(true);
                    failIdSet.removeAll(recSuccessIds);
                }
            }
        }
        catch (Exception e2) {
            for (Object failId : failIdSet) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(e2.getMessage());
                operateErrorInfo.setPkValue(failId);
                errors.add(operateErrorInfo);
            }
            this.getOperationResult().getSuccessPkIds().removeAll(failIdSet);
            this.getOperationResult().setAllErrorInfo(errors);
            this.getOperationResult().setSuccess(false);
            logger.info("PayAutoMatchScheduleService.process error:", (Object)e2);
            return;
        }
        if (EmptyUtil.isNoEmpty(failIdSet)) {
            for (Object failId : failIdSet) {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d\u7ed3\u679c\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u672a\u914d\u7f6e\u81ea\u52a8\u5339\u914d\u89c4\u5219\uff0c\u6216\u6839\u636e\u89c4\u5219\u672a\u5339\u914d\u5230\u4e1a\u52a1\u5355\u636e\u3002", (String)"PayAutoMatchScheduleService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                operateErrorInfo.setPkValue(failId);
                errors.add(operateErrorInfo);
            }
            this.getOperationResult().getSuccessPkIds().removeAll(failIdSet);
            this.getOperationResult().setAllErrorInfo(errors);
            this.getOperationResult().setSuccess(false);
        }
    }
}

