/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.opservice.param.ElecBalanceAccQueryParam;
import kd.tmc.bei.business.opservice.result.ElecBalanceResult;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.service.ebservice.errorcode.BeErrorCode;

public class ElecBalanceStateAccUpdateService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElecBalanceStateAccUpdateService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("currency");
        selector.add("period");
        selector.add("accountbank");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject currency = dataEntities[0].getDynamicObject("currency");
        DynamicObject accountBank = dataEntities[0].getDynamicObject("accountbank");
        String bankAccountNumber = accountBank.getString("bankaccountnumber");
        Date date = dataEntities[0].getDate("period");
        String currNumber = currency.getString("number");
        boolean isSuccess = MutexServiceHelper.request((String)bankAccountNumber, (String)"bd_accountbanks", (String)("op_balancestate_acc_" + currNumber));
        try {
            if (isSuccess) {
                ElecBalanceAccQueryParam queryParam = new ElecBalanceAccQueryParam(Collections.singletonList(bankAccountNumber), currency, date, date, true);
                ElecBalanceResult result = EBServiceFacadeFactory.getBankService().queryElecBalanceAcc(queryParam);
                if (result != null && result.getErrMsg() != null) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(result.getErrMsg());
                } else {
                    this.operationResult.setSuccess(true);
                }
            }
        }
        catch (Exception e) {
            logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            this.operationResult.setMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            this.operationResult.setSuccess(false);
            throw new KDException(new BeErrorCode().COMMON(), new Object[]{e.getMessage()});
        }
        finally {
            MutexServiceHelper.release((String)bankAccountNumber, (String)"bd_accountbanks", (String)("op_balancestate_acc_" + currNumber));
        }
    }
}

