/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.aef.GetBizBillInfoImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.matchtpl.MatcherTpl;
import kd.bos.print.matchtpl.ViewType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.CasBotpHelper;
import kd.tmc.bei.business.ocr.invoke.ScanSystemFactory;
import kd.tmc.bei.common.enums.SourceBillTypeEnum;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecBillArchiveService
extends GetBizBillInfoImpl {
    private static final Log logger = LogFactory.getLog(ElecBillArchiveService.class);
    private static final String[] elcReceipts = new String[]{"cas_paybill", "cas_recbill", "cas_agentpaybill", "fca_transupbill", "fca_transdownbill", "cas_transferapply", "cas_bankjournal"};

    public Map<Long, List<JSONObject>> getBizBillTicketList(String billType, Set<Long> billIds) {
        if (StringUtils.isEmpty((CharSequence)billType) || billIds == null || billIds.isEmpty()) {
            return null;
        }
        List<String> elcReceiptsList = Arrays.asList(elcReceipts);
        Map<Long, List<JSONObject>> result = null;
        String[] split = billType.split("_pageId=");
        if (split.length > 1 && elcReceiptsList.contains(split[0])) {
            if ("cas_transferapply".equals(split[0])) {
                return result;
            }
            result = this.findArchiveByReceipt(split[0], split[1], billIds);
        } else if (StringUtils.equals((CharSequence)billType, (CharSequence)"bei_elecstatement")) {
            result = this.findArchiveByStatement(billType, billIds);
        }
        return result;
    }

    public Map<Long, List<JSONObject>> findArchiveByStatement(String billType, Set<Long> ids) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType);
        HashMap<Long, List<JSONObject>> returnData = new HashMap<Long, List<JSONObject>>(bills.length);
        for (DynamicObject bill : bills) {
            ArrayList<JSONObject> ticekBills = new ArrayList<JSONObject>(10);
            JSONObject ticketBill = new JSONObject();
            ticketBill.put("seqNo", (Object)("" + bill.getLong("id")));
            ticketBill.put("IdentificationCodeOfIssuer", (Object)bill.getString("identificationissuer"));
            ticketBill.put("NumberOfBankBranch", (Object)bill.getString("bankbranchnumber"));
            ticketBill.put("Currency", (Object)(EmptyUtil.isEmpty((DynamicObject)bill.getDynamicObject("currency")) ? "" : bill.getDynamicObject("currency").getString("number")));
            ticketBill.put("CustomerSettlementBankAccount", (Object)(EmptyUtil.isEmpty((DynamicObject)bill.getDynamicObject("accountbank")) ? "" : bill.getDynamicObject("accountbank").getString("bankaccountnumber")));
            ticketBill.put("NameOfCustomerAccount", (Object)bill.getString("accountbankname"));
            ticketBill.put("CodeOfBankCustomer", (Object)bill.getString("bankcustomercode"));
            Date date = bill.getDate("period");
            int year = DateUtils.getYear((Date)date);
            int month = DateUtils.getMonth((Date)date);
            ticketBill.put("YearOfBankReconciliationStatement", (Object)(year + ""));
            ticketBill.put("MonthOfBankReconciliationStatement", (Object)(month + ""));
            ticketBill.put("PrintTimes", (Object)bill.getLong("printcount"));
            ticketBill.put("PrintDate", (Object)(EmptyUtil.isEmpty((Object)bill.getDate("printdate")) ? "" : DateUtils.formatString((Date)bill.getDate("printdate"), (String)"yyyy-MM-dd")));
            ticketBill.put("AccountBalanceAtTheEndOfReconciliationCycleAmount", (Object)(EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("endacctamount")) ? "" : bill.getBigDecimal("endacctamount").toPlainString()));
            ticketBill.put("ReserveBalanceAtTheEndOfReconciliationCycle", (Object)(EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("endretainamount")) ? "" : bill.getBigDecimal("endretainamount").toPlainString()));
            ticketBill.put("FrozenBalanceAtTheEndOfReconciliationCycle", (Object)(EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("endfreezeamount")) ? "" : bill.getBigDecimal("endfreezeamount").toPlainString()));
            ticketBill.put("OverdraftBalanceAtEndOfReconciliationCycle", (Object)(EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("endoverdraftamount")) ? "" : bill.getBigDecimal("endoverdraftamount").toPlainString()));
            ticketBill.put("AvailableBalanceAtTheEndOfReconciliationCycleAmount", (Object)(EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("endavailableamount")) ? "" : bill.getBigDecimal("endavailableamount").toPlainString()));
            DynamicObjectCollection checkDetails = bill.getDynamicObjectCollection("entryentity");
            JSONArray entryEntityJson = new JSONArray();
            for (DynamicObject checkDetail : checkDetails) {
                JSONObject checkDetail1 = new JSONObject();
                checkDetail1.put("DateOfBookkeeping", (Object)(EmptyUtil.isEmpty((Object)checkDetail.getDate("e_bookdate")) ? "" : DateUtils.formatString((Date)checkDetail.getDate("e_bookdate"), (String)"yyyy-MM-dd")));
                checkDetail1.put("TypesOfBusinessProducts", (Object)checkDetail.getString("e_bizproduct"));
                checkDetail1.put("TypeOfSourceDocument", (Object)checkDetail.getString("e_sourcedocument"));
                checkDetail1.put("NumberOfSourceDocument", (Object)checkDetail.getString("e_sourcedocumentno"));
                checkDetail1.put("NotesOfBankElectronicReceipt", (Object)checkDetail.getString("e_remark"));
                BigDecimal debitAmount = checkDetail.getBigDecimal("e_debitamount");
                BigDecimal creditAmount = checkDetail.getBigDecimal("e_creditamount");
                if (debitAmount != null && creditAmount != null) {
                    checkDetail1.put("TransactionAmount", (Object)(debitAmount.compareTo(BigDecimal.ZERO) == 0 ? creditAmount.toPlainString() : debitAmount.toPlainString()));
                } else {
                    checkDetail1.put("TransactionAmount", (Object)(debitAmount == null ? creditAmount.toPlainString() : debitAmount.toPlainString()));
                }
                checkDetail1.put("IdentificationOfCreditOrDebit", checkDetail.get("e_creditmark"));
                checkDetail1.put("DebitOrCreditOfBalance", (Object)checkDetail.getString("e_balancedirection"));
                checkDetail1.put("AccountBalance", (Object)(EmptyUtil.isEmpty((BigDecimal)checkDetail.getBigDecimal("e_acctamount")) ? "" : checkDetail.getBigDecimal("e_acctamount").toPlainString()));
                checkDetail1.put("TransactionCode", (Object)checkDetail.getString("e_transactioncode"));
                checkDetail1.put("AccountOfCounterparty", (Object)checkDetail.getString("e_oppositeacct"));
                checkDetail1.put("NameOfCounterparty", (Object)checkDetail.getString("e_oppositeacctname"));
                checkDetail1.put("DepositoryBankOfCounterparty", (Object)checkDetail.getString("e_oppositebank"));
                checkDetail1.put("Bookkeeper", (Object)checkDetail.getString("e_bookkeeper"));
                Date bookTime = checkDetail.getDate("e_booktime");
                checkDetail1.put("TimeOfBookkeeping", (Object)(EmptyUtil.isEmpty((Object)bookTime) ? "" : DateUtils.formatString((Date)bookTime, (String)"HH-mm-ss")));
                checkDetail1.put("JournalAccountOfBookkeeping", (Object)checkDetail.getString("e_bookjournal"));
                checkDetail1.put("OtherAccountingInformation", (Object)checkDetail.getString("e_otherbookinfo"));
                checkDetail1.put("NumberOfBankElectronicReceipt", (Object)checkDetail.getString("e_elecreceiptno"));
                checkDetail1.put("BusinessSerialNumber", (Object)checkDetail.getString("e_businessserialnumber"));
                entryEntityJson.add((Object)checkDetail1);
            }
            ticketBill.put("InformationOfReconcileDetailsTuple", (Object)entryEntityJson);
            String collect = bill.getDynamicObjectCollection("urlentry").stream().map(s -> s.getString("e_fileservicepath")).collect(Collectors.joining(";"));
            ticketBill.put("url", (Object)collect);
            ticekBills.add(ticketBill);
            returnData.put(bill.getLong("id"), ticekBills);
        }
        return returnData;
    }

    public Map<Long, List<JSONObject>> findArchiveByReceipt(String billType, String pageId, Set<Long> ids) {
        logger.info("findArchiveByReceipt \u5f00\u59cb\u8054\u67e5\u7535\u5b50\u56de\u5355 " + billType + ids);
        DynamicObjectCollection bills = this.getFundBills(billType, ids);
        HashMap<Long, List<JSONObject>> returnData = new HashMap<Long, List<JSONObject>>(bills.size());
        ArrayList<DynamicObject> billsListBankCheck = new ArrayList<DynamicObject>(10);
        HashSet<Long> detailIds = new HashSet<Long>(10);
        HashMap<Long, Set<Long>> detailMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject bill2 : bills) {
            Set<Long> idsSet = CasBotpHelper.getBotpRtansDetails(bill2.getLong("id"), billType);
            detailMap.put(bill2.getLong("id"), idsSet);
            if (!idsSet.isEmpty()) {
                detailIds.addAll(idsSet);
                continue;
            }
            billsListBankCheck.add(bill2);
        }
        logger.info("findArchiveByReceipt detailIds: " + detailIds + " billId: " + bills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList()));
        DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,accountbank,currency,receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
        List receiptNos = details.stream().map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
        receiptNos = receiptNos.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List bankCheckFlags0 = billsListBankCheck.stream().filter(bill -> EmptyUtil.isNoEmpty((String)bill.getString("bankcheckflag"))).map(bill -> bill.getString("bankcheckflag")).collect(Collectors.toList());
        List<Object> bankCheckFlags = new ArrayList(bankCheckFlags0.size());
        for (String str1 : bankCheckFlags0) {
            if (str1.contains(",")) {
                String[] split = str1.split(",");
                Collections.addAll(bankCheckFlags, split);
                continue;
            }
            bankCheckFlags.add(str1);
        }
        bankCheckFlags = bankCheckFlags.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        DynamicObject[] receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,receiptno,fileserverurl,tcpurl,uploadfilename,username,password,validcode,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag,amount,currency", (QFilter[])new QFilter[]{new QFilter("matchdetailentry.e_bankcheckflag", "in", bankCheckFlags).or(new QFilter("receiptno", "in", receiptNos))});
        for (DynamicObject bill3 : bills) {
            DynamicObject billObj;
            String bankCheckFlag = bill3.getString("bankcheckflag");
            if (bankCheckFlag == null) {
                bankCheckFlag = "";
            }
            ArrayList<String> splitBankCheckFlag = new ArrayList<String>(5);
            String[] split = bankCheckFlag.split(",");
            if (StringUtils.isNotBlank((CharSequence)split[0])) {
                splitBankCheckFlag.addAll(Arrays.asList(split));
            }
            Set idsSet = (Set)detailMap.get(bill3.getLong("id"));
            List<Object> tickBills = new ArrayList(8);
            if ("cas_paybill".equals(billType) || "cas_recbill".equals(billType) || "cas_transferapply".equals(billType)) {
                String loadBillType = "cas_transferapply".equals(billType) || "cas_paybill".equals(billType) ? "cas_paybill" : "cas_recbill";
                billObj = BusinessDataServiceHelper.loadSingle((String)loadBillType, (String)("id, payeracctbank accountbank, entry.contractnumber, " + ("cas_paybill".equals(loadBillType) ? "entry.e_payableamt" : "entry.e_receivableamt")), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bill3.getLong("id"))});
            } else {
                billObj = bill3;
            }
            if (!idsSet.isEmpty()) {
                DynamicObjectCollection detailsTemp = this.getDetails(idsSet);
                List receiptno = detailsTemp.stream().map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
                List<DynamicObject> receiptList = Stream.of(receipts).filter(receipt -> receiptno.contains(receipt.getString("receiptno"))).collect(Collectors.toList());
                tickBills = this.getJsonReturnData(receiptList, billObj, billType, pageId);
            }
            if (idsSet.isEmpty() || tickBills.isEmpty()) {
                ArrayList<DynamicObject> receiptList = new ArrayList<DynamicObject>(receipts.length);
                for (DynamicObject receipt2 : receipts) {
                    DynamicObjectCollection matchdetailentry = receipt2.getDynamicObjectCollection("matchdetailentry");
                    List existsFlag = matchdetailentry.stream().filter(entry -> splitBankCheckFlag.contains(String.valueOf(entry.get("e_bankcheckflag")))).collect(Collectors.toList());
                    if (existsFlag.size() <= 0) continue;
                    receiptList.add(receipt2);
                }
                logger.info(billType + bill3.getLong("id") + " BankCheckFlag:" + bankCheckFlag);
                if (EmptyUtil.isEmpty((DynamicObject)billObj) || EmptyUtil.isEmpty(receiptList)) continue;
                tickBills = this.getJsonReturnData(receiptList, billObj, billType, pageId);
            }
            if (tickBills.isEmpty()) continue;
            returnData.put(bill3.getLong("id"), tickBills);
        }
        return returnData;
    }

    private List<JSONObject> getJsonReturnData(List<DynamicObject> receiptList, DynamicObject bill, String billType, String pageId) {
        ArrayList<JSONObject> tickBills = new ArrayList<JSONObject>(8);
        for (DynamicObject receipt : receiptList) {
            DynamicObject[] bankJournals;
            DynamicObjectCollection col;
            DynamicObjectCollection col2;
            JSONObject ticketBill = new JSONObject();
            ticketBill.put("IdentifyingCode", (Object)receipt.getString("validcode"));
            ticketBill.put("seqNo", (Object)receipt.getString("validcode"));
            String contractNumberStr = "";
            if (("cas_paybill".equals(billType) || "cas_recbill".equals(billType)) && (col2 = bill.getDynamicObjectCollection("entry")) != null) {
                contractNumberStr = StringUtils.join((Object[])col2.stream().map(dyObj -> dyObj.getString("contractnumber")).toArray(), (String)",");
            }
            ticketBill.put("ContractNumber", (Object)contractNumberStr);
            BigDecimal amountPayAndRec = BigDecimal.ZERO;
            if ("cas_paybill".equals(billType)) {
                col = bill.getDynamicObjectCollection("entry");
                if (col != null) {
                    for (DynamicObject dyObj2 : col) {
                        amountPayAndRec = amountPayAndRec.add(dyObj2.getBigDecimal("e_payableamt"));
                    }
                }
            } else if ("cas_recbill".equals(billType) && (col = bill.getDynamicObjectCollection("entry")) != null) {
                for (DynamicObject dyObj2 : col) {
                    amountPayAndRec = amountPayAndRec.add(dyObj2.getBigDecimal("e_receivableamt"));
                }
            }
            ticketBill.put("AmountPayableAndReceivable", (Object)amountPayAndRec.toPlainString());
            ticketBill.put("WhetherInvoiceHasBeenClaimed", (Object)"");
            Boolean ischeck = true;
            QFilter filter1 = new QFilter("sourcebilltype", "=", (Object)billType);
            QFilter filter2 = new QFilter("sourcebillid", "=", (Object)bill.getLong("id"));
            for (DynamicObject bankJournal : bankJournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,ischeck", (QFilter[])new QFilter[]{filter1, filter2})) {
                if (!bankJournal.getBoolean("ischeck")) continue;
                ischeck = false;
                break;
            }
            ticketBill.put("WhetherReceiptHasBeenReconciled", (Object)ischeck);
            ticketBill.put("WhetherReceiptHasBeenTransferredToBank", (Object)"");
            List<String> pdfUrls = this.getPdfUrl(pageId, receipt);
            if (!pdfUrls.isEmpty()) {
                ticketBill.put("url", (Object)pdfUrls.get(0));
            } else {
                ticketBill.put("url", (Object)"");
            }
            ticketBill.put("receiptId", (Object)(receipt.getLong("id") + ""));
            ticketBill.put("Currency", (Object)(receipt.getDynamicObject("currency") == null ? "" : receipt.getDynamicObject("currency").getString("number")));
            ticketBill.put("TransactionAmountInFigures", (Object)(receipt.getBigDecimal("amount") == null ? BigDecimal.ZERO.toPlainString() : receipt.getBigDecimal("amount").toPlainString()));
            tickBills.add(ticketBill);
        }
        return tickBills;
    }

    private List<String> getPdfUrl(String pageId, DynamicObject receipt) {
        ArrayList<String> returnUrls = new ArrayList<String>(10);
        if (receipt.getBoolean("fileflag")) {
            logger.info("\u8bbe\u7f6eusername-------" + receipt.getString("username"));
            String uploadfilename = ReceiptPrintHelper.getRealUploadUrl((DynamicObject)receipt);
            logger.info("uploadfilename = " + uploadfilename);
            if (StringUtils.isBlank((CharSequence)uploadfilename)) {
                logger.error(receipt.getPkValue() + new BeiBizResource().getNoReceiptnoError());
                return returnUrls;
            }
            String fileserverurl = receipt.getString("fileserverurl");
            if (!EmptyUtil.isEmpty((String)fileserverurl)) {
                Long userId = RequestContext.get().getCurrUserId();
                DynamicObjectCollection userObj = QueryServiceHelper.query((String)"bos_user", (String)"id,phone", (QFilter[])new QFilter("id", "=", (Object)userId).toArray());
                DynamicObjectCollection configObj = QueryServiceHelper.query((String)"bas_imageconfig", (String)"imageurl,clientid,clientsecret", (QFilter[])new QFilter("enable", "=", (Object)"A").toArray());
                String imgsysUrl = "";
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)configObj)) {
                    imgsysUrl = ScanSystemFactory.getScanService().getImgsysUrl(((DynamicObject)configObj.get(0)).getString("clientid"), ((DynamicObject)configObj.get(0)).getString("clientsecret"), ((DynamicObject)configObj.get(0)).getString("imageurl"), ((DynamicObject)userObj.get(0)).getString("phone"), fileserverurl);
                }
                logger.info("imgsysUrl==========================" + imgsysUrl);
                returnUrls.add(imgsysUrl);
            } else {
                returnUrls.add(uploadfilename);
            }
        } else {
            String strReceiptID = receipt.getString("id");
            Long receiptID = Long.valueOf(strReceiptID);
            try {
                Map receiptTemplate = ReceiptPrintHelper.getMatchReceiptTemplate((String)"bei", (String)"bei_elecreceipt", Collections.singleton(receiptID), (ViewType)ViewType.LIST, (String)pageId);
                receiptTemplate.remove("");
                if (!receiptTemplate.isEmpty()) {
                    for (MatcherTpl template : (Set)receiptTemplate.get(receiptID)) {
                        String templateId = template.getTplId();
                        logger.info("templateForm.keySet=" + templateId);
                        String templateFormId = MetadataDao.getNumberById((String)templateId);
                        String url = PrintServiceHelper.createPdfUrl((String)pageId, (String)"bei_elecreceipt", (String)templateFormId, (Object[])new Long[]{receiptID});
                        if (StringUtils.isNotEmpty((CharSequence)url)) {
                            logger.info("url = " + url);
                            url = url.replaceFirst("print\\.do", "download.do");
                            returnUrls.add(url);
                            continue;
                        }
                        PrtAttach attach = ReceiptPrintHelper.doNewPrint((String)pageId, (String)"bei_elecreceipt", (String)templateId, (Object)receipt.get("id"));
                        if (!Objects.nonNull(attach)) continue;
                        List attachDetail = attach.getAttachDetail();
                        for (PrtAttach.AttachDetail detail : attachDetail) {
                            String filePath = detail.getFilePath();
                            filePath = filePath.replaceFirst("print\\.do", "download.do");
                            returnUrls.add(filePath);
                        }
                    }
                } else {
                    logger.info("none printTemplete");
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return returnUrls;
    }

    private DynamicObjectCollection getDetails(Set<Long> idsSet) {
        return QueryServiceHelper.query((String)"bei_transdetail", (String)"id, company, accountbank, currency, matchreceiptentry.e_receiptno receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", idsSet)});
    }

    private DynamicObjectCollection getFundBills(String billType, Set<Long> ids) {
        DynamicObjectCollection bills;
        if (SourceBillTypeEnum.PAYBILL.getValue().equals(billType) || SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billType)) {
            bills = QueryServiceHelper.query((String)billType, (String)"id, bankcheckentity.ebankcheckflag bankcheckflag, payeracctbank accountbank", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        } else if (SourceBillTypeEnum.RECBILL.getValue().equals(billType)) {
            bills = QueryServiceHelper.query((String)billType, (String)"id, bankcheckentity.ebankcheckflag bankcheckflag, accountbank", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        } else if (SourceBillTypeEnum.TRANSFERBILL.getValue().equals(billType)) {
            List payBillNos = QueryServiceHelper.query((String)billType, (String)"id, cas_transferapply_entry.e_paybillno paybillno", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}).stream().map(p -> p.getString("paybillno")).collect(Collectors.toList());
            logger.info(billType + ids + " query cas_paybill paybillNos: " + payBillNos);
            bills = QueryServiceHelper.query((String)SourceBillTypeEnum.PAYBILL.getValue(), (String)"id, bankcheckentity.ebankcheckflag bankcheckflag", (QFilter[])new QFilter[]{new QFilter("billno", "in", payBillNos)});
        } else {
            bills = SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billType) || SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billType) ? QueryServiceHelper.query((String)billType, (String)"id, entrys.bankcheckflag bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}) : QueryServiceHelper.query((String)billType, (String)"id, bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        }
        return bills;
    }
}

