/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.helper.ElecMatchCheckHelper;
import kd.tmc.bei.business.opservice.elec.ElecMatchDetailService;
import kd.tmc.bei.common.enums.DataSourceEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.math.NumberUtils;

public class ElectReceiptCancelMatchService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ElectReceiptCancelMatchService.class);

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(20);
        lst.add("billno");
        lst.add("datasource");
        lst.add("ismatch");
        lst.add("bankcheckflag");
        lst.add("transdetailid");
        lst.add("matchtype");
        lst.add("matcher");
        lst.add("matchtime");
        lst.add("receiptno");
        lst.add("fileflag");
        lst.add("uploadfilename");
        lst.add("creditdebitflag");
        lst.add("creditamount");
        lst.add("debitamount");
        lst.add("amount");
        lst.add("oppunit");
        lst.add("oppbanknumber");
        lst.add("oppbankname");
        lst.add("oppbank");
        lst.add("description");
        lst.add("extdata");
        return lst;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Object> transDetailList = new ArrayList<Object>(10);
        ArrayList<Object[]> deleteElecIds = new ArrayList<Object[]>(dataEntities.length);
        HashSet<Long> matchRelatedBizBillSet = new HashSet<Long>(2);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection matchdetailentry = dataEntity.getDynamicObjectCollection("matchdetailentry");
            List e_transdetailid = matchdetailentry.stream().map(e -> e.getLong("e_transdetailid")).collect(Collectors.toList());
            QFilter tFilter = new QFilter("id", "in", (Object)e_transdetailid.toArray());
            Object[] transDetailDOs = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,ismatchereceipt,receiptno,datasource,bankcheckflag,matchreceiptentry.e_receiptno", (QFilter[])new QFilter[]{tFilter});
            if (ObjectUtils.isEmpty((Object[])transDetailDOs)) continue;
            dataEntity.set("ismatch", (Object)"0");
            dataEntity.set("matchtype", (Object)"");
            dataEntity.set("matcher", (Object)NumberUtils.LONG_ZERO);
            dataEntity.set("matchtime", null);
            dataEntity.set("bankcheckflag", null);
            dataEntity.set("extdata", null);
            deleteElecIds.add(new Object[]{(Long)dataEntity.getPkValue()});
            if (dataEntity.getBoolean("fileflag") && EmptyUtil.isNoEmpty((String)dataEntity.getString("uploadfilename"))) {
                dataEntity.set("creditdebitflag", null);
                dataEntity.set("creditamount", null);
                dataEntity.set("debitamount", null);
                dataEntity.set("amount", null);
                dataEntity.set("oppbanknumber", null);
                dataEntity.set("oppbankname", null);
                dataEntity.set("oppunit", null);
                dataEntity.set("oppbank", null);
                dataEntity.set("description", null);
            }
            ElecMatchDetailService elecMatchDetailService = new ElecMatchDetailService();
            Set idSet = transDetailList.stream().map(detail -> detail.getLong("id")).collect(Collectors.toSet());
            for (Object transDetailDO : transDetailDOs) {
                if (!idSet.isEmpty() && idSet.contains(transDetailDO.getLong("id"))) {
                    Long id = transDetailDO.getLong("id");
                    transDetailDO = transDetailList.stream().filter(d -> id.longValue() == d.getLong("id")).findFirst().get();
                }
                DynamicObjectCollection matchreceiptentry = transDetailDO.getDynamicObjectCollection("matchreceiptentry");
                if (!DataSourceEnum.FROMBANK.getValue().equals(dataEntity.getString("datasource")) || !DataSourceEnum.FROMBANK.getValue().equals(transDetailDO.getString("datasource"))) {
                    logger.error("\u7535\u5b50\u56de\u5355datasource=" + dataEntity.getString("datasource") + ",\u4ea4\u6613\u660e\u7ec6datasource=" + transDetailDO.getString("datasource"));
                    String receiptNo = transDetailDO.getString("receiptno");
                    if (EmptyUtil.isNoEmpty((String)receiptNo) && receiptNo.contains(";")) {
                        Set receiptNoSet = Arrays.stream(receiptNo.split(";")).collect(Collectors.toSet());
                        if (receiptNoSet.contains(dataEntity.getString("receiptno"))) {
                            receiptNoSet.remove(dataEntity.getString("receiptno"));
                            transDetailDO.set("receiptno", (Object)String.join((CharSequence)";", receiptNoSet));
                        }
                    } else {
                        transDetailDO.set("receiptno", null);
                    }
                    matchreceiptentry.removeIf(entry -> entry.getString("e_receiptno").equals(dataEntity.getString("receiptno")));
                    transDetailDO.set("matchreceiptentry", (Object)matchreceiptentry);
                    if (matchreceiptentry.isEmpty()) {
                        transDetailDO.set("ismatchereceipt", (Object)"0");
                    }
                } else {
                    transDetailDO.set("ismatchereceipt", (Object)"0");
                }
                transDetailList.add(transDetailDO);
                Set<Long> billIds = elecMatchDetailService.checkBizBillGetReceipt("cas_paybill", "bei_transdetail", transDetailDO.getLong("id"), transDetailDO.getString("bankcheckflag"));
                if (billIds.isEmpty()) continue;
                matchRelatedBizBillSet.addAll(billIds);
            }
        }
        String sql = "delete from t_bei_matchdetailentry where fid =? ";
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, deleteElecIds);
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        SaveServiceHelper.save((DynamicObject[])transDetailList.toArray(new DynamicObject[0]));
        if (!matchRelatedBizBillSet.isEmpty()) {
            ElecMatchCheckHelper.setBizBillGetReceipt("cas_paybill", matchRelatedBizBillSet, true);
        }
    }
}

