/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.tmc.bei.common.constants.ResultRpc;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.helper.TmcPrintServiceHelper;

public class NewViewReceiptService {
    private static final Log logger = LogFactory.getLog(NewViewReceiptService.class);

    public List getElec(String viewPageId, Object[] pks) {
        DynamicObject[] receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,fileserverurl,tcpurl,uploadfilename,username,password", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        if (receipts == null || receipts.length == 0) {
            ResultRpc resultRpc = new ResultRpc();
            resultRpc.setMsg(new BeiBizResource().getGetEreceipturlError());
            resultRpc.setOpenType(2);
            String resultRpcJson = JSON.toJSONString((Object)resultRpc);
            ArrayList<String> returnList = new ArrayList<String>();
            returnList.add(resultRpcJson);
            return returnList;
        }
        List<String> list = this.showReceipt(viewPageId, receipts);
        return list;
    }

    private List<String> showReceipt(String viewPageId, DynamicObject[] receipts) {
        String pdfUrl = null;
        ArrayList<String> list = new ArrayList<String>();
        String getEreceipturlError = new BeiBizResource().getGetEreceipturlError();
        String templateError = new BeiBizResource().getTemplateError();
        String getTemplateError = new BeiBizResource().getGetTemplateError();
        for (DynamicObject receipt : receipts) {
            String resultRpcStr;
            ResultRpc resultRpc;
            if (receipt.getBoolean("fileflag")) {
                String uploadfilename = receipt.getString("uploadfilename");
                logger.info("\u8bbe\u7f6etcpUrl:{},fileserverurl:{},username:{},uploadfilename:{}", new Object[]{receipt.getString("tcpurl"), UrlService.getDomainContextUrl(), receipt.getString("username"), uploadfilename});
                try {
                    if (uploadfilename.endsWith("pdf") || uploadfilename.endsWith("PDF")) {
                        pdfUrl = UrlService.getImageFullUrl((String)uploadfilename);
                        logger.info("PDF\u6587\u4ef6\u7c7b\u578b\u56de\u5355\u751f\u6210\u7684url\uff1a" + pdfUrl);
                        ResultRpc resultRpc2 = new ResultRpc();
                        resultRpc2.setOpenType(1);
                        resultRpc2.setUrl(pdfUrl);
                        String resultRpcStr2 = JSON.toJSONString((Object)resultRpc2);
                        list.add(resultRpcStr2);
                        continue;
                    }
                    pdfUrl = UrlService.getImageFullUrl((String)uploadfilename);
                    logger.error("\u5176\u4ed6\u6587\u4ef6\u7c7b\u578b\u56de\u5355\u751f\u6210\u7684url\uff1a" + pdfUrl);
                    String resultRpcStr3 = JSON.toJSONString((Object)this.getUrlOrOpenForm(pdfUrl));
                    list.add(resultRpcStr3);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    ResultRpc resultRpc3 = new ResultRpc();
                    resultRpc3.setOpenType(2);
                    resultRpc3.setMsg(getEreceipturlError);
                    String resultRpcStr4 = JSON.toJSONString((Object)resultRpc3);
                    list.add(resultRpcStr4);
                }
                continue;
            }
            String strReceiptID = receipt.getString("id");
            Long receiptID = Long.valueOf(strReceiptID);
            try {
                Map templateForm = TmcPrintServiceHelper.getTemplateForm((String)viewPageId, (String)"bei_elecreceipt", (String)strReceiptID, (Long[])new Long[]{receiptID});
                if (templateForm.size() > 0) {
                    for (String templateFormId : templateForm.keySet()) {
                        pdfUrl = TmcPrintServiceHelper.printPreview((String)viewPageId, (String)"bei_elecreceipt", (String)templateFormId, (Long[])new Long[]{receiptID});
                        String resultRpcStr5 = JSON.toJSONString((Object)this.getUrlOrOpenForm(pdfUrl));
                        list.add(resultRpcStr5);
                    }
                    continue;
                }
                resultRpc = new ResultRpc();
                resultRpc.setOpenType(2);
                resultRpc.setMsg(templateError);
                resultRpcStr = JSON.toJSONString((Object)resultRpc);
                list.add(resultRpcStr);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                resultRpc = new ResultRpc();
                resultRpc.setOpenType(2);
                resultRpc.setMsg(getTemplateError);
                resultRpcStr = JSON.toJSONString((Object)resultRpc);
                list.add(resultRpcStr);
            }
        }
        return list;
    }

    private ResultRpc getUrlOrOpenForm(String pdfUrl) {
        ResultRpc resultRpc = new ResultRpc();
        resultRpc.setUrl(pdfUrl);
        resultRpc.setOpenType(0);
        FormShowParameter parm = this.buildParameter(pdfUrl);
        parm.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"ViewReceiptService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        resultRpc.setSpStr(FormShowParameter.toJsonString((FormShowParameter)parm));
        return resultRpc;
    }

    private FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        return para;
    }
}

