/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.common.constants.ResultRpc;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.helper.TmcPrintServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ViewReceiptNewService {
    private static final Log logger = LogFactory.getLog(ViewReceiptNewService.class);

    public List<String> getResultRpcList(String viewPageId, String entryName, Object[] ids) {
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)entryName, (String)"id,bankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        logger.info("\u6570\u636e\u5171\u6709\uff1a" + objs.length);
        if (objs.length == 0) {
            ResultRpc resultRpc = new ResultRpc();
            resultRpc.setOpenType(2);
            resultRpc.setMsg(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u6570\u636e", (String)"ViewReceiptNewService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            String resultRpcStr = JSON.toJSONString((Object)resultRpc);
            ArrayList<String> list = new ArrayList<String>();
            list.add(resultRpcStr);
            return list;
        }
        ArrayList<Object> receiptIds = new ArrayList<Object>(objs.length);
        ArrayList<String> validRes = new ArrayList<String>(objs.length);
        for (DynamicObject obj : objs) {
            String receiptNo = obj.getString("bankcheckflag");
            if (!EmptyUtil.isEmpty((String)receiptNo)) {
                DynamicObject receipt = BusinessDataServiceHelper.loadSingle((String)"bei_elecreceipt", (String)"id,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag", (QFilter[])new QFilter[]{new QFilter("matchdetailentry.e_bankcheckflag", "=", (Object)receiptNo)});
                if (!EmptyUtil.isEmpty((DynamicObject)receipt)) {
                    receiptIds.add(receipt.getPkValue());
                    continue;
                }
                ResultRpc resultRpc = new ResultRpc();
                resultRpc.setOpenType(2);
                resultRpc.setMsg(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355", (String)"ViewReceiptNewService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                String resultRpcStr = JSON.toJSONString((Object)resultRpc);
                validRes.add(resultRpcStr);
                continue;
            }
            ResultRpc resultRpc = new ResultRpc();
            resultRpc.setOpenType(2);
            resultRpc.setMsg(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u6570\u636e\u7535\u5b50\u5bf9\u8d26\u6807\u8bc6\u7801\u4e3a\u7a7a", (String)"ViewReceiptNewService_2", (String)"tmc-bei-business", (Object[])new Object[0]));
            String resultRpcStr = JSON.toJSONString((Object)resultRpc);
            validRes.add(resultRpcStr);
        }
        if (receiptIds.size() == 0) {
            return validRes;
        }
        List<String> elecRes = this.getElec(viewPageId, receiptIds);
        validRes.addAll(elecRes);
        return validRes;
    }

    private List<String> getElec(String viewPageId, List<Object> receiptIds) {
        DynamicObject[] receipts = BusinessDataServiceHelper.load((String)"bei_elecreceipt", (String)"id,bank,fileflag,filepath,biztype,bankcheckflag,fileserverurl,tcpurl,uploadfilename,username,password", (QFilter[])new QFilter[]{new QFilter("id", "in", receiptIds)});
        if (receipts == null || receipts.length == 0) {
            ResultRpc resultRpc = new ResultRpc();
            resultRpc.setMsg(new BeiBizResource().getGetEreceipturlError());
            resultRpc.setOpenType(2);
            String resultRpcJson = JSON.toJSONString((Object)resultRpc);
            ArrayList<String> returnList = new ArrayList<String>();
            returnList.add(resultRpcJson);
            return returnList;
        }
        List<String> list = this.showReceipt(viewPageId, receipts);
        return list;
    }

    private List<String> showReceipt(String viewPageId, DynamicObject[] receipts) {
        String pdfUrl = null;
        ArrayList<String> list = new ArrayList<String>();
        String getEreceipturlError = new BeiBizResource().getGetEreceipturlError();
        String templateError = new BeiBizResource().getTemplateError();
        String getTemplateError = new BeiBizResource().getGetTemplateError();
        for (DynamicObject receipt : receipts) {
            String resultRpcStr;
            ResultRpc resultRpc;
            if (receipt.getBoolean("fileflag")) {
                String uploadfilename = receipt.getString("uploadfilename");
                logger.info("\u8bbe\u7f6etcpUrl:{},fileserverurl:{},username:{},uploadfilename\uff1a{}", new Object[]{receipt.getString("tcpurl"), UrlService.getDomainContextUrl(), receipt.getString("username"), uploadfilename});
                try {
                    if (uploadfilename.endsWith("pdf") || uploadfilename.endsWith("PDF")) {
                        pdfUrl = UrlService.getImageFullUrl((String)uploadfilename);
                        logger.info("PDF\u6587\u4ef6\u7c7b\u578b\u56de\u5355\u751f\u6210\u7684url\uff1a" + pdfUrl);
                        ResultRpc resultRpc2 = new ResultRpc();
                        resultRpc2.setOpenType(1);
                        resultRpc2.setUrl(pdfUrl);
                        String resultRpcStr2 = JSON.toJSONString((Object)resultRpc2);
                        list.add(resultRpcStr2);
                        continue;
                    }
                    pdfUrl = UrlService.getImageFullUrl((String)uploadfilename);
                    logger.info("\u5176\u4ed6\u6587\u4ef6\u7c7b\u578b\u56de\u5355\u751f\u6210\u7684url\uff1a" + pdfUrl);
                    String resultRpcStr3 = JSON.toJSONString((Object)this.getUrlOrOpenForm(pdfUrl));
                    list.add(resultRpcStr3);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    ResultRpc resultRpc3 = new ResultRpc();
                    resultRpc3.setOpenType(2);
                    resultRpc3.setMsg(getEreceipturlError);
                    String resultRpcStr4 = JSON.toJSONString((Object)resultRpc3);
                    list.add(resultRpcStr4);
                }
                continue;
            }
            String strReceiptID = receipt.getString("id");
            Long receiptID = Long.valueOf(strReceiptID);
            try {
                Map templateForm = TmcPrintServiceHelper.getTemplateForm((String)viewPageId, (String)"bei_elecreceipt", (String)strReceiptID, (Long[])new Long[]{receiptID});
                if (templateForm.size() > 0) {
                    for (String templateFormId : templateForm.keySet()) {
                        pdfUrl = TmcPrintServiceHelper.printPreview((String)viewPageId, (String)"bei_elecreceipt", (String)templateFormId, (Long[])new Long[]{receiptID});
                        String resultRpcStr5 = JSON.toJSONString((Object)this.getUrlOrOpenForm(pdfUrl));
                        list.add(resultRpcStr5);
                    }
                    continue;
                }
                resultRpc = new ResultRpc();
                resultRpc.setOpenType(2);
                resultRpc.setMsg(templateError);
                resultRpcStr = JSON.toJSONString((Object)resultRpc);
                list.add(resultRpcStr);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                resultRpc = new ResultRpc();
                resultRpc.setOpenType(2);
                resultRpc.setMsg(getTemplateError);
                resultRpcStr = JSON.toJSONString((Object)resultRpc);
                list.add(resultRpcStr);
            }
        }
        return list;
    }

    private ResultRpc getUrlOrOpenForm(String pdfUrl) {
        ResultRpc resultRpc = new ResultRpc();
        resultRpc.setUrl(pdfUrl);
        resultRpc.setOpenType(0);
        FormShowParameter parm = this.buildParameter(pdfUrl);
        parm.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u56de\u5355", (String)"ViewReceiptService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
        resultRpc.setSpStr(FormShowParameter.toJsonString((FormShowParameter)parm));
        return resultRpc;
    }

    private FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        return para;
    }
}

