/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.elec;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.matchtpl.MatcherTpl;
import kd.bos.print.matchtpl.ViewType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.common.helper.BeiHelper;
import kd.tmc.bei.common.helper.BeiPrintHelper;
import kd.tmc.bei.common.helper.ReceiptPrintHelper;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.common.ofd.OfdConvertUtil;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ViewStatementService {
    private static final Log logger = LogFactory.getLog(ViewStatementService.class);

    public void openStatementById(IFormView view, Object[] pks, String key) {
        ArrayList<Long> pkList = new ArrayList<Long>(10);
        for (Object pk : pks) {
            pkList.add(Long.valueOf(pk.toString()));
        }
        DynamicObject[] statements = BusinessDataServiceHelper.load((String)"bei_elecstatement", (String)"id,isfile,urlentry.e_fileservicepath", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
        if (statements == null || statements.length == 0) {
            return;
        }
        this.showStatement(view, statements, key);
    }

    private void showStatement(IFormView view, DynamicObject[] statements, String key) {
        ArrayList<String> errMsgList = new ArrayList<String>();
        String pdfUrl = this.getPdfUrl(view.getPageId(), statements, errMsgList, key);
        if (!errMsgList.isEmpty()) {
            view.showErrorNotification(String.join((CharSequence)"", errMsgList));
        } else if (pdfUrl != null) {
            this.openForm(view, pdfUrl);
        }
    }

    private String getPdfUrl(String pageId, DynamicObject[] statements, List<String> errMsgList, String key) {
        ArrayList<String> listPdf = new ArrayList<String>();
        ArrayList<byte[]> resList = new ArrayList<byte[]>();
        String getStatementUrlError = new BeiBizResource().getGetStatementUrlError();
        for (DynamicObject statement : statements) {
            DynamicObjectCollection urlEntry = statement.getDynamicObjectCollection("urlentry");
            if (Objects.equals(key, "viewstatement") && EmptyUtil.isEmpty((DynamicObjectCollection)urlEntry)) {
                errMsgList.add(getStatementUrlError);
                continue;
            }
            if (statement.getBoolean("isfile")) {
                try {
                    for (DynamicObject urlInfo : urlEntry) {
                        byte[] bytes;
                        String uploadFileName = this.getRealUploadUrl(urlInfo);
                        if (StringUtils.isEmpty((CharSequence)uploadFileName)) {
                            errMsgList.add(getStatementUrlError);
                        }
                        if (uploadFileName.endsWith("pdf") || uploadFileName.endsWith("PDF")) {
                            logger.info("PDF\u6587\u4ef6\u7c7b\u578b\u5bf9\u8d26\u5355\u751f\u6210\u7684url\uff1a" + uploadFileName);
                            bytes = BeiHelper.getPdfPutStream((String)uploadFileName);
                            if (bytes.length != 0) {
                                resList.add(bytes);
                                continue;
                            }
                            errMsgList.add(getStatementUrlError);
                            continue;
                        }
                        if (uploadFileName.endsWith("ofd") || uploadFileName.endsWith("OFD")) {
                            bytes = OfdConvertUtil.convertToPdfNew((byte[])BeiHelper.getPdfPutStream((String)uploadFileName));
                            resList.add(bytes);
                            continue;
                        }
                        logger.info("\u5176\u4ed6\u6587\u4ef6\u7c7b\u578b\u5bf9\u8d26\u5355\u751f\u6210\u7684url\uff1a" + uploadFileName);
                        ReceiptPrintHelper.imageConvertPdf((String)uploadFileName, resList, null);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    errMsgList.add(getStatementUrlError);
                    continue;
                }
            }
            Long statementId = statement.getLong("id");
            try {
                Map statementTemplate = ReceiptPrintHelper.getMatchReceiptTemplate((String)"bei", (String)"bei_elecstatement", Collections.singleton(statementId), (ViewType)ViewType.LIST, (String)pageId);
                statementTemplate.remove("");
                logger.info("ViewStatementService templateForm.size=" + statementTemplate.size());
                if (!statementTemplate.isEmpty()) {
                    for (MatcherTpl template : (Set)statementTemplate.get(statementId)) {
                        String templateId = template.getTplId();
                        logger.info("ViewStatementService templateForm.keySet = " + templateId);
                        String templateFormId = MetadataDao.getNumberById((String)templateId);
                        logger.info("ViewStatementService templateFormId = " + templateFormId);
                        String url = PrintServiceHelper.createPdfUrl((String)pageId, (String)"bei_elecstatement", (String)templateFormId, (Object[])new Long[]{statementId});
                        if (StringUtils.isNotEmpty((CharSequence)url)) {
                            listPdf.add(url);
                            continue;
                        }
                        PrtAttach attach = BeiPrintHelper.doNewPrint((String)pageId, (String)"bei_elecstatement", (String)templateId, (Object)statement.getPkValue());
                        if (!Objects.nonNull(attach)) continue;
                        List attachDetail = attach.getAttachDetail();
                        for (PrtAttach.AttachDetail detail : attachDetail) {
                            byte[] pdfPutStream = BeiHelper.getPdfPutStream((String)detail.getFilePath());
                            resList.add(pdfPutStream);
                        }
                    }
                    continue;
                }
                errMsgList.add(new BeiBizResource().getStatementTemplateError());
            }
            catch (Exception e) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errMsgList.add(new BeiBizResource().getStatementSetUpTemplateError());
            }
        }
        this.readTemplate(listPdf, resList);
        String pdfUrl = null;
        try {
            pdfUrl = this.finlyOpenForm(resList);
        }
        catch (Exception e) {
            logger.error("\u62fc\u63a5pdf\u62a5\u9519\uff1a", (Throwable)e);
            errMsgList.add(new BeiBizResource().dealPdfError());
        }
        logger.info("pdfUrl: " + pdfUrl);
        return pdfUrl;
    }

    private void readTemplate(List<String> listPdf, List<byte[]> resList) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        for (String string : listPdf) {
            InputStream ins = tempFileCache.getInputStream(string);
            try {
                int result;
                byte[] bytes = new byte[ins.available()];
                int bytesToRead = ins.available();
                for (int bytesRead = 0; bytesRead < bytesToRead; bytesRead += result) {
                    result = ins.read(bytes, bytesRead, bytesToRead - bytesRead);
                    if (result != -1) continue;
                    break;
                }
                resList.add(bytes);
                ins.close();
            }
            catch (IOException e) {
                logger.info("IO\u6d41\u5931\u8d25" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    private String finlyOpenForm(List<byte[]> resList) {
        if (resList.size() > 0) {
            byte[] mergeMultiPdf = PrintServiceHelper.mergeMultiPdf(resList);
            NotePrintService notePrintService = new NotePrintService();
            LocaleString localeString = new LocaleString("elecstatement");
            return notePrintService.createPdfUrl(localeString, mergeMultiPdf);
        }
        return null;
    }

    private void openForm(IFormView view, String pdfUrl) {
        IFormView mainView = view.getMainView();
        if (mainView == null) {
            view.openUrl(pdfUrl);
        } else {
            FormShowParameter parm = this.buildParameter(pdfUrl);
            parm.setCaption(ResManager.loadKDString((String)"\u8054\u67e5\u7535\u5b50\u5bf9\u8d26\u5355", (String)"ViewStatementService_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            view.getParentView().showForm(parm);
            view.sendFormAction(view.getParentView());
        }
    }

    private FormShowParameter buildParameter(String pdfUrl) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.setCustomParam("src", (Object)pdfUrl);
        return para;
    }

    private String getRealUploadUrl(DynamicObject statement) {
        String uploadFilName = statement.getString("e_fileservicepath");
        String realPath = "";
        if (StringUtils.isNotEmpty((CharSequence)uploadFilName)) {
            realPath = uploadFilName;
            if (!uploadFilName.contains(".") && !uploadFilName.contains("/")) {
                try {
                    FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                    realPath = attachmentFileService.getFileServiceExt().getRealPath(uploadFilName);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6587\u4ef6\u771f\u5b9e\u8def\u5f84\u5931\u8d25" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        return realPath;
    }
}

