/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.CasBotpHelper;
import kd.tmc.bei.business.helper.TransDetailHelper;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DealTheSameNameTransHelper {
    private static Log logger = LogFactory.getLog(DealTheSameNameTransHelper.class);

    public static void dealCancleRuleSameNameTrans(List<DynamicObject> cas_bei_Details, String entityName) {
        String botpDetailEntityName = "";
        String otherBotpDetailEntityName = "";
        if ("cas_paybill".equalsIgnoreCase(entityName)) {
            botpDetailEntityName = "bei_intelpay";
            otherBotpDetailEntityName = "bei_intelrec";
        } else {
            botpDetailEntityName = "bei_intelrec";
            otherBotpDetailEntityName = "bei_intelpay";
        }
        List detailIds = cas_bei_Details.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        DynamicObject[] thisDetails = BusinessDataServiceHelper.load((Object[])detailIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)botpDetailEntityName));
        Set<DynamicObject> filterThisDetails = DealTheSameNameTransHelper.filterTheSameNameTrans(thisDetails);
        if (CollectionUtils.isEmpty(filterThisDetails)) {
            return;
        }
        HashSet<Long> allotherdetailIds = new HashSet<Long>();
        for (DynamicObject thisDetail : filterThisDetails) {
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)botpDetailEntityName, (Long[])new Long[]{(Long)thisDetail.getPkValue()});
            if (CollectionUtils.isEmpty((Map)targetBills)) {
                return;
            }
            Set bizBillIds = targetBills.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
            String targetEntityName = targetBills.keySet().stream().findFirst().orElseGet(() -> null);
            for (Long bizBillId : bizBillIds) {
                Set<Long> otherDetailSet;
                Set<Long> detailSet = CasBotpHelper.getSrcBillByDestBill(bizBillId, targetEntityName, botpDetailEntityName);
                if (!CollectionUtils.isEmpty(detailSet)) {
                    DealTheSameNameTransHelper.updateDetail(detailSet, botpDetailEntityName);
                }
                if (CollectionUtils.isEmpty(otherDetailSet = CasBotpHelper.getSrcBillByDestBill(bizBillId, targetEntityName, otherBotpDetailEntityName))) continue;
                DealTheSameNameTransHelper.updateDetail(otherDetailSet, otherBotpDetailEntityName);
                allotherdetailIds.addAll(otherDetailSet);
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            DealTheSameNameTransHelper.deleteOtherDetailCasBill(otherBotpDetailEntityName, allotherdetailIds);
        }
    }

    private static void deleteOtherDetailCasBill(String otherBotpDetailEntityName, Set<Long> allotherdetailIds) {
        if (allotherdetailIds.size() > 0) {
            HashSet recBillids;
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)otherBotpDetailEntityName, (Long[])allotherdetailIds.toArray(new Long[0]));
            if (CollectionUtils.isEmpty((Map)targetBills)) {
                return;
            }
            HashSet payBillids = (HashSet)targetBills.get("cas_paybill");
            if (null != payBillids && payBillids.size() > 0) {
                OperationServiceHelper.executeOperate((String)"deletework", (String)"cas_paybill", (Object[])payBillids.toArray(new Long[0]), (OperateOption)OperateOption.create());
            }
            if (null != (recBillids = (HashSet)targetBills.get("cas_recbill")) && recBillids.size() > 0) {
                OperationServiceHelper.executeOperate((String)"deletework", (String)"cas_recbill", (Object[])recBillids.toArray(new Long[0]), (OperateOption)OperateOption.create());
            }
        }
    }

    private static void updateDetail(Set<Long> detailSet, String entityName) {
        DynamicObject[] thisSrcDetails = BusinessDataServiceHelper.load((Object[])detailSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Arrays.stream(thisSrcDetails).filter(o -> ReceredtypeEnum.ACCOUNTED.getValue().equals(o.getString("receredtype"))).forEach(v -> {
            v.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
            v.set("isreced", (Object)"0");
            v.set("recedbilltype", null);
            v.set("recedbillnumber", null);
            v.set("receredway", null);
            AutoMatchHelper.deleteRecedBillEntry(v);
        });
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])thisSrcDetails);
        }
    }

    private static Set<DynamicObject> filterTheSameNameTrans(DynamicObject[] thisSrcDetail) {
        Set sameNameTransList = Arrays.stream(thisSrcDetail).filter(detail -> TransDetailHelper.updateSynonym(detail, detail.getDynamicObject("accountbank"), detail.getDynamicObject("company"))).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(sameNameTransList)) {
            return null;
        }
        Set dynamicObjects = sameNameTransList.stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getString("oppbanknumber"))).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(dynamicObjects)) {
            return null;
        }
        DynamicObjectCollection acctDynamics = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber,company.id", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "in", dynamicObjects.stream().map(a -> a.getString("oppbanknumber")).collect(Collectors.toSet()))});
        HashMap map = new HashMap(dynamicObjects.size());
        acctDynamics.forEach(e -> map.put(e.getString("bankaccountnumber"), e.getLong("company.id")));
        DynamicObjectCollection thisAccts = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,bankaccountnumber,company.id", (QFilter[])new QFilter[]{new QFilter("id", "in", dynamicObjects.stream().map(a -> a.getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet()))});
        if (CollectionUtils.isEmpty((Collection)thisAccts)) {
            return null;
        }
        HashMap thisMaps = new HashMap(thisAccts.size());
        thisAccts.forEach(e -> thisMaps.put(e.getLong("id"), e.getLong("company.id")));
        return dynamicObjects.stream().filter(e -> (long)((Long)map.get(e.getString("oppbanknumber"))).compareTo((Long)thisMaps.get(e.getDynamicObject("accountbank").getLong("id"))) == 0L).collect(Collectors.toSet());
    }
}

