/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.missing;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.BalanceCheckErrorHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class MissingRecordRepairService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(MissingRecordRepairService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("accountbank");
        sic.add("bizdate");
        sic.add("currency");
        sic.add("correcttype");
        sic.add("trynum");
        sic.add("checkresult");
        sic.add("checktype");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Set acctIds = Arrays.stream(dataEntities).map(t -> t.getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet());
        Set bankIds = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter("issetbankinterface", "=", (Object)"1").and("id", "in", acctIds).toArray()).stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        List<DynamicObject> dataList = Arrays.stream(dataEntities).filter(t -> bankIds.contains(t.getDynamicObject("accountbank").getPkValue())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dataList)) {
            logger.info("no bankinterface account exist");
            this.operationResult.setSuccess(true);
            return;
        }
        List<OperateErrorInfo> errorInfoList = BalanceCheckErrorHelper.repairMissingRecord(dataList.toArray(new DynamicObject[0]));
        if (!CollectionUtils.isEmpty(errorInfoList)) {
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(errorInfoList);
            this.operationResult.setShowMessage(false);
        } else {
            this.operationResult.setSuccess(true);
        }
    }
}

