/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.online;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.enums.ReceredTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailClaimService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(TransDetailClaimService.class);
    private static final String entry = "t_bei_transdetail_entry";
    public static final String PUSHRECBILL = "pushrecbill";
    private static final String ReceivingRec = "receivingrec";

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("number");
        sic.add("customer");
        sic.add("lastmodifier");
        sic.add("lastmodifytime");
        sic.add("desc");
        sic.add("remark");
        sic.add("receredtype");
        sic.add("detailinfo_entry");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String sql;
            Object id = dataEntity.getPkValue();
            String billnum = dataEntity.getString("number");
            Object customer = dataEntity.getDynamicObject("customer").getPkValue();
            Object lastmodifier = dataEntity.getDynamicObject("lastmodifier").getPkValue();
            Date lastmodifytime = dataEntity.getDate("lastmodifytime");
            String desc = dataEntity.getString("desc");
            Object[] dataObject = new Object[]{id, billnum, customer, lastmodifier, lastmodifytime, desc};
            dataList.add(dataObject);
            ArrayList<Object[]> entryList = new ArrayList<Object[]>();
            for (DynamicObject DETAILINFO : dataEntity.getDynamicObjectCollection("detailinfo_entry")) {
                Object pkValue = dataEntity.getPkValue();
                Long entryid = DB.genLongId((String)entry);
                int seq = DETAILINFO.getInt("seq");
                BigDecimal recamount = DETAILINFO.getBigDecimal("recamount");
                DynamicObject category = DETAILINFO.getDynamicObject("category");
                String remark = DETAILINFO.getString("remark");
                if (recamount.compareTo(BigDecimal.ZERO) == 0 && EmptyUtil.isEmpty((DynamicObject)category)) continue;
                Object[] upObject = new Object[]{pkValue, entryid, seq, recamount, category.getPkValue(), remark};
                entryList.add(upObject);
            }
            if (dataList.size() > 0) {
                sql = "insert into t_bei_transdetail_e (FID,FNUMBER, FCUSTOMERID, FLASTMODIFIERID,FLASTMODIFYTIME ,FDESC) values (?, ?,?, ?,?,?)";
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, dataList);
            }
            if (entryList.size() <= 0) continue;
            sql = "insert into t_bei_transdetail_entry (FID,FENTRYID, FSEQ, FRECAMOUNT,FCATEGORYID,FREMARK) values (?, ?,?, ?,?,?)";
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, entryList);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        ArrayList<Object> pkValues = new ArrayList<Object>();
        for (DynamicObject dataEntity : dataEntities) {
            pkValues.add(dataEntity.getPkValue());
        }
        this.pushCasBill(PUSHRECBILL, pkValues.toArray(new Long[0]));
    }

    private void pushCasBill(String pushOpKey, Long[] pkIds) {
        OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)pushOpKey, (String)"bei_transdetail_claim", (Object[])pkIds, (OperateOption)OperateOption.create());
        List successPkIds = result.getSuccessPkIds();
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"bei_transdetail_claim", (Long[])pkIds);
        HashSet pkValues = (HashSet)botpMap.get("cas_recbill");
        if (result.isSuccess()) {
            OperationResult operationResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)ReceivingRec, (String)"cas_recbill", (Object[])pkValues.toArray(), (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                OperationResult unAuditResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"unaudit", (String)"cas_recbill", (Object[])pkValues.toArray(), (OperateOption)OperateOption.create());
                if (unAuditResult.isSuccess()) {
                    OperationResult deleteResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)"cas_recbill", (Object[])pkValues.toArray(), (OperateOption)OperateOption.create());
                    if (!deleteResult.isSuccess()) {
                        pkValues.removeAll(deleteResult.getSuccessPkIds());
                        logger.info(String.format("\u51fa\u7eb3\u4e0b\u6e38\u5355\u636e\u5220\u9664\u5931\u8d25: [%s], ID: %s", "cas_recbill", pkValues.toString()));
                    } else {
                        this.rollback(pkIds);
                    }
                }
            } else {
                DynamicObject upInitBill = TmcDataServiceHelper.loadSingle((Object)pkIds[0], (String)"bei_transdetail_claim");
                upInitBill.set("receredtype", (Object)ReceredTypeEnum.RECERED.getValue());
                SaveServiceHelper.update((DynamicObject)upInitBill);
            }
        } else {
            if (pkValues != null) {
                OperationResult deleteResult = TmcOperateServiceHelper.execOperateWithoutThrow((String)"delete", (String)"cas_recbill", (Object[])pkValues.toArray(), (OperateOption)OperateOption.create());
                if (!deleteResult.isSuccess()) {
                    pkValues.removeAll(deleteResult.getSuccessPkIds());
                    logger.info(String.format("\u51fa\u7eb3\u4e0b\u6e38\u5355\u636e\u5220\u9664\u5931\u8d25: [%s], ID: %s", "cas_recbill", pkValues.toString()));
                } else {
                    this.rollback(pkIds);
                }
            }
            String errMsg = TmcOperateServiceHelper.decodeErrorMsg((OperationResult)result);
            throw new KDBizException(errMsg);
        }
    }

    private void rollback(Long[] pkIds) {
        DynamicObject upInitBill = TmcDataServiceHelper.loadSingle((Object)pkIds[0], (String)"bei_transdetail_claim");
        upInitBill.set("receredtype", (Object)ReceredTypeEnum.UNRECERED.getValue());
        SaveServiceHelper.update((DynamicObject)upInitBill);
        DB.execute((DBRoute)DBRouteConst.TMC, (String)("delete from  t_bei_transdetail_e where FID = " + pkIds[0]));
        DB.execute((DBRoute)DBRouteConst.TMC, (String)("delete from  t_bei_transdetail_entry where FID = " + pkIds[0]));
    }
}

