/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.opservice.recpaydetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.business.helper.CasFlowConfirmLogHelper;
import kd.tmc.bei.business.service.factory.AutoMatchServiceFactory;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RecPayCancelMatchOpService
extends AbstractTmcBizOppService {
    private static final Log LOGGER = LogFactory.getLog(RecPayCancelMatchOpService.class);

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(24);
        lst.add("billno");
        lst.add("smartmatch");
        lst.add("oppunit");
        lst.add("description");
        lst.add("creditamount");
        lst.add("debitamount");
        lst.add("recedbillnumber");
        lst.add("autorecorpay");
        lst.add("receredtype");
        lst.add("company");
        lst.add("recedbilltype");
        lst.add("receredway");
        lst.add("rulename");
        lst.add("bankcheckflag");
        lst.add("ishandlink");
        lst.add("recedbillentryid");
        lst.add("currency");
        lst.add("bizdate");
        lst.addAll(AutoMatchHelper.getMatchFieldKeys());
        return lst;
    }

    public void process(DynamicObject[] detailDoArr) throws KDException {
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        LOGGER.info("RecPayCancelMatchOpService begin");
        super.afterProcess(dataEntities);
        Map<String, Map<Long, Date>> bizDateMap = AutoMatchServiceHelper.getBizDate(dataEntities);
        ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(dataEntities.length);
        ArrayList otherDetailIds = new ArrayList(10);
        ArrayList<Long> detailIds = new ArrayList<Long>(dataEntities.length);
        HashSet differMatchOpNumbers = new HashSet(10);
        for (DynamicObject transDetail : dataEntities) {
            detailIds.add(transDetail.getLong("id"));
            String receredWay = transDetail.getString("receredway");
            transDetail.getDynamicObjectCollection("recedbillentry").forEach(item -> {
                String recedBillType = item.getString("e_recedbilltype");
                if ("bei_transdetail".equals(recedBillType) && "singlematch".equals(receredWay)) {
                    otherDetailIds.add(item.getLong("e_recedbillid"));
                }
                Date traceDate = null;
                if (bizDateMap.containsKey(item.getString("e_recedbilltype"))) {
                    traceDate = (Date)((Map)bizDateMap.get(item.getString("e_recedbilltype"))).get(item.getLong("e_recedbillid"));
                }
                String sourceEntity = EmptyUtil.isEmpty((BigDecimal)transDetail.getBigDecimal("creditamount")) ? "bei_intelpay" : "bei_intelrec";
                AutoMatchInfoParam autoMatchInfoParam = new AutoMatchInfoParam(sourceEntity, transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), item.getString("e_recedbilltype"), item.getString("e_recedbillnumber"), Long.valueOf(item.getLong("e_recedbillid")), Long.valueOf(item.getLong("e_recedbillentryid")), Long.valueOf(transDetail.getLong("currency.id")), item.getString("e_amttype"), item.getBigDecimal("e_amount"), transDetail.getString("bankcheckflag"), traceDate, item.getString("e_opnumber"), item.getString("e_direction"));
                if (ReceredWayEnum.DIFFERMATCH.getValue().equals(receredWay)) {
                    differMatchOpNumbers.add(item.getString("e_opnumber"));
                    if (Arrays.asList("cas_paybill", "cas_paybill_synonym", "cas_paybill_spanmainpart", "cas_paybill_cash").contains(item.getString("e_recedbilltype"))) {
                        autoMatchInfoParam.setDifferMatchSourceEntity("bei_intelpay");
                    } else if ("cas_recbill".equals(item.getString("e_recedbilltype"))) {
                        autoMatchInfoParam.setDifferMatchSourceEntity("bei_intelrec");
                    } else {
                        autoMatchInfoParam.setDifferMatchSourceEntity(transDetail.getDataEntityType().getName());
                    }
                }
                tAutoMatchInfoList.add(autoMatchInfoParam);
            });
        }
        if (!otherDetailIds.isEmpty()) {
            DynamicObject[] otherDetails = TmcDataServiceHelper.load((Object[])otherDetailIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas"));
            Map<String, Map<Long, Date>> otherBizDateMap = AutoMatchServiceHelper.getBizDate(otherDetails);
            for (DynamicObject transDetail : otherDetails) {
                transDetail.getDynamicObjectCollection("recedbillentry").forEach(item -> {
                    Date traceDate = null;
                    if (otherBizDateMap.containsKey(item.getString("e_recedbilltype"))) {
                        traceDate = (Date)((Map)otherBizDateMap.get(item.getString("e_recedbilltype"))).get(item.getLong("e_recedbillid"));
                    }
                    String sourceEntity = EmptyUtil.isEmpty((BigDecimal)transDetail.getBigDecimal("creditamount")) ? "bei_intelpay" : "bei_intelrec";
                    tAutoMatchInfoList.add(new AutoMatchInfoParam(sourceEntity, transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), item.getString("e_recedbilltype"), item.getString("e_recedbillnumber"), Long.valueOf(item.getLong("e_recedbillid")), Long.valueOf(item.getLong("e_recedbillentryid")), Long.valueOf(transDetail.getLong("currency.id")), item.getString("e_amttype"), item.getBigDecimal("e_amount"), transDetail.getString("bankcheckflag"), traceDate, item.getString("e_opnumber"), item.getString("e_direction")));
                });
            }
        }
        DynamicObject[] mergedData = null;
        if (!differMatchOpNumbers.isEmpty()) {
            Object[] otherDetails = TmcDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id,billno,company,bizdate,creditamount,debitamount,currency,receredway,bankcheckflag,recedbillentry,recedbillentry.e_recedbilltype,recedbillentry.e_recedbillid,recedbillentry.e_recedbillentryid,recedbillentry.e_recedbillnumber,recedbillentry.e_amttype,recedbillentry.e_amount,recedbillentry.e_direction,recedbillentry.e_opnumber", (QFilter[])new QFilter[]{new QFilter("recedbillentry.e_opnumber", "in", differMatchOpNumbers), new QFilter("receredway", "=", (Object)"differmatch"), new QFilter("id", "not in", detailIds)});
            Map<String, Map<Long, Date>> otherBizDateMap = AutoMatchServiceHelper.getBizDate((DynamicObject[])otherDetails);
            for (DynamicObject dynamicObject : otherDetails) {
                dynamicObject.getDynamicObjectCollection("recedbillentry").forEach(item -> {
                    Date traceDate = null;
                    if (otherBizDateMap.containsKey(item.getString("e_recedbilltype"))) {
                        traceDate = (Date)((Map)otherBizDateMap.get(item.getString("e_recedbilltype"))).get(item.getLong("e_recedbillid"));
                    }
                    String sourceEntity = EmptyUtil.isEmpty((BigDecimal)transDetail.getBigDecimal("creditamount")) ? "bei_intelpay" : "bei_intelrec";
                    AutoMatchInfoParam autoMatchInfoParam = new AutoMatchInfoParam(sourceEntity, transDetail.getString("billno"), Long.valueOf(transDetail.getLong("id")), item.getString("e_recedbilltype"), item.getString("e_recedbillnumber"), Long.valueOf(item.getLong("e_recedbillid")), Long.valueOf(item.getLong("e_recedbillentryid")), Long.valueOf(transDetail.getLong("currency.id")), item.getString("e_amttype"), item.getBigDecimal("e_amount"), transDetail.getString("bankcheckflag"), traceDate, item.getString("e_opnumber"), item.getString("e_direction"));
                    if (Arrays.asList("cas_paybill", "cas_paybill_synonym", "cas_paybill_spanmainpart", "cas_paybill_cash").contains(item.getString("e_recedbilltype"))) {
                        autoMatchInfoParam.setDifferMatchSourceEntity("bei_intelpay");
                    } else if ("cas_recbill".equals(item.getString("e_recedbilltype"))) {
                        autoMatchInfoParam.setDifferMatchSourceEntity("bei_intelrec");
                    } else {
                        autoMatchInfoParam.setDifferMatchSourceEntity(transDetail.getDataEntityType().getName());
                    }
                    tAutoMatchInfoList.add(autoMatchInfoParam);
                });
            }
            mergedData = (DynamicObject[])ArrayUtils.addAll((Object[])dataEntities, (Object[])otherDetails);
        }
        AutoMatchServiceFactory.getAutoMatchService().execute(tAutoMatchInfoList, null, null, false, null);
        try (TXHandle tx = TX.requiresNew();){
            CasFlowConfirmLogHelper.saveCancelMatchLog(mergedData == null ? dataEntities : mergedData, tAutoMatchInfoList);
        }
    }
}

