/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.service;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankCheckFlagUpdateService {
    private static final Log logger = LogFactory.getLog(BankCheckFlagUpdateService.class);

    public String transDetailAndBillUpdata() {
        RpcResult recResult = new RpcResult();
        try {
            logger.info("kd.tmc.bei.service.BankCheckFlagUpdateService");
            logger.info(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5bf9\u8d26\u6807\u8bc6\u7801\u5386\u53f2\u6570\u636e\u5347\u7ea7", (String)"InitService_02", (String)"tmc-bei-mservice", (Object[])new Object[0]));
            this.updataPaymentBill();
            this.updataReceivingBill();
            this.updataAgentBill();
            this.updateClaimNoticeBill();
            this.updateBankJournal();
            logger.info(ResManager.loadKDString((String)"\u5bf9\u8d26\u6807\u8bc6\u7801\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5", (String)"InitService_03", (String)"tmc-bei-mservice", (Object[])new Object[0]));
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    private void updateBankJournal() {
        logger.info("updateBankJournal------------------------------1");
        QFilter updateDataFilter = QFilter.isNull((String)"bankcheckentity.ebankcheckflag");
        String selectProperties = "id,bankcheckflag,bankcheckflag_tag,bankcheckentity.ebankcheckflag";
        this.updataBill(updateDataFilter, "cas_bankjournal", selectProperties);
    }

    private void updateClaimNoticeBill() {
        logger.info("updateClaimNoticeBill------------------------------1");
        QFilter updateDataFilter = QFilter.isNull((String)"bankcheckentity.ebankcheckflag");
        String selectProperties = "id,bankcheckflag,bankcheckflag_tag,bankcheckentity.ebankcheckflag";
        this.updataBill(updateDataFilter, "cas_claimcenterbill", selectProperties);
    }

    private void updataAgentBill() {
        logger.info("updateAgentPayBill------------------------------1");
        QFilter updateDataFilter = QFilter.isNull((String)"bankcheckentity.ebankcheckflag");
        String selectProperties = "id,bankcheckflag,bankcheckflag_tag,bankcheckentity.ebankcheckflag";
        this.updataBill(updateDataFilter, "cas_agentpaybill", selectProperties);
    }

    private void updataReceivingBill() {
        logger.info("updateReceivingBill------------------------------1");
        String selectProperties = "id,bankcheckflag,bankcheckflag_tag,bankcheckentity.ebankcheckflag";
        QFilter updateDataFilter = QFilter.isNull((String)"bankcheckentity.ebankcheckflag");
        this.updataBill(updateDataFilter, "cas_recbill", selectProperties);
    }

    private void updataPaymentBill() {
        logger.info("updatePaymentBill------------------------------1");
        QFilter updateDataFilter = QFilter.isNull((String)"bankcheckentity.ebankcheckflag");
        String selectProperties = "id,bankcheckflag,bankcheckflag_tag,bankcheckentity.ebankcheckflag";
        this.updataBill(updateDataFilter, "cas_paybill", selectProperties);
    }

    private void updataBill(QFilter tQFilter, String entityName, String selectProperties) {
        logger.info(String.format("updata {%s}------------------------------1", entityName));
        QFilter idFilter = null;
        Long beginId = 0L;
        int i = 0;
        do {
            int size = 0;
            idFilter = new QFilter("id", ">", (Object)beginId);
            DynamicObject[] updateDo = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{idFilter, tQFilter}, (String)"id", (int)999);
            if (updateDo != null && updateDo.length > 0) {
                size = updateDo.length;
                for (DynamicObject entity : updateDo) {
                    beginId = entity.getLong("id");
                    DynamicObjectCollection bankCheckEntity = entity.getDynamicObjectCollection("bankcheckentity");
                    String bankCheckFlagTag = "";
                    String bankCheckFlag = entity.getString("bankcheckflag");
                    if (!"cas_claimcenterbill".equalsIgnoreCase(entityName)) {
                        bankCheckFlagTag = entity.getString("bankcheckflag_tag");
                    }
                    if (!EmptyUtil.isEmpty((String)bankCheckFlagTag)) {
                        this.addNewEntry(bankCheckFlagTag, bankCheckEntity);
                        continue;
                    }
                    if (EmptyUtil.isEmpty((String)bankCheckFlag)) continue;
                    this.addNewEntry(bankCheckFlag, bankCheckEntity);
                }
            }
            if (size > 0) {
                try (TXHandle tx = TX.requiresNew();){
                    logger.info(String.format("updata {%s}------------------------------3", entityName));
                    SaveServiceHelper.save((DynamicObject[])updateDo);
                }
            } else {
                return;
            }
            logger.info(String.format("updata {%s}------------------------------4", entityName));
        } while (i <= 50000);
    }

    private void addNewEntry(String str, DynamicObjectCollection bankCheckEntity) {
        String[] flagList = str.split(",");
        if (flagList.length > 0) {
            for (String flag : flagList) {
                if (EmptyUtil.isEmpty((String)flag)) continue;
                DynamicObject entryEntity = bankCheckEntity.addNew();
                entryEntity.set("ebankcheckflag", (Object)flag);
            }
        }
    }
}

