/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.service;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.common.helper.DetailInfoExtFieldsHelper;
import kd.tmc.fbp.common.constant.RpcResult;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fbp.common.enums.MatchStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DetailInfoEntryUpdateService {
    private static final Log logger = LogFactory.getLog(DetailInfoEntryUpdateService.class);
    private static final String SELECT_BILL_COMMON_PROP = "id,bankcheckentity,bankcheckentity.ebankcheckflag,bankcheckentity.edetailid,bankcheckentity.edetailbillno,bankcheckentity.ebizdate,bankcheckentity.ecurrency,bankcheckentity.edebitamount,bankcheckentity.ecreditamount";
    private static final String SELECT_DETAIL_COMMON_PROP = "id,billno,bankcheckflag,bizdate,currency,debitamount,creditamount";
    private final QFilter baseFilter = new QFilter("matchflag", "not in", Arrays.asList(MatchStatusEnum.UNSMARTMATCH, MatchStatusEnum.NONEEDMATCH)).and("bankcheckentity.ebankcheckflag", "is not null", (Object)true);

    public String bizBillDetailInfoDataUpdate() {
        RpcResult recResult = new RpcResult();
        try {
            logger.info(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u5173\u8054\u4ea4\u6613\u660e\u7ec6\u4fe1\u606f\u5386\u53f2\u6570\u636e\u5347\u7ea7", (String)"DetailInfoEntryUpdateService_1", (String)"tmc-bei-business", (Object[])new Object[0]));
            this.updatePaymentBill();
            this.updateReceivingBill();
            this.updateAgentBill();
            logger.info(ResManager.loadKDString((String)"\u5173\u8054\u4ea4\u6613\u660e\u7ec6\u4fe1\u606f\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5", (String)"DetailInfoEntryUpdateService_2", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            recResult.setStatusCode(RpcResultStatusCode.ERROR);
            recResult.setMessage(e.getMessage());
        }
        return JSON.toJSONString((Object)recResult);
    }

    private void updateAgentBill() {
        logger.info("updateAgentPayBill------------------------------1");
        String selectProperties = SELECT_BILL_COMMON_PROP + DetailInfoExtFieldsHelper.getExtDetailInfoSelectFields((String)"cas_agentpaybill");
        this.updateBill(this.baseFilter, "cas_agentpaybill", selectProperties);
    }

    private void updateReceivingBill() {
        logger.info("updateReceivingBill------------------------------1");
        String selectProperties = SELECT_BILL_COMMON_PROP + DetailInfoExtFieldsHelper.getExtDetailInfoSelectFields((String)"cas_recbill");
        this.updateBill(this.baseFilter, "cas_recbill", selectProperties);
    }

    private void updatePaymentBill() {
        logger.info("updatePaymentBill------------------------------1");
        String selectProperties = SELECT_BILL_COMMON_PROP + DetailInfoExtFieldsHelper.getExtDetailInfoSelectFields((String)"cas_paybill");
        this.updateBill(this.baseFilter, "cas_paybill", selectProperties);
    }

    private void updateBill(QFilter qFilter, String entityName, String selectProperties) {
        logger.info(String.format("updateDetailInfo Start {%s}------------------------------1", entityName));
        Long beginId = 0L;
        int i = 0;
        while (true) {
            int size = 0;
            QFilter idFilter = new QFilter("id", ">", (Object)beginId);
            DynamicObject[] updateDo = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{idFilter, qFilter}, (String)"id", (int)999);
            if (updateDo != null && updateDo.length > 0) {
                size = updateDo.length;
                DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)(SELECT_DETAIL_COMMON_PROP + DetailInfoExtFieldsHelper.getSrcDetailInfoSelectFields((String)entityName)), (QFilter[])new QFilter[]{new QFilter("bankcheckflag", "in", Arrays.stream(updateDo).filter(o -> o.getDynamicObjectCollection("bankcheckentity") != null).flatMap(o -> o.getDynamicObjectCollection("bankcheckentity").stream().map(b -> b.getString("ebankcheckflag"))).collect(Collectors.toSet()))});
                for (DynamicObject entity : updateDo) {
                    beginId = entity.getLong("id");
                    DynamicObjectCollection bankCheckEntity = entity.getDynamicObjectCollection("bankcheckentity");
                    if (bankCheckEntity == null || bankCheckEntity.isEmpty()) continue;
                    for (DynamicObject entryRow : bankCheckEntity) {
                        List objectList;
                        String bankCheckFlag = entryRow.getString("ebankcheckflag");
                        if (!EmptyUtil.isNoEmpty((String)bankCheckFlag) || (objectList = details.stream().filter(d -> bankCheckFlag.equals(d.getString("bankcheckflag"))).collect(Collectors.toList())).isEmpty()) continue;
                        DynamicObject detail = (DynamicObject)objectList.get(0);
                        DetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)detail, (DynamicObject)entryRow, (Map)DetailInfoExtFieldsHelper.getDetailInfoFields((String)entityName));
                    }
                }
            }
            if (size <= 0) break;
            DynamicObject[] dynamicObjectArray = null;
            try (TXHandle tx = TX.requiresNew();){
                logger.info(String.format("updateDetailInfo SaveBatch {%s}------------------------------2", entityName));
                SaveServiceHelper.save((DynamicObject[])updateDo);
            }
            catch (Throwable object) {
                dynamicObjectArray = object;
                throw object;
            }
            i += size;
        }
        logger.info(String.format("updateDetailInfo End {%s} TotalSize {%d}------------------------------3", entityName, i));
    }
}

