/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.service.factory.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.WorkBenchHelper;
import kd.tmc.bei.business.service.factory.IWorkBenchService;
import kd.tmc.bei.common.helper.OperateServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class WorkBenchServiceImpl
implements IWorkBenchService {
    private static final Log LOGGER = LogFactory.getLog(WorkBenchServiceImpl.class);

    public static WorkBenchServiceImpl getInstance() {
        return Singleton.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Object[] selectedPks, String entity, OperationResult result, OperateOption option, String target, String way) {
        boolean errorFlag;
        block23: {
            errorFlag = false;
            ArrayList<String> businessIds = new ArrayList<String>(selectedPks.length);
            if (selectedPks == null || selectedPks.length == 0) {
                return false;
            }
            for (Object selectedPk : selectedPks) {
                businessIds.add(String.valueOf(selectedPk));
            }
            List lockBusinessIds = TxCheckUtil.getLocked(businessIds);
            if (businessIds.size() == lockBusinessIds.size()) {
                LOGGER.info("\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d-pkIds:{}", (Object)lockBusinessIds.toString());
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchServiceImpl_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
            Map request = MutexServiceHelper.batchRequest(businessIds, (String)entity, (String)"batchWork_bench");
            ArrayList errors = new ArrayList();
            List requestIds = MutexServiceHelper.getRequestResultList(businessIds, errors, (Map)request);
            ArrayList<Object> list = new ArrayList<Object>(8);
            ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(8);
            try {
                for (Object selectedPk : selectedPks) {
                    if (!lockBusinessIds.contains(selectedPk.toString()) && requestIds.contains(selectedPk.toString())) {
                        list.add(selectedPk);
                        continue;
                    }
                    LOGGER.info("\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d-pkIds:{}", (Object)selectedPk.toString());
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setPkValue((Object)selectedPk.toString());
                    operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u8be5\u6279\u6b21\u4ea4\u6613\u660e\u7ec6\u5df2\u7ecf\u5728\u5339\u914d\u5165\u8d26\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AutoMatchServiceImpl_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                    operateErrorInfoList.add(operateErrorInfo);
                }
                if (operateErrorInfoList.size() != 0) {
                    result.setAllErrorInfo(operateErrorInfoList);
                }
                if (list.size() <= 0) break block23;
                LOGGER.info("[WorkBenchServiceImpl]\u5165\u8d26id\u5217\u8868\uff1a{}", list);
                Map<String, DynamicObject[]> businessBills = WorkBenchHelper.getTargetBillByWay(list.toArray(), entity, way, target, false, result);
                String operateFrom = option.getVariableValue("operateFrom", "");
                if (StringUtils.equals((CharSequence)operateFrom, (CharSequence)"recruleenterschedule") || StringUtils.equals((CharSequence)operateFrom, (CharSequence)"payruleenterschedule")) {
                    ArrayList<Long> successIdList = new ArrayList<Long>(10);
                    for (Map.Entry<String, DynamicObject[]> entry : businessBills.entrySet()) {
                        OperationResult operationResult;
                        if (EmptyUtil.isEmpty((Object[])entry.getValue())) continue;
                        Map idAndObjectMap = Arrays.stream((Object[])entry.getValue()).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
                        if (StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)"cas_recbill") || StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)"cas_paybill")) {
                            operationResult = OperateServiceHelper.execOperateWithoutThrow((String)"save", (String)entry.getKey(), (DynamicObject[])entry.getValue(), (OperateOption)option);
                            LOGGER.info("WorkBenchServiceImpl execute operationResult0 : {}", (Object)operationResult.toString());
                            List successPkIds = operationResult.getSuccessPkIds();
                            if (EmptyUtil.isNoEmpty((Object)successPkIds)) {
                                for (Object pkId : successPkIds) {
                                    DynamicObject dynamicObject = (DynamicObject)idAndObjectMap.get(pkId);
                                    if (EmptyUtil.isEmpty((DynamicObject)dynamicObject) || !EmptyUtil.isNoEmpty((Long)dynamicObject.getLong("sourcebillid"))) continue;
                                    successIdList.add(dynamicObject.getLong("sourcebillid"));
                                }
                            }
                            if (operationResult.isSuccess()) continue;
                            List errorInfoList = operationResult.getAllErrorOrValidateInfo();
                            int size = errorInfoList.size() + operationResult.getSuccessPkIds().size();
                            if (size == 0 && EmptyUtil.isEmpty((Collection)errorInfoList)) {
                                throw new KDBizException(operationResult.getMessage());
                            }
                            for (IOperateInfo errorInfo : errorInfoList) {
                                Object pkValue = errorInfo.getPkValue();
                                DynamicObject dynamicObject = (DynamicObject)idAndObjectMap.get(pkValue);
                                if (EmptyUtil.isEmpty((DynamicObject)dynamicObject) || !EmptyUtil.isNoEmpty((Long)dynamicObject.getLong("sourcebillid"))) continue;
                                long sourceBillId = dynamicObject.getLong("sourcebillid");
                                OperateErrorInfo info = new OperateErrorInfo();
                                info.setPkValue((Object)sourceBillId);
                                info.setMessage(pkValue + ":" + info.getMessage());
                                result.getAllErrorInfo().add(info);
                            }
                            continue;
                        }
                        operationResult = OperateServiceHelper.execOperate((String)"save", (String)entry.getKey(), (DynamicObject[])entry.getValue(), (OperateOption)option);
                        LOGGER.info("WorkBenchServiceImpl execute operationResult1 : {}", (Object)operationResult.toString());
                        if (!operationResult.isSuccess()) continue;
                        successIdList.addAll(operationResult.getSuccessPkIds());
                    }
                    result.setSuccessPkIds(successIdList);
                    break block23;
                }
                ArrayList succIdList = new ArrayList(10);
                for (Map.Entry<String, DynamicObject[]> entry : businessBills.entrySet()) {
                    if (EmptyUtil.isEmpty((Object[])entry.getValue())) continue;
                    OperationResult operationResult = OperateServiceHelper.execOperateWithoutThrow((String)"save", (String)entry.getKey(), (DynamicObject[])entry.getValue(), (OperateOption)option);
                    LOGGER.info("WorkBenchServiceImpl execute operationResult2 : {}", (Object)operationResult.toString());
                    succIdList.addAll(operationResult.getSuccessPkIds());
                    if (operationResult.getAllErrorOrValidateInfo().size() <= 0) continue;
                    for (IOperateInfo errorInfo : operationResult.getAllErrorOrValidateInfo()) {
                        OperateErrorInfo returnErrorInfo = this.getOperateErrorInfo(errorInfo.getPkValue(), errorInfo.getMessage());
                        List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                        if (EmptyUtil.isNoEmpty((Object)allErrorOrValidateInfo)) {
                            boolean isExist = allErrorOrValidateInfo.stream().anyMatch(o -> o != null && o.getMessage() != null && o.getMessage().equalsIgnoreCase(returnErrorInfo.getMessage()));
                            if (isExist) continue;
                            result.addErrorInfo(returnErrorInfo);
                            continue;
                        }
                        result.addErrorInfo(returnErrorInfo);
                    }
                }
                result.setSuccessPkIds(succIdList);
            }
            catch (Exception ex) {
                LOGGER.error((Throwable)ex);
                OperateErrorInfo errorInfo = this.getOperateErrorInfo(null, ex.getMessage());
                result.addErrorInfo(errorInfo);
            }
            finally {
                if (requestIds.size() > 0) {
                    MutexServiceHelper.batchRelease((List)requestIds, (String)entity, (String)"batchWork_bench");
                }
            }
        }
        if (!result.isSuccess()) {
            errorFlag = true;
        }
        return errorFlag;
    }

    private OperateErrorInfo getOperateErrorInfo(Object pk, String meg) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setPkValue(pk);
        operateErrorInfo.setMessage(meg);
        return operateErrorInfo;
    }

    static final class Singleton {
        private static WorkBenchServiceImpl instance = new WorkBenchServiceImpl();

        Singleton() {
        }
    }
}

