/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.StringUtils;

public abstract class BeiAccountTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BeiAccountTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(RequestContext arg0, Map<String, Object> paramMap) throws KDException {
        logger.info("\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u7c7b");
        QFilter filter = this.getAccountQFilter();
        String schedule_cycle = null;
        Object beforeday = null;
        Object beforeMonth = null;
        String downloadDay = "";
        Object downloadFromBank = false;
        if (paramMap != null && !paramMap.isEmpty()) {
            String dDay;
            Object day;
            Object bankaccountnumber = paramMap.get("bankaccountnumber");
            logger.info("\u53c2\u6570 bankaccountnumber" + bankaccountnumber);
            if (EmptyUtil.isNoEmpty((Object)bankaccountnumber)) {
                String[] number = bankaccountnumber.toString().split(",");
                filter.and(new QFilter("bankaccountnumber", "in", (Object)number));
            }
            if (EmptyUtil.isNoEmpty((Object)(day = paramMap.get("day")))) {
                beforeday = day;
            }
            schedule_cycle = paramMap.get("schedule_cycle") == null ? null : paramMap.get("schedule_cycle").toString();
            logger.info("\u53c2\u6570 schedule_cycle" + schedule_cycle);
            Object month = paramMap.get("month");
            if (EmptyUtil.isNoEmpty((Object)month)) {
                beforeMonth = month;
            }
            String string = dDay = paramMap.get("download_day") == null ? "" : paramMap.get("download_day").toString();
            if (kd.bos.util.StringUtils.isNotEmpty((String)dDay)) {
                downloadDay = dDay;
            }
            if (paramMap.get("downloadFromBank") != null) {
                downloadFromBank = paramMap.get("downloadFromBank");
            }
        }
        if (this.isTaskByAccount()) {
            DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"am_acctbank_schedule", (String)"id", (QFilter[])new QFilter[]{filter.and(this.getQfilter())});
            if (accountBanks.length == 0) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("schedule_cycle", schedule_cycle);
            if (beforeday != null) {
                operateOption.setVariableValue("day", beforeday.toString());
            }
            if ("downelecstatement".equals(this.getOperationKey())) {
                operateOption.setVariableValue("month", beforeMonth != null ? beforeMonth.toString() : "1");
            } else if ("downhistorydetail".equals(this.getOperationKey())) {
                operateOption.setVariableValue("downloadFromBank", downloadFromBank.toString());
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)downloadDay)) {
                operateOption.setVariableValue("download_day", downloadDay);
            }
            operateOption.setVariableValue("scheduling_plan_flag", null);
            logger.info("\u94f6\u884c\u8d26\u6237\u8c03\u5ea6\u53c2\u65701" + schedule_cycle);
            logger.info("\u94f6\u884c\u8d26\u6237\u8c03\u5ea6\u53c2\u65702" + this.getOperationKey());
            logger.info("\u94f6\u884c\u8d26\u6237\u8c03\u5ea6\u53c2\u65703" + Arrays.asList(StringUtils.getPks((DynamicObject[])accountBanks)));
            logger.info("\u94f6\u884c\u8d26\u6237\u8c03\u5ea6\u53c2\u6570downloadDay:{}", (Object)downloadDay);
            OperationResult result = null;
            try {
                result = TmcOperateServiceHelper.execOperate((String)this.getOperationKey(), (String)"am_acctbank_schedule", (Object[])StringUtils.getPks((DynamicObject[])accountBanks), (OperateOption)operateOption);
                this.buildLog(result);
                return;
            }
            catch (Exception e) {
                String s = ResManager.loadKDString((String)"\u6682\u65e0\u672a\u5339\u914d\u7535\u5b50\u56de\u5355\u3002", (String)"BeiAccountTask_0", (String)"tmc-bei-business", (Object[])new Object[0]);
                logger.error("\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u7c7b\u7684\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
                if (s.equals(e.getMessage().trim())) return;
                throw e;
            }
        }
        OperationResult accountbanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{filter});
        if (((DynamicObject[])accountbanks).length == 0) {
            return;
        }
        ArrayList<Object> accountPks = new ArrayList<Object>(((DynamicObject[])accountbanks).length);
        for (DynamicObject accountbank : accountbanks) {
            accountPks.add(accountbank.getPkValue());
        }
        DynamicObject[] data = BusinessDataServiceHelper.load((String)this.getEntityNumber(), (String)"id", (QFilter[])new QFilter[]{new QFilter(this.getAccountKey(), "in", accountPks).and(this.getQfilter())});
        if (data.length == 0) {
            return;
        }
        logger.info("\u540c\u6b65\u72b6\u6001\u53c2\u65701" + data.length);
        logger.info("\u540c\u6b65\u72b6\u6001\u53c2\u65702" + this.getOperationKey());
        logger.info("\u540c\u6b65\u72b6\u6001\u53c2\u65703" + this.getEntityNumber());
        ArrayList errors = new ArrayList();
        List idList = Arrays.stream(data).map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequest(idList, (String)this.getEntityNumber(), (String)(this.getOperationKey() + "_mutex"));
        List requestIds = MutexServiceHelper.getRequestResultList((DynamicObject[])data, errors, (Map)request);
        try {
            OperationResult result;
            if (requestIds.size() > 0) {
                Object[] longIds = requestIds.stream().map(Long::valueOf).toArray();
                result = TmcOperateServiceHelper.execOperate((String)this.getOperationKey(), (String)this.getEntityNumber(), (Object[])longIds, (OperateOption)OperateOption.create());
            } else {
                result = new OperationResult();
            }
            for (OperateErrorInfo error : errors) {
                result.addErrorInfo(error);
            }
            this.buildLog(result);
            return;
        }
        finally {
            if (requestIds.size() > 0) {
                MutexServiceHelper.batchRelease((List)requestIds, (String)this.getEntityNumber(), (String)(this.getOperationKey() + "_mutex"));
            }
        }
    }

    public String getAccountKey() {
        return "accountbank";
    }

    protected abstract boolean isTaskByAccount();

    private void buildLog(OperationResult result) {
        logger.info("\u64cd\u4f5c\u540d\u79f0" + this.getOperationKey());
        logger.info("\u6210\u529f\u6761\u6570" + result.getSuccessPkIds().size());
        logger.info("\u6821\u9a8c\u4fe1\u606f" + result.getValidateResult().getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getSponsor());
    }

    protected QFilter getAccountQFilter() {
        return new QFilter("acctstatus", "=", (Object)"normal");
    }

    protected abstract QFilter getQfilter();

    protected abstract String getOperationKey();

    protected abstract String getEntityNumber();
}

