/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class QueryElecBalanceAccTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> paramMap) throws KDException {
        DynamicObject[] accountBanks;
        QFilter filter = new QFilter("acctstatus", "=", (Object)"normal");
        filter.and("issetbankinterface", "=", (Object)"1");
        int monthCycle = 1;
        if (paramMap != null && !paramMap.isEmpty()) {
            String cycle;
            Object bankaccountnumber = paramMap.get("bankaccountnumber");
            if (EmptyUtil.isNoEmpty((Object)bankaccountnumber)) {
                String[] number = bankaccountnumber.toString().split(",");
                filter.and(new QFilter("bankaccountnumber", "in", (Object)number));
            }
            if (EmptyUtil.isNotBlank((CharSequence)(cycle = (String)paramMap.get("monthcycle")))) {
                monthCycle = Integer.parseInt(cycle);
            }
        }
        if ((accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bank,bankaccountnumber,currency", (QFilter[])new QFilter[]{filter})).length == 0) {
            return;
        }
        DynamicObject param = TmcDataServiceHelper.newDynamicObject((String)"bei_queryelecbalance_acc");
        DynamicObjectCollection accountBank = param.getDynamicObjectCollection("accountbank");
        for (DynamicObject obj : accountBanks) {
            DynamicObject newBankAccount = new DynamicObject(accountBank.getDynamicObjectType());
            newBankAccount.set("fbasedataId", (Object)obj);
            accountBank.add((Object)newBankAccount);
        }
        param.set("accountbank", (Object)accountBank);
        param.set("startmonth", (Object)DateUtils.getFirstDateOfAnyMonth((Date)new Date(), (int)(-monthCycle)));
        param.set("endmonth", (Object)DateUtils.getFirstDateOfAnyMonth((Date)new Date(), (int)-1));
        TmcOperateServiceHelper.execOperate((String)"queryelecbalance", (String)"bei_queryelecbalance_acc", (DynamicObject[])new DynamicObject[]{param}, (OperateOption)OperateOption.create());
    }
}

