/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task.balance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.helper.QueryRequestRecordHelper;
import kd.tmc.bei.business.opservice.param.BalanceQueryParam;
import kd.tmc.bei.business.opservice.queryinfo.BalanceQueryInfo;
import kd.tmc.bei.common.enums.ExecuteWayEnum;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.bei.common.enums.QueryTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class SyncBalanceByMQTask {
    private static final Log logger = LogFactory.getLog(SyncBalanceByMQTask.class);
    private long taskId;

    public void execute(Map<String, Object> params) {
        this.taskId = DB.genLongId((String)"t_bei_querytask");
        logger.info("\u5f53\u524d\u4efb\u52a1id\uff1a" + this.taskId);
        QueryRequestRecordHelper.saveQueryTaskInfo(this.taskId, QueryTypeEnum.BALANCE.getValue(), ExecuteWayEnum.SCHEDULE.getValue());
        List accountid = (List)params.get("accountid");
        Date beginDate = (Date)params.get("startdate");
        Date endDate = (Date)params.get("enddate");
        Map accountBanks = BusinessDataServiceHelper.loadFromCache((Object[])accountid.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks"));
        int size = accountBanks.size();
        HashMap<Long, DynamicObject> accountBankMap = new HashMap<Long, DynamicObject>(size);
        HashMap<Long, String> bankId_Number = new HashMap<Long, String>(size);
        HashMap<Map<String, Object>, Set<Long>> bankInterface_AcctIds = new HashMap<Map<String, Object>, Set<Long>>();
        for (Map.Entry entry : accountBanks.entrySet()) {
            DynamicObject accountBank = (DynamicObject)entry.getValue();
            Long accountBankId = accountBank.getLong("id");
            String accountBankNumber = accountBank.getString("bankaccountnumber");
            String bankinterface = accountBank.getString("bankinterface");
            accountBankMap.put(accountBankId, accountBank);
            bankId_Number.put(accountBankId, accountBankNumber);
            DynamicObjectCollection currencys = new DynamicObjectCollection();
            for (DynamicObject currency : accountBank.getDynamicObjectCollection("currency")) {
                currencys.add((Object)currency.getDynamicObject("fbasedataid"));
            }
            for (DynamicObject currency : currencys) {
                HashMap<String, Object> mapForCurrAndBankInterFace = new HashMap<String, Object>();
                mapForCurrAndBankInterFace.put("currency", currency);
                mapForCurrAndBankInterFace.put("bankinterface", bankinterface);
                if (CollectionUtils.isEmpty((Collection)((Collection)bankInterface_AcctIds.get(mapForCurrAndBankInterFace)))) {
                    HashSet<Long> bankAccIds = new HashSet<Long>();
                    bankAccIds.add(accountBankId);
                    bankInterface_AcctIds.put(mapForCurrAndBankInterFace, bankAccIds);
                    continue;
                }
                Set bankIdSet = (Set)bankInterface_AcctIds.get(mapForCurrAndBankInterFace);
                bankIdSet.add(accountBankId);
            }
        }
        int batchDownAcctCount = 1;
        DynamicObjectCollection servConfInits = QueryServiceHelper.query((String)"bei_serviceconfig", (String)"id,batchdownstrategy,batchdownaccountsnum", null);
        if (servConfInits.size() > 0 && 0 == (batchDownAcctCount = ((DynamicObject)servConfInits.get(0)).getInt("batchdownaccountsnum"))) {
            batchDownAcctCount = 1;
        }
        Set allAccountIds = accountBankMap.keySet();
        QFilter qFilter = new QFilter("accountbank.fbasedataid.id", "in", allAccountIds).and("task.querytype", "=", (Object)QueryTypeEnum.BALANCE.getValue()).and("status", "in", Arrays.asList(QueryRequestStatusEnum.NOSTART.getValue(), QueryRequestStatusEnum.QUERYING.getValue()));
        DynamicObject[] oldRequests = TmcDataServiceHelper.load((String)"bei_queryrequest", (String)"id,accountbank,currency,status,createtime,exception,modifytime,begindate", (QFilter[])qFilter.toArray());
        if (endDate.compareTo(DateUtils.getCurrentDate()) >= 0) {
            logger.info("is start to get curr data ");
            this.getBalanceData(accountBankMap, bankInterface_AcctIds, bankId_Number, endDate, endDate, batchDownAcctCount, oldRequests);
            logger.info("start to get history data after get curr ");
            Date endBeforeDay = DateUtils.getLastDay((Date)endDate, (int)1);
            if (endBeforeDay.compareTo(beginDate) >= 0) {
                this.getBalanceData(accountBankMap, bankInterface_AcctIds, bankId_Number, beginDate, endBeforeDay, batchDownAcctCount, oldRequests);
            }
            logger.info("end to get history data after get curr ");
        } else {
            logger.info("start to get history data");
            this.getBalanceData(accountBankMap, bankInterface_AcctIds, bankId_Number, beginDate, endDate, batchDownAcctCount, oldRequests);
            logger.info("end to get history data ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBalanceData(Map<Long, DynamicObject> accountBankMap, Map<Map<String, Object>, Set<Long>> bankInterface_AcctIds, Map<Long, String> bankId_Number, Date beginDate, Date endDate, Integer batchDownAcctCount, DynamicObject[] oldRequests) {
        logger.info("bankInterfaceAccounMap is that:" + SerializationUtils.toJsonString(bankInterface_AcctIds));
        ArrayList<DynamicObject> newQueryRequestRecords = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> oldQueryRequestRecords = new ArrayList<DynamicObject>(10);
        HashMap<Long, BalanceQueryInfo> needPublish = new HashMap<Long, BalanceQueryInfo>(16);
        for (Map.Entry<Map<String, Object>, Set<Long>> group : bankInterface_AcctIds.entrySet()) {
            Set<Long> set = group.getValue();
            Map<String, Object> keyMap = group.getKey();
            ArrayList<Long> bankAccts = new ArrayList<Long>(set);
            int bankSize = set.size();
            for (int i = 0; i < bankSize; i += batchDownAcctCount.intValue()) {
                List subList = i + batchDownAcctCount >= bankSize ? bankAccts.subList(i, bankSize) : bankAccts.subList(i, i + batchDownAcctCount);
                DynamicObject currency = (DynamicObject)keyMap.get("currency");
                ArrayList<String> bankNumList = new ArrayList<String>(10);
                ArrayList<String> swCodeList = new ArrayList<String>(10);
                ArrayList<DynamicObject> accountList = new ArrayList<DynamicObject>(10);
                for (Long bankId : subList) {
                    bankNumList.add(bankId_Number.get(bankId));
                    DynamicObject account = accountBankMap.get(bankId);
                    accountList.add(account);
                    DynamicObject bank = account.getDynamicObject("bank");
                    String swCode = "";
                    if (bank != null) {
                        swCode = bank.getString("swift_code");
                    }
                    swCodeList.add(swCode);
                }
                boolean isThisDate = beginDate.compareTo(DateUtils.getDataFormat((Date)new Date(), (boolean)true)) == 0;
                List<DynamicObject> containsOldRequests = Arrays.stream(oldRequests).filter(r -> {
                    DynamicObjectCollection accountbanks = r.getDynamicObjectCollection("accountbank");
                    List collect = accountbanks.stream().map(b -> b.getLong("fbasedataId.id")).collect(Collectors.toList());
                    DynamicObject rc = r.getDynamicObject("currency");
                    if (isThisDate) {
                        return currency.getPkValue().equals(rc.getPkValue()) && collect.containsAll(subList) && beginDate.compareTo(r.getDate("begindate")) == 0;
                    }
                    return currency.getPkValue().equals(rc.getPkValue()) && collect.containsAll(subList);
                }).collect(Collectors.toList());
                DynamicObject queryRequestRecord = QueryRequestRecordHelper.buildQueryRequestRecord(accountList, currency, beginDate, endDate, this.taskId);
                oldQueryRequestRecords.addAll(QueryRequestRecordHelper.checkOldQueryRequestRecord(queryRequestRecord, containsOldRequests));
                newQueryRequestRecords.add(queryRequestRecord);
                if (!QueryRequestStatusEnum.NOSTART.getValue().equals(queryRequestRecord.getString("status"))) continue;
                String bankInterface = keyMap.get("bankinterface").toString();
                long requestId = queryRequestRecord.getLong("requestid");
                BalanceQueryParam balanceQueryParam = new BalanceQueryParam(null, beginDate, endDate, null);
                BalanceQueryInfo balanceQueryInfo = new BalanceQueryInfo(balanceQueryParam);
                balanceQueryInfo.setBankAccts(bankNumList);
                balanceQueryInfo.setSwiftCode(swCodeList);
                DynamicObject accountBankDy = accountBankMap.get(subList.get(0));
                balanceQueryInfo.setBankAcct(accountBankDy);
                balanceQueryInfo.setCurrency(currency);
                balanceQueryInfo.setBankVersion(bankInterface);
                balanceQueryInfo.setOrgId(accountBankDy.getDynamicObject("openorg").getLong("id"));
                balanceQueryInfo.setRequestId(requestId);
                needPublish.put(requestId, balanceQueryInfo);
            }
        }
        TXHandle handle = TX.requiresNew();
        Object object = null;
        try {
            SaveServiceHelper.save((DynamicObject[])newQueryRequestRecords.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])oldQueryRequestRecords.toArray(new DynamicObject[0]));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (handle != null) {
                if (object != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    handle.close();
                }
            }
        }
        MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "kd.tmc.bei.balance");
        for (Map.Entry entry : needPublish.entrySet()) {
            Long requestId = (Long)entry.getKey();
            BalanceQueryInfo balanceQueryInfo = (BalanceQueryInfo)entry.getValue();
            try {
                logger.info("------QueryBalance MQ Message " + requestId + " Send------");
                pub.publish((Object)balanceQueryInfo);
            }
            catch (Exception e) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                logger.info("------QueryBalance MQ Message " + requestId + " Send Err------");
            }
            finally {
                pub.close();
            }
        }
    }
}

