/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task.transdetail;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.bei.business.bean.AccountPredictDateResult;
import kd.tmc.bei.business.ebservice.EBDetailQueryService;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.helper.QueryRequestRecordHelper;
import kd.tmc.bei.business.opservice.param.DetailQueryParam;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.bei.common.enums.ExecuteWayEnum;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.bei.common.enums.QueryTypeEnum;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fbp.webapi.ebentity.biz.detail.Detail;

public class QueryTransDetailTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(QueryTransDetailTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        logger.info("\u5f53\u524d\u4efb\u52a1id" + this.taskId);
        QueryRequestRecordHelper.saveQueryTaskInfo(Long.parseLong(this.taskId), QueryTypeEnum.TRANSDETAIL.getValue(), ExecuteWayEnum.HAND.getValue());
        List accountid = (List)params.get("accountid");
        Date beginDate = DateUtils.stringToDate((String)((String)params.get("startdate")), (String)"yyyy-MM-dd");
        Date endDate = DateUtils.stringToDate((String)((String)params.get("enddate")), (String)"yyyy-MM-dd");
        context = (RequestContext)JSONObject.parseObject((String)((String)params.get("RequestContext")), RequestContext.class);
        Map accountBanks = BusinessDataServiceHelper.loadFromCache((Object[])accountid.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks"));
        List<AccountPredictDateResult> results = AccountBankHelper.computerByAcctBanks(BankFuncEnum.QUERY.getValue(), accountBanks.values(), beginDate, endDate);
        int size = accountBanks.size();
        int progress = 0;
        for (AccountPredictDateResult accountResult : results) {
            block20: {
                DynamicObject accountBank = accountResult.getAccountBank();
                if (!accountResult.isChange() && (accountResult.isPermit() || accountResult.isChange())) break block20;
                Date startDate = accountResult.isChange() ? accountResult.getPredictDate() : beginDate;
                for (DynamicObject currency : accountBank.getDynamicObjectCollection("currency")) {
                    String errorMsg;
                    DynamicObject queryRequestRecord;
                    block18: {
                        queryRequestRecord = QueryRequestRecordHelper.buildQueryRequestRecord(Collections.singletonList(accountBank), (DynamicObject)currency.get("fbasedataid"), startDate, endDate, Long.parseLong(this.taskId));
                        if (!QueryRequestStatusEnum.NOSTART.getValue().equals(queryRequestRecord.getString("status"))) continue;
                        DetailQueryInfo detailQueryInfo = new DetailQueryInfo();
                        detailQueryInfo.setBankAcct(accountBank);
                        detailQueryInfo.setBeginDate(startDate);
                        detailQueryInfo.setEndDate(endDate);
                        detailQueryInfo.setCurr((DynamicObject)currency.get("fbasedataid"));
                        detailQueryInfo.setAsyncTask(false);
                        detailQueryInfo.setDownloadFromBank(true);
                        detailQueryInfo.setSchedule(false);
                        detailQueryInfo.setRequestId(queryRequestRecord.getLong("requestid"));
                        errorMsg = "";
                        try {
                            ArrayList<String> detailIds = new ArrayList<String>(10);
                            ArrayList<String> uniqueSeqIds = new ArrayList(10);
                            int totalCount = 0;
                            int resultProgress = 0;
                            while (detailQueryInfo.isSuccess() && !detailQueryInfo.isLastPage()) {
                                TransDetailResult transDetailResult = EBServiceFacadeFactory.getBankService().downTransDetails(detailQueryInfo, queryRequestRecord);
                                if (detailQueryInfo.isDownloadFromBank() && transDetailResult != null && transDetailResult.isTimeOut()) {
                                    detailQueryInfo.setDownloadFromBank(false);
                                    detailQueryInfo.setPageNum(detailQueryInfo.getPageNum() - 1);
                                    transDetailResult = EBServiceFacadeFactory.getBankService().downTransDetails(detailQueryInfo, queryRequestRecord);
                                    detailQueryInfo.setDownloadFromBank(true);
                                }
                                if (transDetailResult != null) {
                                    errorMsg = transDetailResult.getErrMsg();
                                    totalCount = transDetailResult.getTotalCount();
                                    resultProgress = transDetailResult.getProgress();
                                }
                                if (resultProgress == 0) {
                                    logger.info("\u5f53\u524d\u5e01\u522b\u672a\u5728\u4e0b\u8f7d\uff0c\u76f4\u63a5\u8df3\u51fa\u3002");
                                    break;
                                }
                                if (transDetailResult == null || CollectionUtils.isEmpty(transDetailResult.getDetailIds())) break;
                                detailIds.addAll(transDetailResult.getDetailIds());
                                uniqueSeqIds = transDetailResult.getDetails().stream().filter(e -> EmptyUtil.isNoEmpty((String)e.getUniqueSeq())).map(Detail::getUniqueSeq).collect(Collectors.toList());
                            }
                            logger.info("\u5faa\u73af\u7ed3\u675f\uff1adetailQueryInfo.isSuccess() = {}, detailQueryInfo.isLastPage() = {}", (Object)detailQueryInfo.isSuccess(), (Object)detailQueryInfo.isLastPage());
                            if (!CollectionUtils.isEmpty(detailIds)) {
                                HashSet<String> checkRepeat = new HashSet<String>(detailIds.size());
                                checkRepeat.addAll(detailIds);
                                if (totalCount != checkRepeat.size()) {
                                    logger.info(" transDetail[detailIds] from ebg is repeated ");
                                    throw new KDBizException("transDetail[detailIds] from ebg is repeated");
                                }
                                DetailQueryParam detailQueryParam = new DetailQueryParam();
                                detailQueryParam.setBeginDate(startDate);
                                detailQueryParam.setEndDate(endDate);
                                new EBDetailQueryService(detailQueryParam).deleteNoExistDetail(detailQueryInfo.getBankAcct(), detailQueryInfo.getCurr(), detailIds, uniqueSeqIds);
                                break block18;
                            }
                            logger.info("detailIds is empty");
                        }
                        catch (Exception e2) {
                            block19: {
                                try {
                                    logger.error("queryTransDetail Exception:", (Throwable)e2);
                                    errorMsg = e2.getMessage();
                                    if (!(e2 instanceof KDBizException)) break block19;
                                    throw e2;
                                }
                                catch (Throwable throwable) {
                                    if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                                        queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                                        queryRequestRecord.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                                        queryRequestRecord.set("exception_tag", (Object)errorMsg);
                                    } else {
                                        queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                                    }
                                    throw throwable;
                                }
                            }
                            if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                                queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                                queryRequestRecord.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                                queryRequestRecord.set("exception_tag", (Object)errorMsg);
                            } else {
                                queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                            }
                        }
                    }
                    if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                        queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                        queryRequestRecord.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                        queryRequestRecord.set("exception_tag", (Object)errorMsg);
                    } else {
                        queryRequestRecord.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{queryRequestRecord});
                }
            }
            this.feedbackProgress(++progress * 100 / size);
        }
    }
}

