/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.task.transdetail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.bei.business.bean.AccountPredictDateResult;
import kd.tmc.bei.business.helper.AccountBankHelper;
import kd.tmc.bei.business.helper.QueryRequestRecordHelper;
import kd.tmc.bei.common.enums.ExecuteWayEnum;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.bei.common.enums.QueryTypeEnum;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SyncTransDetailByMQTask {
    private static final Log logger = LogFactory.getLog(SyncTransDetailByMQTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, Object> params) {
        long taskId = DB.genLongId((String)"t_bei_querytask");
        logger.info("\u5f53\u524d\u4efb\u52a1id\uff1a" + taskId);
        QueryRequestRecordHelper.saveQueryTaskInfo(taskId, QueryTypeEnum.TRANSDETAIL.getValue(), ExecuteWayEnum.SCHEDULE.getValue());
        List accountid = (List)params.get("accountid");
        Date beginDate = (Date)params.get("startdate");
        Date endDate = (Date)params.get("enddate");
        Map accountBanks = BusinessDataServiceHelper.loadFromCache((Object[])accountid.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_accountbanks"));
        List<AccountPredictDateResult> results = AccountBankHelper.computerByAcctBanks(BankFuncEnum.QUERY.getValue(), accountBanks.values(), beginDate, endDate);
        QFilter qFilter = new QFilter("accountbank.fbasedataid.id", "in", (Object)accountid).and("task.querytype", "=", (Object)QueryTypeEnum.TRANSDETAIL.getValue()).and("status", "in", Arrays.asList(QueryRequestStatusEnum.NOSTART.getValue(), QueryRequestStatusEnum.QUERYING.getValue()));
        DynamicObject[] oldRequests = TmcDataServiceHelper.load((String)"bei_queryrequest", (String)"id,accountbank,status,createtime,exception,modifytime,currency", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> newQueryRequestRecords = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> oldQueryRequestRecords = new ArrayList<DynamicObject>(10);
        for (AccountPredictDateResult accountResult : results) {
            DynamicObject accountBank = accountResult.getAccountBank();
            if (!accountResult.isChange() && (accountResult.isPermit() || accountResult.isChange())) continue;
            Date startDate = accountResult.isChange() ? accountResult.getPredictDate() : beginDate;
            for (DynamicObject currency : accountBank.getDynamicObjectCollection("currency")) {
                DynamicObject queryRequestRecord = QueryRequestRecordHelper.buildQueryRequestRecord(Collections.singletonList(accountBank), (DynamicObject)currency.get("fbasedataid"), startDate, endDate, taskId);
                List<DynamicObject> containsOldRequests = Arrays.stream(oldRequests).filter(r -> accountBank.getPkValue().equals(((DynamicObject)r.getDynamicObjectCollection("accountbank").get(0)).get("fbasedataid.id")) && ((DynamicObject)currency.get("fbasedataid")).getPkValue().equals(r.getDynamicObject("currency").getPkValue())).collect(Collectors.toList());
                oldQueryRequestRecords.addAll(QueryRequestRecordHelper.checkOldQueryRequestRecord(queryRequestRecord, containsOldRequests));
                newQueryRequestRecords.add(queryRequestRecord);
            }
        }
        TXHandle handle = TX.requiresNew();
        Object object = null;
        try {
            SaveServiceHelper.save((DynamicObject[])newQueryRequestRecords.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])oldQueryRequestRecords.toArray(new DynamicObject[0]));
        }
        catch (Throwable accountBank) {
            object = accountBank;
            throw accountBank;
        }
        finally {
            if (handle != null) {
                if (object != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable accountBank) {
                        ((Throwable)object).addSuppressed(accountBank);
                    }
                } else {
                    handle.close();
                }
            }
        }
        MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "kd.tmc.bei.detail");
        for (DynamicObject queryRequestRecord : newQueryRequestRecords) {
            List accountList;
            if (!QueryRequestStatusEnum.NOSTART.getValue().equals(queryRequestRecord.getString("status")) || (accountList = queryRequestRecord.getDynamicObjectCollection("accountbank").stream().map(a -> a.getDynamicObject("fbasedataid")).collect(Collectors.toList())).size() != 1 || !EmptyUtil.isNoEmpty((DynamicObject)((DynamicObject)accountList.get(0)))) continue;
            HashMap<String, Object> MQParams = new HashMap<String, Object>(8);
            MQParams.put("accountbank", accountList.get(0));
            MQParams.put("currency", queryRequestRecord.getDynamicObject("currency"));
            MQParams.put("begindate", queryRequestRecord.getDate("begindate"));
            MQParams.put("enddate", queryRequestRecord.getDate("enddate"));
            MQParams.put("downloadFromBank", params.get("downloadFromBank"));
            long requestId = queryRequestRecord.getLong("requestid");
            MQParams.put("requestid", requestId);
            try {
                logger.info("------QueryTransDetail MQ Message " + requestId + " Send------");
                pub.publish(MQParams);
            }
            catch (Exception e) {
                logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                logger.info("------QueryTransDetail MQ Message " + requestId + " Send Err------");
            }
            finally {
                pub.close();
            }
        }
    }
}

