/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.bankagent;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BankAgentErrorCode;

public class BankAgentCommitBEIValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("status");
        selectors.add("billstatus");
        selectors.add("paystate");
        selectors.add("entrys");
        selectors.add("recamount");
        selectors.add("actamount");
        selectors.add("amount");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ErrorCode BILLSTATUS_CANNOT_SUBMIT = new BankAgentErrorCode().BILLSTATUS_CANNOT_SUBMIT();
        ErrorCode STATUS_CANNOT_SUBMIT = new BankAgentErrorCode().STATUS_CANNOT_SUBMIT();
        ErrorCode BITBACKED_CANNOT_SUBMIT = new BankAgentErrorCode().BITBACKED_CANNOT_SUBMIT();
        ErrorCode STATUS_CANNOT_COMMIT = new BankAgentErrorCode().STATUS_CANNOT_COMMIT();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            String billStauts = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStauts)) {
                this.addErrorMessage(data, BILLSTATUS_CANNOT_SUBMIT.getMessage());
            }
            String bankPayState = info.getString("paystate");
            if (!BeBillStatusEnum.OP.getValue().equals(bankPayState)) {
                this.addErrorMessage(data, STATUS_CANNOT_SUBMIT.getMessage());
            } else if (info.getBoolean("isbitback")) {
                this.addErrorMessage(data, BITBACKED_CANNOT_SUBMIT.getMessage());
            }
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                String status = entry.getString("status");
                if (BeBillStatusEnum.OP.getValue().equals(status)) continue;
                this.addErrorMessage(data, STATUS_CANNOT_COMMIT.getMessage());
                break;
            }
            BigDecimal e_amount = BigDecimal.ZERO;
            e_amount = info.getDynamicObjectCollection("entrys").stream().map(v -> v.getBigDecimal("recamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (e_amount.compareTo(info.getBigDecimal("amount")) == 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u4e0d\u7b49\u4e8e\u5206\u5f55\u91d1\u989d\u4e4b\u548c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BankAgentCommitBEIValidator_o", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
    }
}

