/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.bankagent;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BankAgentErrorCode;

public class BankAgentRepayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List lst = super.getSelector();
        lst.add("paystate");
        lst.add("isupdatingstatus");
        lst.add("billstatus");
        lst.add("createtime");
        lst.add("company");
        lst.add("billstatus");
        lst.add("billno");
        lst.add("company");
        lst.add("bizdate");
        lst.add("isbitback");
        lst.add("accountbank");
        lst.add("currency");
        lst.add("actpayamount");
        lst.add("actcount");
        lst.add("actamount");
        lst.add("paystate");
        lst.add("sourcebillid");
        lst.add("serialnumber");
        lst.add("bankcheckflag");
        lst.add("submittime");
        lst.add("entrys");
        lst.add("status");
        lst.add("recamount");
        lst.add("sourceentryid");
        lst.add("bankreturnmsg");
        lst.add("bankcheckflag");
        lst.add("isrefund");
        lst.add("incomeradds");
        lst.add("incomeswiftcode");
        lst.add("incomebankcode");
        lst.add("istranspay");
        lst.add("usecn");
        lst.add("excontract");
        lst.add("payerfeeaccno");
        lst.add("paymentmethod");
        lst.add("servicelevel");
        lst.add("transremarks");
        lst.add("proxyaccno");
        lst.add("proxyaccname");
        lst.add("proxybankcountry");
        lst.add("proxybankarea");
        lst.add("proxyswiftcode");
        lst.add("proxybankname");
        lst.add("proxybankadds");
        lst.add("deliverymethod");
        lst.add("chequetype");
        lst.add("chequeusage");
        lst.add("payerfeetype");
        lst.add("payerfeecurrency");
        lst.add("tolexchangerate");
        lst.add("isagencypersonpay");
        lst.add("amount");
        lst.add("payamt");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ErrorCode BANKPAYSTATE_CANNOT_REPAY = new BankAgentErrorCode().BANKPAYSTATE_CANNOT_REPAY();
        ErrorCode BANKPAYSTATE_ISUPDATINGSTATUS_REPAY = new BankAgentErrorCode().BANKPAYSTATE_ISUPDATINGSTATUS_REPAY();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            String billstatus = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billstatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd\u8fdb\u884c\u5931\u8d25\u91cd\u4ed8\u3002", (String)"BankAgentRepayValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]), BillStatusEnum.getName((String)billstatus)));
            }
            String payStatus = info.getString("paystate");
            Object[] validStatusArr = new Object[]{BeBillStatusEnum.TF.getValue(), BeBillStatusEnum.PS.getValue()};
            if (!Arrays.asList(validStatusArr).contains(payStatus)) {
                throw new KDBizException(BANKPAYSTATE_CANNOT_REPAY, new Object[0]);
            }
            boolean isUpdatingStatus = PayStateUpdateHelper.isUpdatingStatus((DynamicObject)info, (String)info.getDataEntityType().getName());
            if (isUpdatingStatus) {
                throw new KDBizException(BANKPAYSTATE_ISUPDATINGSTATUS_REPAY, new Object[0]);
            }
            this.checkRepayPeriodInfo(info);
        }
    }

    private void checkRepayPeriodInfo(DynamicObject info) {
        Date createTime = info.getDate("createtime");
        DynamicObject company = info.getDynamicObject("company");
        DynamicObject casInitInfo = BusinessDataServiceHelper.loadSingle((String)"cas_cashmgtinit", (String)"periodtype", (QFilter[])new QFilter[]{new QFilter("org", "=", company.getPkValue())});
        Object periodType = casInitInfo.getDynamicObject("periodtype").getPkValue();
        DynamicObject createTimePeriod = this.getPeriodByDate(periodType, createTime);
        DynamicObject currPeriod = this.getPeriodByDate(periodType, new Date());
        if (currPeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728, \u8bf7\u5148\u914d\u7f6e\u4f1a\u8ba1\u671f\u95f4\u4fe1\u606f\u3002", (String)"BankAgentRepayValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]), new Object[0]));
        }
        if (!createTimePeriod.getPkValue().equals(currPeriod.getPkValue())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u4e0d\u652f\u6301\u8de8\u671f\u64cd\u4f5c,\u53ef\u6253\u56de\u5230\u51fa\u7eb3\u4ee3\u53d1\u5355\u67e5\u8be2\u754c\u9762\u64cd\u4f5c\u5931\u8d25\u91cd\u4ed8\u3002", (String)"BankAgentRepayValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    private DynamicObject getPeriodByDate(Object periodTypeId, Date date) {
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", periodTypeId)});
    }
}

