/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.banktrans;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BankTransErrorCode;

public class BankTransRepayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List lst = super.getSelector();
        lst.add("paystate");
        lst.add("isupdatingstatus");
        lst.add("billstatus");
        lst.add("billstatus");
        lst.add("billno");
        lst.add("company");
        lst.add("bizdate");
        lst.add("isbitback");
        lst.add("accountbank");
        lst.add("currency");
        lst.add("actcount");
        lst.add("actamount");
        lst.add("paystate");
        lst.add("sourcebillid");
        lst.add("serialnumber");
        lst.add("bankcheckflag");
        lst.add("submittime");
        lst.add("entrys");
        lst.add("status");
        lst.add("transamt");
        lst.add("subacct");
        lst.add("sourceentryid");
        lst.add("bankreturnmsg");
        lst.add("bankcheckflag");
        lst.add("amount");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ErrorCode BANKPAYSTATE_CANNOT_REPAY = new BankTransErrorCode().BANKPAYSTATE_CANNOT_REPAY();
        ErrorCode BANKPAYSTATE_ISUPDATINGSTATUS_REPAY = new BankTransErrorCode().BANKPAYSTATE_ISUPDATINGSTATUS_REPAY();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject info = data.getDataEntity();
            String billstatus = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billstatus)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd\u8fdb\u884c\u5931\u8d25\u91cd\u4ed8\u3002", (String)"BankTransRepayValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]), BillStatusEnum.getName((String)billstatus)));
            }
            String payStatus = info.getString("paystate");
            Object[] validStatusArr = new Object[]{BeBillStatusEnum.TF.getValue(), BeBillStatusEnum.PS.getValue()};
            if (!Arrays.asList(validStatusArr).contains(payStatus)) {
                throw new KDBizException(BANKPAYSTATE_CANNOT_REPAY, new Object[0]);
            }
            boolean isUpdatingStatus = PayStateUpdateHelper.isUpdatingStatus((DynamicObject)info, (String)info.getDataEntityType().getName());
            if (!isUpdatingStatus) continue;
            throw new KDBizException(BANKPAYSTATE_ISUPDATINGSTATUS_REPAY, new Object[0]);
        }
    }
}

