/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.banktrans;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailClaimValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        String tipsClaimRecAmount = new BeiBizResource().getTipsClaimRecAmount();
        String tipsClaimCategory = new BeiBizResource().getTipsClaimCategory();
        String tipsClaimRecAmountSum = new BeiBizResource().getTipsClaimRecAmountSum();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject claimDO = dataEntity.getDataEntity();
            BigDecimal creditamount = claimDO.getBigDecimal("creditamount");
            DynamicObjectCollection claimEntryDC = claimDO.getDynamicObjectCollection("detailinfo_entry");
            BigDecimal recamountSum = BigDecimal.ZERO;
            for (DynamicObject claimEntryDO : claimEntryDC) {
                BigDecimal recamount = claimEntryDO.getBigDecimal("recamount");
                Object category = claimEntryDO.get("category");
                if (recamount.compareTo(BigDecimal.ZERO) == 0 && EmptyUtil.isEmpty((Object)category)) continue;
                if (recamount.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(dataEntity, String.format(tipsClaimRecAmount, claimEntryDO.getInt("seq")));
                }
                if (EmptyUtil.isEmpty((Object)category)) {
                    this.addErrorMessage(dataEntity, String.format(tipsClaimCategory, claimEntryDO.getInt("seq")));
                }
                recamountSum = recamountSum.add(recamount);
            }
            if (claimEntryDC.size() <= 0 || creditamount.compareTo(recamountSum) == 0) continue;
            this.addErrorMessage(dataEntity, tipsClaimRecAmountSum);
        }
    }
}

