/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.banktrans;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UpdateStateBeforeSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcetype");
        selector.add("sourcebillid");
        selector.add("statusnew");
        selector.add("entrys");
        selector.add("paystatus");
        selector.add("reason");
        selector.add("sourceentryid");
        selector.add("e_sourcebillid");
        selector.add("e_sourcebillno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject noUpdatedRec2;
            DynamicObject info = data.getDataEntity();
            DynamicObjectCollection currEntries = info.getDynamicObjectCollection("entrys");
            String sourceType = (String)info.get("sourcetype");
            Object[] sourceIds = currEntries.stream().map(s -> s.getLong("e_sourcebillid")).toArray();
            DynamicObject[] targetBills = TmcDataServiceHelper.load((Object[])sourceIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceType));
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ignoreValidation", "true");
            TmcOperateServiceHelper.execOperate((String)"updatestatpush", (String)targetBills[0].getDataEntityType().getName(), (DynamicObject[])targetBills, (OperateOption)operateOption, (boolean)true);
            List updatedRecList = currEntries.stream().filter(o -> !Objects.equals(o.get("statusnew"), o.get("paystatus"))).collect(Collectors.toList());
            if (updatedRecList.size() == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u72b6\u6001\u53d8\u5316, \u8bf7\u4fee\u6539\u540e\u5728\u63d0\u4ea4\u3002", (String)"UpdateStateSubmitValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
            if ("bei_bankpaybill".equals(sourceType)) {
                List noUpdatedRecList = currEntries.stream().filter(o -> Objects.equals(o.get("statusnew"), o.get("paystatus"))).collect(Collectors.toList());
                for (DynamicObject noUpdatedRec2 : noUpdatedRecList) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"%s\uff1a\u672a\u68c0\u6d4b\u5230\u72b6\u6001\u53d8\u5316, \u8bf7\u4fee\u6539\u540e\u5728\u63d0\u4ea4\u3002", (String)"UpdateStateSubmitValidator_2", (String)"tmc-bei-business", (Object[])new Object[]{noUpdatedRec2.getString("e_sourcebillno")}));
                }
            }
            boolean has2TFRec = updatedRecList.stream().anyMatch(o -> Objects.equals(o.get("statusnew"), BeBillStatusEnum.TF.getValue()));
            List reasonEmptyList = updatedRecList.stream().filter(o -> EmptyUtil.isEmpty((String)o.getString("reason"))).collect(Collectors.toList());
            noUpdatedRec2 = reasonEmptyList.iterator();
            while (noUpdatedRec2.hasNext()) {
                DynamicObject reasonEmpty = (DynamicObject)noUpdatedRec2.next();
                this.addErrorMessage(data, ResManager.loadKDString((String)"%s\uff1a\u8bf7\u586b\u5199\u201c\u539f\u56e0\u201d\u5b57\u6bb5\u3002", (String)"UpdateStateSubmitValidator_1", (String)"tmc-bei-business", (Object[])new Object[]{reasonEmpty.getString("e_sourcebillno")}));
            }
            if (!has2TFRec) continue;
            Long compId = (Long)info.getDynamicObject("company").getPkValue();
            String timeCtrlPara = (String)TmcParameterHelper.getAppParameter((String)TmcAppEnum.BEI.getId(), (Long)compId, (String)"bei003");
            if (StringUtils.equals((CharSequence)timeCtrlPara, (CharSequence)"nocontrol")) continue;
            for (DynamicObject targetBill : targetBills) {
                Date submitTime = targetBill.getDate("submittime");
                Date now = new Date();
                int timeCtrl = 0;
                int minCtrl = 0;
                if (StringUtils.equals((CharSequence)timeCtrlPara, (CharSequence)"0")) {
                    timeCtrl = 12;
                } else if (StringUtils.equals((CharSequence)timeCtrlPara, (CharSequence)"1")) {
                    timeCtrl = 4;
                } else if (StringUtils.equals((CharSequence)timeCtrlPara, (CharSequence)"2")) {
                    timeCtrl = 1;
                } else if (StringUtils.equals((CharSequence)timeCtrlPara, (CharSequence)"custom")) {
                    minCtrl = TmcParameterHelper.getAppIntParameter((String)TmcAppEnum.BEI.getId(), (long)compId, (String)"bei009");
                }
                if (timeCtrl == 0 && minCtrl == 0) {
                    timeCtrl = 12;
                }
                if (timeCtrl != 0 && DateUtils.getDiffHours((Date)submitTime, (Date)now) < timeCtrl) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u72b6\u6001\u53d8\u66f4\u4e3a\u5931\u8d25\u7684\u65f6\u95f4\u95f4\u9694\u4e3a%d\u5c0f\u65f6\uff0c\u672c\u5355\u636e%s\u7b49\u5f85\u65f6\u95f4\u672a\u5230\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UpdateStateSubmitValidator_3", (String)"tmc-bei-business", (Object[])new Object[0]), timeCtrl, targetBill.getString("billno")));
                }
                if (minCtrl == 0 || DateUtils.getDiffMinute((Date)submitTime, (Date)now) >= minCtrl) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u72b6\u6001\u53d8\u66f4\u4e3a\u5931\u8d25\u7684\u65f6\u95f4\u95f4\u9694\u4e3a%d\u5206\u949f\uff0c\u672c\u5355\u636e%s\u7b49\u5f85\u65f6\u95f4\u672a\u5230\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UpdateStateSubmitValidator_4", (String)"tmc-bei-business", (Object[])new Object[0]), minCtrl, targetBill.getString("billno")));
            }
        }
    }
}

