/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.bei.common.enums.ReceredTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankFuncEnum;
import kd.tmc.fbp.common.helper.BeiParameterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DetailImportSaveValdator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("receredtype");
        selector.add("claimnoticebillno");
        selector.add("isdowntobankstate");
        selector.add("bankcheckflag");
        selector.add("detailid");
        selector.add("billno");
        selector.add("creditamount");
        selector.add("debitamount");
        selector.add("company");
        selector.add("bizdate");
        selector.add("biztime");
        selector.add("isdownbankjournal");
        selector.add("ismatchereceipt");
        selector.add("accountbank");
        selector.add("currency");
        selector.add("oppbanknumber");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendDetailDatas) throws KDBizException {
        Map variables = this.getOption().getVariables();
        String checkInterFace = "";
        String settleAccountsInterFace = "";
        if (variables.containsKey("checkInterFace")) {
            checkInterFace = (String)variables.get("checkInterFace");
        }
        if (variables.containsKey("settleAccountsInterFace")) {
            settleAccountsInterFace = (String)variables.get("settleAccountsInterFace");
        }
        QFilter settCenterSetting = new QFilter("settlecenter", "is not null", null);
        DynamicObjectCollection setCenterSettings = QueryServiceHelper.query((String)"ifm_settcentersetting", (String)"settlecenter.id as settlecenter", (QFilter[])new QFilter[]{settCenterSetting});
        Set settlecenter = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)setCenterSettings)) {
            settlecenter = setCenterSettings.stream().map(s -> s.getLong("settlecenter")).collect(Collectors.toSet());
        }
        List detailIds = Arrays.stream(extendDetailDatas).map(ExtendedDataEntity::getDataEntity).map(b -> b.get("detailid")).filter(Objects::nonNull).filter(c -> !c.toString().trim().isEmpty()).collect(Collectors.toList());
        DynamicObjectCollection prefDatas = QueryServiceHelper.query((String)"bei_betransdetail_imp", (String)"id,detailid", (QFilter[])new QFilter[]{new QFilter("detailid", "in", detailIds)});
        Map<Object, List<DynamicObject>> prefDatasMapping = prefDatas.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.get("detailid")));
        HashMap accCheckResult = new HashMap(16);
        for (ExtendedDataEntity extendDetailData : extendDetailDatas) {
            DynamicObject periodData;
            QFilter peFilter;
            DynamicObjectCollection bdPeriods;
            Optional<DynamicObject> per;
            DynamicObject periodType;
            QFilter queryFilter;
            Object[] casInit;
            DynamicObject company;
            boolean isPermitClose;
            List checkResult;
            DynamicObject dataEntity = extendDetailData.getDataEntity();
            boolean formDatabase = dataEntity.getDataEntityState().getFromDatabase();
            if (formDatabase) {
                this.updateDataValidate(extendDetailData, prefDatasMapping);
            } else {
                this.newDataValidate(extendDetailData, prefDatasMapping);
            }
            BigDecimal creditAmt = Optional.ofNullable(dataEntity.getBigDecimal("creditamount")).orElse(BigDecimal.ZERO);
            BigDecimal debitAmt = Optional.ofNullable(dataEntity.getBigDecimal("debitamount")).orElse(BigDecimal.ZERO);
            if (creditAmt.compareTo(BigDecimal.ZERO) == 0 && debitAmt.compareTo(BigDecimal.ZERO) == 0 || creditAmt.compareTo(BigDecimal.ZERO) != 0 && debitAmt.compareTo(BigDecimal.ZERO) != 0) {
                this.addErrorMessage(extendDetailData, ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u4e2d\u7684\u6536\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5408\u6cd5\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"TransDetailImportNewOp_1", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
            DynamicObject accountBank = dataEntity.getDynamicObject("accountbank");
            Date bizdate = DateUtils.getDataFormat((Date)dataEntity.getDate("bizdate"), (boolean)true);
            if (!EmptyUtil.isNoEmpty((DynamicObject)accountBank)) continue;
            QFilter qFilter = new QFilter("id", "=", accountBank.getPkValue());
            accountBank = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,name,bankaccountnumber,isvirtual,issetbankinterface,currency,bank,company", (QFilter[])qFilter.toArray());
            String bankNumber = accountBank.getString("bankaccountnumber");
            DynamicObject currency = dataEntity.getDynamicObject("currency");
            DynamicObjectCollection accountCurrency = accountBank.getDynamicObjectCollection("currency");
            List diffCur = accountCurrency.stream().filter(s -> s.get("fbasedataid.number").equals(currency.getString("number"))).collect(Collectors.toList());
            if (diffCur.size() == 0) {
                this.addErrorMessage(extendDetailData, ResManager.loadKDString((String)"\u586b\u5199\u7684\u5e01\u79cd\u5728\u5bf9\u5e94\u94f6\u884c\u8d26\u6237\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u5e01\u79cd\u518d\u5bfc\u5165\u3002", (String)"TransDetailImportNewOp_4", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
            if ((checkResult = (List)accCheckResult.getOrDefault(bankNumber + ";" + DateUtils.formatString((Date)bizdate, (String)"yyyy-MM-dd"), null)) != null && !checkResult.isEmpty()) {
                for (String result : checkResult) {
                    this.addErrorMessage(extendDetailData, result);
                }
            } else {
                boolean issetBankInterface;
                ArrayList<String> checkList = new ArrayList<String>(10);
                boolean isvirtual = accountBank.getBoolean("isvirtual");
                if (isvirtual) {
                    String message = ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u3010%s\u3011\u7684\u94f6\u884c\u7c7b\u522b\u662f\u865a\u62df\u94f6\u884c\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"TransDetailImportNewOp_2", (String)"tmc-bei-business", (Object[])new Object[]{bankNumber});
                    this.addErrorMessage(extendDetailData, message);
                    checkList.add(message);
                }
                if ((EmptyUtil.isEmpty((String)checkInterFace) || "true".equals(checkInterFace)) && (issetBankInterface = accountBank.getBoolean("issetbankinterface"))) {
                    DynamicObject company2 = accountBank.getDynamicObject("company");
                    boolean isPredictOpenDate = BeiParameterHelper.getAppBoolParameter((long)Long.parseLong(company2.getPkValue().toString()), (String)"bei008");
                    if (isPredictOpenDate) {
                        String message;
                        QFilter queryFilter2 = new QFilter("id", "=", (Object)accountBank.getLong("id")).and("entry.e_enable", "=", (Object)"1").and("entry.e_bankfunction", "=", (Object)BankFuncEnum.QUERY.getValue());
                        DynamicObjectCollection banks = QueryServiceHelper.query((String)"am_accountbank", (String)"id,bankaccountnumber,entry,entry.e_predictopendate", (QFilter[])new QFilter[]{queryFilter2});
                        if (!EmptyUtil.isEmpty((DynamicObjectCollection)banks)) {
                            if (((DynamicObject)banks.get(0)).getDate("entry.e_predictopendate") != null) {
                                Date predictOpendate = DateUtils.getDataFormat((Date)((DynamicObject)banks.get(0)).getDate("entry.e_predictopendate"), (boolean)true);
                                if (bizdate.compareTo(predictOpendate) >= 0) {
                                    String message2 = ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c%s\u201d\u5df2\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\u4e14\u4ea4\u6613\u65e5\u671f\u5927\u4e8e\u7b49\u4e8e\u8be5\u8d26\u6237\u94f6\u4f01\u63a5\u53e3\u67e5\u8be2\u529f\u80fd\u7684\u9884\u8ba1\u5f00\u901a\u65f6\u95f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"TransDetailImportNewOp_3", (String)"tmc-bei-business", (Object[])new Object[]{bankNumber});
                                    this.addErrorMessage(extendDetailData, message2);
                                    checkList.add(message2);
                                }
                            } else {
                                message = this.getOpenInterFaceMsg(bankNumber);
                                this.addErrorMessage(extendDetailData, message);
                                checkList.add(message);
                            }
                        } else {
                            queryFilter2 = new QFilter("id", "=", (Object)accountBank.getLong("id")).and("entry.e_enable", "=", (Object)"1").and("entry.e_bankfunction", "!=", (Object)BankFuncEnum.QUERY.getValue());
                            banks = QueryServiceHelper.query((String)"am_accountbank", (String)"id,bankaccountnumber", (QFilter[])new QFilter[]{queryFilter2});
                            if (banks == null || banks.isEmpty()) {
                                message = this.getOpenInterFaceMsg(bankNumber);
                                this.addErrorMessage(extendDetailData, message);
                                checkList.add(message);
                            }
                        }
                    } else {
                        String message = this.getOpenInterFaceMsg(bankNumber);
                        this.addErrorMessage(extendDetailData, message);
                        checkList.add(message);
                    }
                }
                Long bankid = accountBank.getDynamicObject("bank").getLong("id");
                if (settlecenter != null && settlecenter.contains(bankid)) {
                    Date bankDate;
                    QFilter qFilterIfm = new QFilter("isinit", "=", (Object)"1");
                    qFilterIfm.and("inneraccount.number", "=", (Object)bankNumber);
                    DynamicObjectCollection innerAccountInit = QueryServiceHelper.query((String)"ifm_inneraccountinit", (String)"amountdate", (QFilter[])new QFilter[]{qFilterIfm});
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)innerAccountInit) && bizdate.compareTo(bankDate = DateUtils.getDataFormat((Date)((DynamicObject)innerAccountInit.get(0)).getDate("amountdate"), (boolean)true)) >= 0) {
                        String message = ResManager.loadKDString((String)"\u5bfc\u5165\u4ea4\u6613\u660e\u7ec6\u7684\u94f6\u884c\u8d26\u6237\u662f\u521d\u59cb\u5316\u7684\u7ed3\u7b97\u4e2d\u5fc3\u5185\u90e8\u8d26\u6237\uff0c\u6b64\u4ea4\u6613\u660e\u7ec6\u7684\u4ea4\u6613\u65e5\u671f\u9700\u5c0f\u4e8e\u8be5\u5185\u90e8\u8d26\u6237\u5bf9\u5e94\u7684\u4f59\u989d\u65e5\u671f\u3002", (String)"TransDetailImportNewOp_6", (String)"tmc-bei-business", (Object[])new Object[0]);
                        this.addErrorMessage(extendDetailData, message);
                        checkList.add(message);
                    }
                }
                accCheckResult.put(bankNumber + ";" + DateUtils.formatString((Date)bizdate, (String)"yyyy-MM-dd"), checkList);
            }
            if (!EmptyUtil.isEmpty((String)settleAccountsInterFace) && !"true".equals(settleAccountsInterFace) || (isPermitClose = BeiParameterHelper.getAppBoolParameter((long)Long.parseLong((company = accountBank.getDynamicObject("company")).getPkValue().toString()), (String)"bei015")) || !EmptyUtil.isNoEmpty((Object[])(casInit = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,periodtype", (QFilter[])new QFilter[]{queryFilter = new QFilter("org", "=", company.getPkValue())}))) || (periodType = casInit[0].getDynamicObject("periodtype")) == null) continue;
            Date detailBizDate = dataEntity.getDate("bizdate");
            QFilter typeFilter = new QFilter("group", "=", (Object)periodType.getLong("id"));
            DynamicObject[] periods = BusinessDataServiceHelper.load((String)"bd_periodoutline_tree", (String)"id,outlinebegindate,outlineenddate", (QFilter[])new QFilter[]{typeFilter});
            List period = Arrays.stream(periods).filter(e -> detailBizDate.getTime() - e.getDate("outlinebegindate").getTime() >= 0L && detailBizDate.getTime() - e.getDate("outlineenddate").getTime() <= 0L).collect(Collectors.toList());
            if (period.size() <= 0 || !(per = (bdPeriods = QueryServiceHelper.query((String)"bd_period", (String)"id,name,begindate,enddate", (QFilter[])new QFilter[]{peFilter = new QFilter("periodoutline", "=", (Object)(periodData = (DynamicObject)period.get(0)).getLong("id"))})).stream().filter(e -> detailBizDate.getTime() - e.getDate("begindate").getTime() >= 0L && detailBizDate.getTime() - e.getDate("enddate").getTime() <= 0L).findFirst()).isPresent()) continue;
            DynamicObject perData = per.get();
            QFilter filter = new QFilter("org", "=", company.getPkValue());
            filter.and(new QFilter("period", "=", (Object)perData.getLong("id")));
            DynamicObjectCollection finalCheckOuts = QueryServiceHelper.query((String)"cas_finalcheckout", (String)"id,checkoutstatus", (QFilter[])new QFilter[]{filter});
            if (finalCheckOuts.size() <= 0 || !"3".equals(((DynamicObject)finalCheckOuts.get(0)).getString("checkoutstatus"))) continue;
            String message = String.format(ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u660e\u7ec6\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u3010%s\u3011\u5df2\u7ed3\u8d26\uff0c\u8bf7\u5148\u8fdb\u884c\u53cd\u7ed3\u8d26\u518d\u5bfc\u5165\u8be5\u7b14\u4ea4\u6613\u660e\u7ec6\u3002", (String)"TransDetailImportNewOp_18", (String)"tmc-bei-business", (Object[])new Object[0]), perData.getString("name"));
            this.addErrorMessage(extendDetailData, message);
        }
        this.checkSortNos(extendDetailDatas);
    }

    private void checkSortNos(ExtendedDataEntity[] extendDetailDatas) {
        List details = Arrays.stream(extendDetailDatas).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map<String, List<DynamicObject>> groupMap = details.stream().collect(Collectors.groupingBy(v -> (v.getDynamicObject("accountbank") == null ? "accountbank" : v.getDynamicObject("accountbank").getString("bankaccountnumber")) + "---" + (v.getDynamicObject("currency") == null ? "currency" : v.getDynamicObject("currency").getString("number"))));
        HashMap<String, Boolean> checkFlagMap = new HashMap<String, Boolean>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> dataList = entry.getValue();
            List sortNoList = dataList.stream().map(b -> b.getInt("sortno")).filter(c -> c != 0).collect(Collectors.toList());
            boolean checkFlag = sortNoList.size() > 0 && sortNoList.size() < dataList.size();
            checkFlagMap.put(entry.getKey(), checkFlag);
        }
        for (ExtendedDataEntity extendedDataEntity : extendDetailDatas) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject accountBank = dataEntity.getDynamicObject("accountbank");
            String acctBankPropVal = accountBank == null ? "accountbank" : accountBank.getString("bankaccountnumber");
            DynamicObject currency = dataEntity.getDynamicObject("currency");
            String currencyPropVal = currency == null ? "currency" : currency.getString("number");
            String key = acctBankPropVal + "---" + currencyPropVal;
            if (!((Boolean)checkFlagMap.get(key)).booleanValue()) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u8d26\u6237\u201c%1$s\u201d\uff08%2$s\uff09\u672c\u6b21\u5bfc\u5165\u6570\u636e\u4e2d\u53ea\u6709\u90e8\u5206\u586b\u5199\u4e86\u6392\u5e8f\u53f7\uff0c\u8bf7\u5168\u90e8\u586b\u5199\u6392\u5e8f\u53f7\u540e\u518d\u5bfc\u5165\uff1b\u4e5f\u53ef\u4ee5\u5168\u90e8\u6e05\u7a7a\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u6839\u636e\u6570\u636e\u5bfc\u5165\u65f6\u95f4\u8fdb\u884c\u6392\u5e8f\u3002", (String)"DetailImportSaveValdator_1", (String)"tmc-bei-business", (Object[])new Object[0]), acctBankPropVal, currencyPropVal);
            this.addErrorMessage(extendedDataEntity, errMsg);
        }
    }

    private void updateDataValidate(ExtendedDataEntity extendDetailData, Map<Object, List<DynamicObject>> prefDatasMapping) {
        boolean isSameBillno;
        String detailId;
        boolean isMatchEreceipt;
        boolean isDownBankJournal;
        boolean isDownloadToBankState;
        String claimNotice;
        DynamicObject detailData = extendDetailData.getDataEntity();
        String receredType = detailData.getString("receredtype");
        if (ReceredTypeEnum.RECERED.getValue().equals(receredType)) {
            this.addErrorMessage(extendDetailData, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u5df2\u5165\u8d26\u3002", (String)"TransDetailImportNewOp_8", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)(claimNotice = detailData.getString("claimnoticebillno")))) {
            this.addErrorMessage(extendDetailData, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u5df2\u5b58\u5728\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\u3002", (String)"TransDetailImportNewOp_9", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        if (isDownloadToBankState = detailData.getBoolean("isdowntobankstate")) {
            this.addErrorMessage(extendDetailData, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u5df2\u4e0b\u63a8\u5bf9\u8d26\u5355\u3002", (String)"TransDetailImportNewOp_10", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        if (isDownBankJournal = detailData.getBoolean("isdownbankjournal")) {
            this.addErrorMessage(extendDetailData, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4ea4\u6613\u660e\u7ec6\u5df2\u4e0b\u8f7d\u65e5\u8bb0\u8d26\u3002", (String)"TransDetailImportNewOp_13", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        if (isMatchEreceipt = detailData.getBoolean("ismatchereceipt")) {
            this.addErrorMessage(extendDetailData, ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5df2\u5339\u914d\u7535\u5b50\u56de\u5355\uff0c\u4e0d\u80fd\u88ab\u8986\u76d6\u3002", (String)"TransDetailImportNewOp_15", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
        if (prefDatasMapping.containsKey(detailId = detailData.getString("detailid")) && (isSameBillno = prefDatasMapping.get(detailId).stream().anyMatch(item -> item.getLong("id") != detailData.getLong("id")))) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7\u201c%s\u201d\u7684\u8bb0\u5f55\u3002", (String)"TransDetailImportNewOp_7", (String)"tmc-bei-business", (Object[])new Object[0]), detailId);
            this.addErrorMessage(extendDetailData, errMsg);
        }
    }

    private void newDataValidate(ExtendedDataEntity extendDetailData, Map<Object, List<DynamicObject>> prefDatasMapping) {
        boolean exists;
        DynamicObject detailData = extendDetailData.getDataEntity();
        Object detailId = detailData.get("detailid");
        if (null != detailId && !detailId.toString().trim().isEmpty() && (exists = prefDatasMapping.containsKey(detailId))) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7\u201c%s\u201d\u7684\u8bb0\u5f55\u3002", (String)"TransDetailImportNewOp_7", (String)"tmc-bei-business", (Object[])new Object[0]), detailId);
            this.addErrorMessage(extendDetailData, errMsg);
        }
    }

    private String getOpenInterFaceMsg(String bankNum) {
        return ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\uff1a%s\u5df2\u5f00\u901a\u94f6\u4f01\u63a5\u53e3\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"TransDetailImportNewOp_16", (String)"tmc-bei-business", (Object[])new Object[]{bankNum});
    }
}

