/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.detail;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.bei.util.MatchResultBean;
import kd.sdk.tmc.bei.util.RecPayRuleMatchUtil;
import kd.tmc.bei.business.helper.RecClaimHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class NoticeClaimValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("receredtype");
        selector.add("kdretflag");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Set ids = Arrays.stream(dataEntities).map(d -> String.valueOf(d.getDataEntity().getPkValue())).collect(Collectors.toSet());
        DynamicObjectCollection claimNoticeBills = QueryServiceHelper.query((String)"cas_claimcenterbill", (String)"id, sourceid", (QFilter[])new QFilter[]{new QFilter("sourceid", "in", ids)});
        Set noticeIds = claimNoticeBills.stream().map(o -> o.get("sourceid")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String msg;
            DynamicObject transDetail = dataEntity.getDataEntity();
            if (StringUtils.equals((CharSequence)"3", (CharSequence)transDetail.getString("receredtype"))) {
                msg = ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u7684\u6570\u636e\u4e0d\u80fd\u901a\u77e5\u8ba4\u9886\u3002", (String)"NoticeClaimValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            if (noticeIds.contains(String.valueOf(transDetail.getPkValue()))) {
                msg = ResManager.loadKDString((String)"\u5df2\u88ab\u901a\u77e5\u8ba4\u9886\u6570\u636e\u4e0d\u80fd\u91cd\u590d\u901a\u77e5\u8ba4\u9886\u3002", (String)"NoticeClaimValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
            }
            if (!EmptyUtil.isNoEmpty((String)transDetail.getString("kdretflag"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\uff08\u7f16\u53f7\uff1a%1$s\uff09\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u4ea4\u6613\u660e\u7ec6\u6709\u201cKD\u6807\u8bc6\u201d\u4fe1\u606f\uff0c\u4e3a\u94f6\u4f01\u4ed8\u6b3e\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u5e94\u7531\u7cfb\u7edf\u8fdb\u884c\u81ea\u52a8\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6309\u89c4\u5219\u751f\u5355\u3001\u624b\u5de5\u751f\u5355\u3001\u76f4\u63a5\u6807\u8bb0\u5df2\u786e\u8ba4\u3001\u6807\u8bb0\u4e3a\u65e0\u9700\u786e\u8ba4\u3001\u901a\u77e5\u8ba4\u9886\u7b49\u64cd\u4f5c\u3002", (String)"RecWorkbenchList_46", (String)"tmc-bei-formplugin", (Object[])new Object[]{transDetail.getString("billno")}));
        }
        Object[] billIds = Arrays.stream(dataEntities).map(e -> e.getDataEntity().getPkValue()).toArray();
        List matchResultBeanList = RecPayRuleMatchUtil.matchNoticeClaim((Object[])billIds);
        Set entryRuleIdSet = matchResultBeanList.stream().map(MatchResultBean::getEntryRuleId).collect(Collectors.toSet());
        Map<Object, MatchResultBean> matchResultBeanMap = matchResultBeanList.stream().collect(Collectors.toMap(MatchResultBean::getId, e -> e, (v1, v2) -> v2));
        DynamicObjectCollection ruleList = QueryServiceHelper.query((String)"cas_recpayrule", (String)"entryentity.id,entryentity.e_savenotifi_TAG", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", entryRuleIdSet)});
        Map<Object, DynamicObject> ruleMap = ruleList.stream().collect(Collectors.toMap(e -> e.get("entryentity.id"), e -> e, (v1, v2) -> v2));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Map noticeData;
            String notify;
            DynamicObject transDetail = dataEntity.getDataEntity();
            Object id = transDetail.getPkValue();
            MatchResultBean matchResultBean = matchResultBeanMap.get(id);
            DynamicObject ruleResult = null;
            if (matchResultBean != null) {
                ruleResult = ruleMap.get(matchResultBean.getEntryRuleId());
            }
            if (ruleResult == null || !StringUtils.isNotBlank((CharSequence)(notify = ruleResult.getString("entryentity.e_savenotifi_TAG"))) || RecClaimHelper.checkEnableUserExist(noticeData = (Map)SerializationUtils.fromJsonString((String)notify, Map.class))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9009\u5b9a\u7684\u8ba4\u9886\u7528\u6237\u7ec4\u6216\u89d2\u8272\u4e2d\u4e0d\u5b58\u5728\u53ef\u7528\u72b6\u6001\u7684\u7528\u6237\uff0c\u65e0\u6cd5\u63d0\u4ea4\u901a\u77e5\u8ba4\u9886\u3002", (String)"NoticeClaimValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
    }
}

