/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.detail;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class TransDetailManualMatchValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("claimnoticebillno");
        selector.add("receredtype");
        selector.add("billno");
        selector.add("company");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (dataEntity.length == 1) {
            DynamicObject data = dataEntity[0].getDataEntity();
            String claimNoticeBillNo = data.getString("claimnoticebillno");
            String receredType = data.getString("receredtype");
            boolean checkPass = StringUtils.isBlank((String)claimNoticeBillNo) && !Arrays.asList("1", "3", "4").contains(receredType);
            Long orgId = (Long)data.getDynamicObject("company").getPkValue();
            if (!checkPass) {
                this.addErrorMessage(dataEntity[0], ResManager.loadKDString((String)"\u6240\u9009\u4ea4\u6613\u660e\u7ec6\u65e0\u9700\u5339\u914d\u4e1a\u52a1\u5355\u636e\u6216\u8005\u5df2\u7ecf\u901a\u77e5\u8ba4\u9886\u3002", (String)"TransDetailManualMatchValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
        } else if (dataEntity.length > 1) {
            LinkedHashMap<Long, String> noMatchBillMap = new LinkedHashMap<Long, String>(dataEntity.length);
            List dataList = Arrays.stream(dataEntity).filter(d -> StringUtils.isNotEmpty((String)d.getDataEntity().getString("claimnoticebillno")) || Arrays.asList("1", "3", "4").contains(d.getDataEntity().getString("receredtype"))).collect(Collectors.toList());
            for (ExtendedDataEntity data : dataList) {
                noMatchBillMap.put(data.getDataEntity().getLong("id"), data.getDataEntity().getString("billno"));
            }
            if (!noMatchBillMap.isEmpty()) {
                this.getOption().setVariableValue("noMatchBillNo", JSON.toJSONString(noMatchBillMap));
            }
        }
    }
}

