/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.detail;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.resource.BeiBizResource;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailViewReceiptValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (dataEntity.length == 0) {
            return;
        }
        DynamicObject detailData = dataEntity[0].getDataEntity();
        Long detailID = detailData.getLong("id");
        DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,matchreceiptentry.e_receiptno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)detailID)});
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)details)) {
            String receiptno = details.stream().map(detail -> detail.getString("matchreceiptentry.e_receiptno")).collect(Collectors.joining(";"));
            if (!EmptyUtil.isEmpty((String)receiptno)) {
                DynamicObject receipts = BusinessDataServiceHelper.loadSingle((String)"bei_elecreceipt", (String)"id,bank", (QFilter[])new QFilter[]{new QFilter("receiptno", "in", Arrays.asList(receiptno.split(";")))});
                if (EmptyUtil.isEmpty((DynamicObject)receipts)) {
                    this.addMessage(dataEntity[0], new BeiBizResource().getNoreceiptError(), ErrorLevel.Error);
                }
            } else {
                this.addMessage(dataEntity[0], new BeiBizResource().getNoReceiptnoError(), ErrorLevel.Error);
            }
        } else {
            this.addMessage(dataEntity[0], new BeiBizResource().getNodetailReceiptError(), ErrorLevel.Error);
        }
    }
}

