/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.elec;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.enums.LendingDirectionEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElecReceiptImportValidator
extends AbstractTmcBizOppValidator {
    private static final String OP_NEXT = "next";

    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(10);
        list.add("status");
        list.add("accountbank");
        list.add("filename");
        list.add("amount");
        list.add("currency");
        list.add("bizdate");
        list.add("detailid");
        list.add("creditdebitflag");
        return list;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntities)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u672a\u6210\u529f\u89e3\u6790\uff1a\u65e0\u7535\u5b50\u56de\u5355\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ElecReceiptImportValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                return;
            }
            int success = 0;
            String operateKey = this.getOperateKey();
            ArrayList<Integer> successIndex = new ArrayList<Integer>(10);
            ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(10);
            for (int i = 0; i < entryEntities.size(); ++i) {
                DynamicObject entryEntity = (DynamicObject)entryEntities.get(i);
                if ("F".equals(entryEntity.getString("status"))) continue;
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                String bankAccountNumber = entryEntity.getString("accountbank");
                BigDecimal amount = entryEntity.getBigDecimal("amount");
                String currencyCode = entryEntity.getString("currency");
                Date bizDate = entryEntity.getDate("bizdate");
                String detailId = entryEntity.getString("detailid");
                String tradeType = entryEntity.getString("creditdebitflag");
                StringBuilder errorMessage = new StringBuilder();
                if (EmptyUtil.isEmpty((String)bankAccountNumber)) {
                    errorMessage.append(LendingDirectionEnum.IN.getValue().equals(tradeType) ? ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportValidator_11", (String)"tmc-bei-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportValidator_12", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)currencyCode)) {
                    errorMessage.append(ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportValidator_3", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((BigDecimal)amount)) {
                    errorMessage.append(ResManager.loadKDString((String)"\u91d1\u989d\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportValidator_4", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)tradeType)) {
                    errorMessage.append(ResManager.loadKDString((String)"\u501f\u8d37\u6807\u8bb0\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportValidator_5", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((Object)bizDate)) {
                    errorMessage.append(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ElecReceiptImportValidator_6", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((String)errorMessage.toString())) {
                    this.addErrorMessage(extendedDataEntity, this.getMessage(String.valueOf(i + 1), 4) + " " + errorMessage);
                    if (OP_NEXT.equals(operateKey)) {
                        return;
                    }
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(i + "_" + errorMessage);
                    errorInfoList.add(operateErrorInfo);
                    continue;
                }
                DynamicObject accountBank = BusinessDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,company,bank", (QFilter[])new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)bankAccountNumber)});
                if (EmptyUtil.isEmpty((DynamicObject)accountBank)) {
                    this.addErrorMessage(extendedDataEntity, this.getMessage(String.valueOf(i + 1), 4) + " " + this.getMessage(bankAccountNumber, 1));
                    if (OP_NEXT.equals(operateKey)) {
                        return;
                    }
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(i + "_" + this.getMessage(bankAccountNumber, 1));
                    errorInfoList.add(operateErrorInfo);
                    continue;
                }
                Object accountBankId = accountBank.getPkValue();
                Object[] currency = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)currencyCode).or(new QFilter("name", "=", (Object)currencyCode).and("issystem", "=", (Object)true))});
                boolean exists = false;
                QFilter filter = new QFilter("id", "!=", null);
                if (accountBankId != null) {
                    filter.and("detailid", "=", (Object)detailId);
                    filter.and("currency", "=", EmptyUtil.isNoEmpty((Object[])currency) ? currency[0].get("id") : null);
                    filter.and("accountbank", "=", accountBankId);
                    filter.and(LendingDirectionEnum.IN.getValue().equals(tradeType) ? "creditamount" : "debitamount", "=", (Object)amount);
                    filter.and("bizrefno", "=", (Object)entryEntity.getString("bizrefno"));
                    exists = QueryServiceHelper.exists((String)"bei_elecreceipt", (QFilter[])filter.toArray());
                }
                if (exists) {
                    DynamicObject receipt = QueryServiceHelper.queryOne((String)"bei_elecreceipt", (String)"id, receiptno", (QFilter[])filter.toArray());
                    String receiptNo = receipt.getString("receiptno");
                    if (OP_NEXT.equals(operateKey)) {
                        this.addWarningMessage(extendedDataEntity, this.getMessage(String.valueOf(i + 1), 4) + " " + this.getMessage(receiptNo, 2));
                    } else {
                        this.addErrorMessage(extendedDataEntity, this.getMessage(String.valueOf(i + 1), 4) + " " + this.getMessage(receiptNo, 2));
                    }
                    operateErrorInfo.setLevel(ErrorLevel.Warning);
                    operateErrorInfo.setMessage(i + "_" + this.getMessage(receiptNo, 2));
                    errorInfoList.add(operateErrorInfo);
                }
                DynamicObject company = accountBank.getDynamicObject("company");
                Long companyId = (Long)company.getPkValue();
                long userId = RequestContext.get().getCurrUserId();
                boolean hasPermission = TmcOrgDataHelper.hasPermission(null, (long)userId, (long)companyId, (String)"bei_elecreceipt", (String)"47150e89000000ac");
                if (!hasPermission) {
                    this.addErrorMessage(extendedDataEntity, this.getMessage(String.valueOf(i + 1), 4) + " " + this.getMessage(bankAccountNumber, 3));
                    if (OP_NEXT.equals(operateKey)) {
                        return;
                    }
                    operateErrorInfo.setLevel(ErrorLevel.Error);
                    operateErrorInfo.setMessage(i + "_" + this.getMessage(bankAccountNumber, 3));
                    errorInfoList.add(operateErrorInfo);
                    continue;
                }
                ++success;
                successIndex.add(i);
            }
            if (!errorInfoList.isEmpty()) {
                ThreadCache.put((Object)"errorInfo", errorInfoList);
            } else if (success == 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u672a\u6210\u529f\u89e3\u6790\uff1a\u65e0\u7535\u5b50\u56de\u5355\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ElecReceiptImportValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                return;
            }
            ThreadCache.put((Object)"successIndex", successIndex);
        }
    }

    private String getMessage(String param, int idx) {
        switch (idx) {
            case 1: {
                return ResManager.loadKDString((String)"\u8d26\u53f7\u3010%s\u3011\u5728\u94f6\u884c\u8d26\u6237\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u94f6\u884c\u8d26\u6237\u3002", (String)"ElecReceiptImportValidator_7", (String)"tmc-bei-business", (Object[])new Object[]{param});
            }
            case 2: {
                return ResManager.loadKDString((String)"\u5b58\u5728\u7591\u4f3c\u91cd\u590d\u6570\u636e\uff0c\u7535\u5b50\u56de\u5355\u53f7\u3010%s\u3011\uff0c\u8bf7\u786e\u8ba4\u56de\u5355\u6587\u4ef6\u662f\u5426\u5df2\u7ecf\u5bfc\u5165\u3002", (String)"ElecReceiptImportValidator_8", (String)"tmc-bei-business", (Object[])new Object[]{param});
            }
            case 3: {
                return ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u8be5\u56de\u5355\u6587\u4ef6\u6240\u5c5e\u94f6\u884c\u8d26\u6237\u3010%s\u3011\u7684\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u6388\u6743\u540e\u518d\u5bfc\u5165\u3002", (String)"ElecReceiptImportValidator_9", (String)"tmc-bei-business", (Object[])new Object[]{param});
            }
            case 4: {
                return ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"ElecReceiptImportValidator_10", (String)"tmc-bei-business", (Object[])new Object[]{param});
            }
        }
        return "";
    }
}

