/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.elec;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.common.enums.BalanceDirectionEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class ElecStatementSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entry) {
                BigDecimal debitAmount = row.getBigDecimal("e_debitamount");
                BigDecimal creditAmount = row.getBigDecimal("e_creditamount");
                String creditMark = row.getString("e_creditmark");
                if (Objects.equals(creditMark, BalanceDirectionEnum.DEBIT.getValue()) && debitAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7\u4e3a\u501f\u65b9\uff0c\u501f\u65b9\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ElecStatementSaveValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
                if (!Objects.equals(creditMark, BalanceDirectionEnum.CREDIT.getValue()) || creditAmount.compareTo(BigDecimal.ZERO) > 0) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7\u4e3a\u8d37\u65b9\uff0c\u8d37\u65b9\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ElecStatementSaveValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
        }
    }
}

