/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.elec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ElectReceiptCancelMatchValidate
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("billno");
        lst.add("datasource");
        lst.add("ismatch");
        lst.add("transdetailid");
        lst.add("matchdetailentry");
        lst.add("matchdetailentry.e_transdetailid");
        return lst;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            Set receiptGenDetails;
            DynamicObject electReceiptDO = extendedDataEntity.getDataEntity();
            DynamicObjectCollection matchdetailentry = electReceiptDO.getDynamicObjectCollection("matchdetailentry");
            if (matchdetailentry.size() == 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7535\u5b50\u56de\u5355\u5c1a\u672a\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u3002", (String)"ElectReceiptCancelMatchValidate_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                continue;
            }
            List e_transdetailid = matchdetailentry.stream().map(e -> e.getLong("e_transdetailid")).collect(Collectors.toList());
            QFilter tFilter = new QFilter("id", "in", (Object)e_transdetailid.toArray());
            Object[] transDetailDOs = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,datasource", (QFilter[])new QFilter[]{tFilter});
            if (ObjectUtils.isEmpty((Object[])transDetailDOs)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7535\u5b50\u56de\u5355\u6682\u65e0\u5339\u914d\u7684\u4ea4\u6613\u660e\u7ec6\uff0c\u65e0\u6cd5\u53d6\u6d88\u5339\u914d\u3002", (String)"ElectReceiptCancelMatchValidate_2", (String)"tmc-bei-business", (Object[])new Object[0]));
            }
            if (ObjectUtils.isEmpty((Object[])transDetailDOs) || EmptyUtil.isEmpty(receiptGenDetails = Arrays.stream(transDetailDOs).filter(e -> StringUtils.isNotBlank((Object)e.get("datasource")) && "receiptgen".equals(e.get("datasource"))).collect(Collectors.toSet()))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u7535\u5b50\u56de\u5355\u6240\u5339\u914d\u7684\u4ea4\u6613\u660e\u7ec6\u5b58\u5728\u6309\u7167\u56de\u5355\u6570\u636e\u751f\u6210\u7684\uff0c\u65e0\u6cd5\u53d6\u6d88\u5339\u914d\u3002", (String)"ElectReceiptCancelMatchValidate_1", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
    }
}

