/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.elec;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.common.enums.SourceBillTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReceiptQuerySchemeSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject entity = data.getDataEntity();
            DynamicObjectCollection linkEntry = entity.getDynamicObjectCollection("linkentry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)linkEntry)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u67e5\u8be2\u94fe\u8def\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\u67e5\u8be2\u94fe\u8def\u3002", (String)"ReceiptQuerySchemeSaveValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]));
            } else {
                boolean isFundBill = entity.getBoolean("istofundbill");
                DynamicObject linkCard = (DynamicObject)linkEntry.get(linkEntry.size() - 1);
                DynamicObject targetBill = linkCard.getDynamicObject("targetbillname");
                if (isFundBill) {
                    Set fundBillTypes = QueryServiceHelper.query((String)"bei_fundbilltype", (String)"id, number", (QFilter[])new QFilter[0]).stream().map(o -> o.getString("number")).collect(Collectors.toSet());
                    fundBillTypes.remove(SourceBillTypeEnum.VOUCHER.getValue());
                    if (!targetBill.getString("number").equals("bei_elecreceipt") && !fundBillTypes.contains(targetBill.getString("number"))) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u67e5\u8be2\u94fe\u8def\u7684\u76ee\u6807\u5355\u636e\u4e3a\u975e\u8d44\u91d1\u6536\u4ed8\u5355\u636e\uff0c\u8bf7\u5b8c\u5584\u67e5\u8be2\u94fe\u8def\u3002", (String)"ReceiptQuerySchemeSaveValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                    }
                } else if (!targetBill.getString("number").equals("bei_elecreceipt")) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u67e5\u8be2\u94fe\u8def\u7684\u76ee\u6807\u5355\u636e\u975e\u7535\u5b50\u56de\u5355\uff0c\u8bf7\u5b8c\u5584\u67e5\u8be2\u94fe\u8def\u3002", (String)"ReceiptQuerySchemeSaveValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]));
                }
            }
            DynamicObject query = QueryServiceHelper.queryOne((String)"bei_receiptqueryscheme", (String)"id, name, number", (QFilter[])new QFilter[]{new QFilter("sourcebill.number", "=", (Object)entity.getDynamicObject("sourcebill").getString("number"))});
            if (!EmptyUtil.isNoEmpty((DynamicObject)query) || query.getLong("id") == entity.getLong("id")) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u6e90\u5355\u7684\u56de\u5355\u67e5\u8be2\u65b9\u6848%s\uff0c\u8bf7\u524d\u5f80\u4fee\u6539\u3002", (String)"ReceiptQuerySchemeSaveValidator_3", (String)"tmc-bei-business", (Object[])new Object[0]), query.getString("number")));
        }
    }
}

