/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.forcequery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.utils.helper.SuspectRepeatHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.opservice.result.TransDetailResult;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.DetailQueryInfo;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;

public abstract class AbstractForceQueryValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(AbstractForceQueryValidator.class);

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Set orgIds = Arrays.stream(dataEntities).map(s -> s.getDataEntity().getDynamicObject("company").getLong("id")).collect(Collectors.toSet());
        HashSet<Long> needCheckOrgIds = new HashSet<Long>(orgIds.size());
        for (Long orgId : orgIds) {
            boolean isCtrl = TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.BEI.getId(), (long)orgId, (String)"bei016");
            if (!isCtrl) continue;
            needCheckOrgIds.add(orgId);
        }
        List needCheckDataEntities = Arrays.stream(dataEntities).filter(s -> needCheckOrgIds.contains(s.getDataEntity().getDynamicObject("company").getLong("id"))).collect(Collectors.toList());
        if (needCheckDataEntities.size() > 0) {
            List idList;
            logger.info("\u5f3a\u5236\u67e5\u8be2\u5f00\u59cb\uff1a" + this.getOperateKey());
            String entityName = ((ExtendedDataEntity)needCheckDataEntities.get(0)).getDataEntity().getDataEntityType().getName();
            if ("bei_bankpaybill".equals(entityName)) {
                idList = needCheckDataEntities.stream().map(ExtendedDataEntity::getDataEntity).filter(o -> !o.getBoolean("isupdatestate") && BillStatusEnum.AUDIT.getValue().equals(o.getString("billstatus"))).map(o -> (Long)o.getPkValue()).collect(Collectors.toList());
            } else {
                idList = needCheckDataEntities.stream().map(ExtendedDataEntity::getDataEntity).filter(o -> BillStatusEnum.AUDIT.getValue().equals(o.getString("billstatus"))).map(o -> o.getLong("id")).collect(Collectors.toList());
                QFilter filter = new QFilter("id", "in", idList);
                filter = filter.and("entrys.isupdatestate", "=", (Object)true);
                DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filter.toArray());
                List ids = bills.stream().map(o -> Long.parseLong(o.get("id").toString())).collect(Collectors.toList());
                idList.removeAll(ids);
            }
            HashMap<Long, String> errorInfoMap = new HashMap<Long, String>();
            if (idList.size() > 0) {
                List<DynamicObject> forceQueryDataList = needCheckDataEntities.stream().map(ExtendedDataEntity::getDataEntity).filter(o -> idList.contains(o.getLong("id"))).collect(Collectors.toList());
                List<EBResult> resultList = EBServiceFacadeFactory.getBankService().queryPay(forceQueryDataList, true);
                for (EBResult result : resultList) {
                    if (result.getStatusCode() == EBResultStatusCode.SUCCESS) continue;
                    errorInfoMap.put(result.getBankBillId(), result.getErrMsg());
                }
            }
            DynamicObjectCollection bankBills = QueryServiceHelper.query((String)entityName, (String)("id," + this.getPayStatusField()), (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            List<String> validStatus = Arrays.asList(BeBillStatusEnum.TF.getValue(), BeBillStatusEnum.PS.getValue());
            Set patStateUpdateIds = bankBills.stream().filter(s -> !validStatus.contains(s.getString(this.getPayStatusField()))).map(s -> s.getLong("id")).collect(Collectors.toSet());
            ArrayList<Long> billIds = new ArrayList<Long>(needCheckDataEntities.size());
            for (ExtendedDataEntity dataEntity : needCheckDataEntities) {
                DynamicObject dataInfo = dataEntity.getDataEntity();
                Long billId = dataInfo.getLong("id");
                if (errorInfoMap.containsKey(billId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6253\u56de\u6216\u5931\u8d25\u91cd\u4ed8\u9632\u91cd\u68c0\u67e5\u4e0d\u901a\u8fc7\uff1a%s", (String)"ForceQueryValidator_0", (String)"tmc-bei-business", (Object[])new Object[]{errorInfoMap.get(billId)}));
                    continue;
                }
                if (patStateUpdateIds.contains(billId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6253\u56de\u6216\u5931\u8d25\u91cd\u4ed8\u9632\u91cd\u68c0\u67e5\u4e0d\u901a\u8fc7\uff1a\u4ed8\u6b3e\u72b6\u6001\u53d1\u751f\u53d8\u5316\u3002", (String)"ForceQueryValidator_1", (String)"tmc-bei-business", (Object[])new Object[]{errorInfoMap.get(billId)}));
                    continue;
                }
                Long currencyId = dataInfo.getDynamicObject("currency").getLong("id");
                Date bizDate = dataInfo.getDate("submittime");
                billIds.add(billId);
                try {
                    if ("bei_banktransupbill".equals(entityName)) {
                        DynamicObjectCollection entrys = dataInfo.getDynamicObjectCollection("entrys");
                        Set bankAcctIds = entrys.stream().map(s -> s.getDynamicObject("subacct").getLong("id")).collect(Collectors.toSet());
                        for (Long bankAcctId : bankAcctIds) {
                            this.downloadTransDetail(bankAcctId, bizDate, currencyId);
                        }
                        continue;
                    }
                    Long bankAcctId = dataInfo.getDynamicObject("accountbank").getLong("id");
                    this.downloadTransDetail(bankAcctId, bizDate, currencyId);
                }
                catch (Exception e) {
                    logger.error("\u6253\u56de\u6216\u5931\u8d25\u91cd\u4ed8\u5f3a\u5236\u4e0b\u8f7d\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
                }
            }
            if ("bei_bankpaybill".equals(entityName) && EmptyUtil.isNoEmpty(billIds)) {
                DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"suspectRepeatService", (String)"suspectRepeatGen", (Object[])new Object[]{entityName, billIds, null, "bei_transdetail"});
                Map controlMap = SuspectRepeatHelper.getControlMessageInfo(new HashSet(billIds));
                if (!controlMap.isEmpty()) {
                    for (ExtendedDataEntity dataEntity : needCheckDataEntities) {
                        DynamicObject bill = dataEntity.getDataEntity();
                        Long pkId = bill.getLong("id");
                        String controlMessage = controlMap.getOrDefault(pkId, null);
                        List controlList = (List)controlMap.get("operateKey");
                        if (controlMessage == null || controlList == null || !controlList.contains(this.getOperateKey())) continue;
                        logger.info("\u4e25\u63a7\u63d0\u793a\u4fe1\u606f\uff1a" + controlMessage);
                        this.addErrorMessage(dataEntity, controlMessage);
                    }
                }
            }
        }
    }

    private TransDetailResult downloadTransDetail(Long bankAcctId, Date bizDate, Long currencyId) {
        DetailQueryInfo queryInfo = new DetailQueryInfo();
        DynamicObject bankAcct = TmcDataServiceHelper.loadSingleFromCache((Object)bankAcctId, (String)"bd_accountbanks");
        queryInfo.setBankAcct(bankAcct);
        queryInfo.setIdList(Collections.singletonList(bankAcct.getLong("id")));
        DynamicObject currency = TmcDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        queryInfo.setCurr(currency);
        queryInfo.setOrgId(Long.valueOf(TmcAccountHelper.getCreateOrgByBankAcct((DynamicObject)bankAcct)));
        queryInfo.setBeginDate(EmptyUtil.isNoEmpty((Object)bizDate) ? bizDate : DateUtils.getCurrentDate());
        queryInfo.setEndDate(DateUtils.getCurrentDate());
        queryInfo.setAsyncTask(false);
        queryInfo.setDownloadFromBank(true);
        return EBServiceFacadeFactory.getBankService().downTransDetails(queryInfo, new DynamicObject[0]);
    }

    protected abstract String getPayStatusField();
}

