/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.business.validate.updatestate;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.bei.common.helper.PayStateUpdateHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class UpdateStateValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("bankpaystate");
        selector.add("paystate");
        selector.add("isbitback");
        selector.add("isupdatingstatus");
        selector.add("company");
        selector.add("isupdatestate");
        selector.add("entrys");
        selector.add("entrys.isupdatestate");
        selector.add("entrys.status");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Object[] validStatusArr = new Object[]{BeBillStatusEnum.TF.getValue(), BeBillStatusEnum.NC.getValue(), BeBillStatusEnum.PS.getValue()};
        String entityName = dataEntity[0].getDataEntity().getDataEntityType().getName();
        boolean isPayingBill = StringUtils.equals((CharSequence)entityName, (CharSequence)"bei_bankpaybill");
        for (ExtendedDataEntity extData : dataEntity) {
            String payStatus;
            DynamicObject data = extData.getDataEntity();
            String billStatus = data.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u4fee\u6539\u5355\u636e\u72b6\u6001\u3002", (String)"UpdateStateValidator_0", (String)"tmc-bei-business", (Object[])new Object[0]));
                continue;
            }
            String string = payStatus = isPayingBill ? data.getString("bankpaystate") : data.getString("paystate");
            if (!Arrays.asList(validStatusArr).contains(payStatus)) {
                if (isPayingBill) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u4ed8\u6b3e\u72b6\u6001\u4e3a\u4ea4\u6613\u5931\u8d25\u3001\u4ea4\u6613\u672a\u786e\u8ba4\u7684\u5355\u636e\u624d\u80fd\u4fee\u6539\u5355\u636e\u72b6\u6001\u3002", (String)"UpdateStateValidator_1", (String)"tmc-bei-business", (Object[])new Object[0]));
                    continue;
                }
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u4ea4\u6613\u5931\u8d25\u201d\u3001\u201c\u90e8\u5206\u6210\u529f\u201d\u3001\u201c\u4ea4\u6613\u672a\u786e\u8ba4\u201d\u7684\u5355\u636e\u624d\u80fd\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"UpdateStateValidator_2", (String)"tmc-bei-business", (Object[])new Object[0]));
                continue;
            }
            boolean isBitBack = data.getBoolean("isbitback");
            if (isBitBack) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u6253\u56de\u7684\u5355\u636e\u4e0d\u80fd\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"UpdateStateValidator_3", (String)"tmc-bei-business", (Object[])new Object[0]));
                continue;
            }
            boolean isUpdatingStatus = PayStateUpdateHelper.isUpdatingStatus((DynamicObject)data, (String)entityName);
            if (isUpdatingStatus) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5305\u542b\u672a\u5b8c\u6210\u7684\u4ed8\u6b3e\u72b6\u6001\u53d8\u66f4\u5355\uff0c\u8bf7\u5b8c\u6210\u6d41\u7a0b\u5ba1\u6838\u540e\u518d\u64cd\u4f5c\u3002", (String)"UpdateStateValidator_4", (String)"tmc-bei-business", (Object[])new Object[0]));
                continue;
            }
            boolean isAllSyncTs = isPayingBill ? data.getBoolean("isupdatestate") : data.getDynamicObjectCollection("entrys").stream().filter(s -> !BeBillStatusEnum.TS.getValue().equals(s.getString("status"))).allMatch(o -> o.getBoolean("isupdatestate"));
            if (!isAllSyncTs) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u7ecf\u624b\u5de5\u4fee\u6539\u8fc7\u4ed8\u6b3e\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u6b21\u4fee\u6539\u3002", (String)"UpdateStateValidator_5", (String)"tmc-bei-business", (Object[])new Object[0]));
        }
    }
}

