/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.mservice.MQ;

import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.tmc.bei.business.ebservice.api.EBServiceFacadeFactory;
import kd.tmc.bei.business.opservice.queryinfo.BalanceQueryInfo;
import kd.tmc.bei.business.opservice.result.BalanceResult;
import kd.tmc.bei.common.enums.QueryRequestStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceScheduleConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(BalanceScheduleConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        BalanceQueryInfo balanceQueryInfo = (BalanceQueryInfo)message;
        long requestId = balanceQueryInfo.getRequestId();
        logger.info("\u5f53\u524dMQ\u67e5\u8be2\u8bf7\u6c42id:" + requestId);
        DynamicObject queryRequest = TmcDataServiceHelper.loadSingle((Object)requestId, (String)"bei_queryrequest", (String)"id,status,exception,exception_tag,createtime,publishtime,task");
        if (!QueryRequestStatusEnum.NOSTART.getValue().equals(queryRequest.getString("status"))) {
            logger.info("\u5f53\u524d\u8bf7\u6c42\u5df2\u67e5\u8be2\u8fc7\uff0c\u4e0d\u518d\u91cd\u590d\u67e5\u8be2");
            acker.discard(messageId);
            return;
        }
        Date curDate = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
        Date date = DateUtils.getDataFormat((Date)queryRequest.getDate("createtime"), (boolean)true);
        if (date.compareTo(curDate) != 0) {
            logger.info("\u5f53\u524d\u8bf7\u6c42\u5df2\u8fc7\u671f\uff0c\u4e0d\u518d\u67e5\u8be2");
            acker.discard(messageId);
            return;
        }
        String errorMsg = "";
        try {
            BalanceResult balanceResult = EBServiceFacadeFactory.getBankService().queryBatchBalance(balanceQueryInfo, new DynamicObject[]{queryRequest});
            errorMsg = balanceResult.getErrMsg();
        }
        catch (Exception e) {
            try {
                logger.error("queryBatchBalance Exception:", (Throwable)e);
                errorMsg = e.getMessage();
            }
            catch (Throwable throwable) {
                if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                    queryRequest.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                    queryRequest.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                    queryRequest.set("exception_tag", (Object)errorMsg);
                } else {
                    queryRequest.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
                }
                TmcOperateServiceHelper.execOperate((String)"save", (String)"bei_queryrequest", (DynamicObject[])new DynamicObject[]{queryRequest}, (OperateOption)OperateOption.create());
                throw throwable;
            }
            if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                queryRequest.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
                queryRequest.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
                queryRequest.set("exception_tag", (Object)errorMsg);
            } else {
                queryRequest.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
            }
            TmcOperateServiceHelper.execOperate((String)"save", (String)"bei_queryrequest", (DynamicObject[])new DynamicObject[]{queryRequest}, (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((String)errorMsg)) {
            queryRequest.set("status", (Object)QueryRequestStatusEnum.FAILED.getValue());
            queryRequest.set("exception", (Object)(errorMsg.length() > 255 ? errorMsg.substring(0, 250) + "..." : errorMsg));
            queryRequest.set("exception_tag", (Object)errorMsg);
        } else {
            queryRequest.set("status", (Object)QueryRequestStatusEnum.SUCCESS.getValue());
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"bei_queryrequest", (DynamicObject[])new DynamicObject[]{queryRequest}, (OperateOption)OperateOption.create());
        acker.ack(messageId);
    }
}

