/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class TransdetailRecedbillEntryUpService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TransdetailRecedbillEntryUpService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog("kd.tmc.bei.service.TransdetailRecedbillEntryUpService - start");
            this.update("debit");
            this.update("credit");
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.info(e.getMessage());
            logger.info(result.getErrorInfo());
        }
        return result;
    }

    private void update(String debitFlag) {
        try (TXHandle h = TX.requiresNew((String)"TransdetailRecedbillEntryUpService");){
            try {
                String countSql = "select count(1) count from t_bei_transdetail t left join t_bei_recedbillentry e on t.fid = e.fid where t.freceredtype ='3' and t.fdebitamount != 0 and t.fcreditamount = 0 and e.fdirection = ' '";
                if (debitFlag.equals("credit")) {
                    countSql = "select count(1) count from t_bei_transdetail t left join t_bei_recedbillentry e on t.fid = e.fid where t.freceredtype ='3' and t.fdebitamount = 0 and t.fcreditamount != 0 and e.fdirection = ' '";
                }
                DataSet upCount = DB.queryDataSet((String)"upDebitCount", (DBRoute)DBRouteConst.TMC, (String)countSql);
                int count = ((Row)upCount.iterator().next()).getInteger("count");
                int page = 0;
                if (count > 50000) {
                    page = count / 50000;
                }
                for (int j = 0; j < page + 1; ++j) {
                    int startsize = j * 50000;
                    int endsize = (j + 1) * 50000;
                    DataSet dataSet = TransdetailRecedbillEntryUpService.queryDataSet(startsize, endsize, debitFlag);
                    ArrayList<Object[]> batchParam = new ArrayList<Object[]>(10);
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Long id = row.getLong("fid");
                        batchParam.add(new Object[]{id});
                    }
                    TransdetailRecedbillEntryUpService.executeBatch(batchParam, debitFlag);
                }
                logger.info("\u5171" + count + "\u6761\u6570\u636e\u3002");
                upCount.close();
            }
            catch (Exception e) {
                logger.error("TransdetailRecedbillEntryUpService===============" + e);
            }
        }
    }

    private static DataSet queryDataSet(int startsize, int endsize, String debitFlag) {
        String sql = "select t.fid, e.fdirection from t_bei_transdetail t left join t_bei_recedbillentry e on t.fid = e.fid where t.freceredtype ='3' and t.fdebitamount != 0 and t.fcreditamount = 0 and e.fdirection = ' '";
        if (debitFlag.equals("credit")) {
            sql = "select t.fid, e.fdirection from t_bei_transdetail t left join t_bei_recedbillentry e on t.fid = e.fid where t.freceredtype ='3' and t.fdebitamount = 0 and t.fcreditamount != 0 and e.fdirection = ' '";
        }
        return DB.queryDataSet((String)("queryDirection" + debitFlag), (DBRoute)DBRouteConst.TMC, (String)sql).limit(startsize, endsize);
    }

    private static void executeBatch(List<Object[]> batchParam, String debitFlag) {
        String sql = "debit".equals(debitFlag) ? "UPDATE t_bei_recedbillentry SET fdirection = 'pay' where  Fid = ? " : "UPDATE t_bei_recedbillentry SET fdirection = CASE WHEN ferecedbilltype in ('cas_paybill','cas_paybill_synonym','cas_paybill_cash','cas_paybill_spanmainpart','cas_paybill_dcep')  THEN 'pay' ELSE 'rec' END where  Fid = ? ";
        DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, batchParam);
    }
}

