/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.util.DateUtils;

public class UpdateBalanceEndDateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(UpdateBalanceEndDateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("kd.tmc.bei.service.UpdateBalanceEndDateService");
        result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4f59\u989d\u7ed3\u675f\u65e5\u671f\u5386\u53f2\u6570\u636e\u5347\u7ea7", (String)"UpdateBalanceEndDateService_0", (String)"tmc-bei-mservice", (Object[])new Object[0]));
        try {
            ThreadPools.executeOnceIncludeRequestContext((String)"UpdateBalanceEndDateService", () -> {
                logger.info("UpdateBalanceEndDateService\u5f02\u6b65\u7ebf\u7a0b\u5f00\u59cb\u6267\u884c\uff1astarttime" + System.currentTimeMillis());
                QFilter accountFilter = new QFilter("accountbank", ">", (Object)0L);
                accountFilter.and("currency", ">", (Object)0L);
                accountFilter.and("bizdate", "is not null", null);
                accountFilter.and("enddate", "is null", null);
                DataSet accountDs = QueryServiceHelper.queryDataSet((String)"UpdateBalanceEndDateService.getAccontBank", (String)"bei_bankbalance", (String)"accountbank", (QFilter[])accountFilter.toArray(), null).groupBy(new String[]{"accountbank"}).finish();
                int i = 0;
                for (Row account : accountDs) {
                    Long accountId = account.getLong("accountbank");
                    this.dealOneAccount(accountId);
                    ++i;
                }
                logger.info("UpdateBalanceEndDateService.updateAccountSize:  " + i);
                logger.info("UpdateBalanceEndDateService\u5f02\u6b65\u7ebf\u7a0b\u5f00\u59cb\u6267\u884c\uff1aendtime" + System.currentTimeMillis());
            });
            result.setLog(ResManager.loadKDString((String)"\u7ed3\u675f\u6267\u884c\u4f59\u989d\u7ed3\u675f\u65e5\u671f\u5386\u53f2\u6570\u636e\u5347\u7ea7", (String)"UpdateBalanceEndDateService_1", (String)"tmc-bei-mservice", (Object[])new Object[0]));
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.info(e.getMessage());
            logger.info(result.getErrorInfo());
        }
        return result;
    }

    private void dealOneAccount(Long accountId) {
        long startTime = System.currentTimeMillis();
        logger.info("UpdateBalanceEndDateService.dealOneAccount begin accountId:" + accountId);
        ArrayList<DynamicObject> updateResult = new ArrayList<DynamicObject>(10);
        QFilter oneAccountFilter = new QFilter("accountbank", "=", (Object)accountId);
        oneAccountFilter.and("currency", ">", (Object)0L);
        oneAccountFilter.and("bizdate", "is not null", null);
        DynamicObject[] oneAccountBalance = BusinessDataServiceHelper.load((String)"bei_bankbalance", (String)"id,accountbank,currency,bizdate,enddate", (QFilter[])oneAccountFilter.toArray(), null);
        Map<String, List> groupedAndSorted = Arrays.stream(oneAccountBalance).collect(Collectors.groupingBy(balance -> balance.getLong("accountbank_id") + "#" + balance.getLong("currency_id"), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(t -> t.getDate("bizdate"))).collect(Collectors.toList()))));
        for (Map.Entry<String, List> accountCurrencySet : groupedAndSorted.entrySet()) {
            List accountCurrencyList = accountCurrencySet.getValue();
            Collections.reverse(accountCurrencyList);
            Date nextDate = null;
            for (int i = 0; i < accountCurrencyList.size(); ++i) {
                DynamicObject tmepDy = (DynamicObject)accountCurrencyList.get(i);
                if (i == 0) {
                    tmepDy.set("enddate", (Object)DateUtils.stringToDate((String)"9999-12-31", (String)"yyyy-MM-dd"));
                } else {
                    tmepDy.set("enddate", nextDate);
                }
                nextDate = tmepDy.getDate("bizdate");
                updateResult.add(tmepDy);
            }
        }
        SaveServiceHelper.save((DynamicObject[])updateResult.toArray(new DynamicObject[0]));
        logger.info("UpdateBalanceEndDateService.dealOneAccount end accountId:  " + accountId + "updateRowSize:  " + updateResult.size() + "cost time:  " + (System.currentTimeMillis() - startTime));
    }
}

