/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service.tcc.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.common.helper.DetailInfoExtFieldsHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.bei.service.tcc.IAutoMatchTccService;
import kd.tmc.bei.service.tcc.TccLockEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DefaultTccServiceImpl
implements IAutoMatchTccService {
    private static final Log LOGGER = LogFactory.getLog(DefaultTccServiceImpl.class);

    @Override
    public boolean lockOrRelease(TccLockEnum lock, List<AutoMatchInfoParam> tAutoMatchInfoParamList, String version) {
        LOGGER.info("DefaultTccServiceImpl,tAutoMatchInfoParamList:{},version:{}", tAutoMatchInfoParamList, (Object)version);
        return true;
    }

    @Override
    public void update(DynamicObject tRecedBill, AutoMatchInfoParam tAutoMatchInfoParam, String receredway, CommonParam tComParam) {
        boolean haveBankcheckflag = tRecedBill.getDynamicObjectType().getProperties().stream().anyMatch(o -> "bankcheckflag".equals(o.getName()) || "bankcheckflag_tag".equals(o.getName()));
        if (haveBankcheckflag) {
            String bankcheckBill;
            if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> "bankcheckflag_tag".equals(o.getName()))) {
                bankcheckBill = tRecedBill.getString("bankcheckflag_tag");
                tRecedBill.set("bankcheckflag_tag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)0));
                tRecedBill.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)255));
            } else if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> "bankcheckflag".equals(o.getName()))) {
                bankcheckBill = tRecedBill.getString("bankcheckflag");
                tRecedBill.set("bankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)255));
            }
            if (tRecedBill.containsProperty("bankcheckentity")) {
                String matchBankCheckFlag = tAutoMatchInfoParam.getBankCheckFlag();
                DynamicObjectCollection bankCheckEntity = tRecedBill.getDynamicObjectCollection("bankcheckentity");
                if (!EmptyUtil.isEmpty((String)matchBankCheckFlag)) {
                    String[] split = matchBankCheckFlag.split(",");
                    Map detailInfoFieldsMap = DetailInfoExtFieldsHelper.getDetailInfoFields((String)tAutoMatchInfoParam.getRecedBillType());
                    DynamicObject detail = QueryServiceHelper.queryOne((String)"bei_transdetail", (String)(detailInfoFieldsMap.isEmpty() ? "id,billno,bizdate" : String.join((CharSequence)",", detailInfoFieldsMap.keySet())), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tAutoMatchInfoParam.getTransDetailId())});
                    for (String strFlag : split) {
                        List eBankCheckEntity;
                        if (bankCheckEntity.stream().noneMatch(o -> Objects.equals(o.getString("ebankcheckflag"), strFlag))) {
                            DynamicObject dynamicObject = bankCheckEntity.addNew();
                            dynamicObject.set("ebankcheckflag", (Object)strFlag);
                            DetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)detail, (DynamicObject)dynamicObject, (Map)detailInfoFieldsMap);
                            continue;
                        }
                        if (!bankCheckEntity.stream().anyMatch(o -> Objects.equals(o.getString("ebankcheckflag"), strFlag)) || (eBankCheckEntity = bankCheckEntity.stream().filter(o -> strFlag.equals(o.getString("ebankcheckflag"))).collect(Collectors.toList())).isEmpty()) continue;
                        for (DynamicObject dynamicObject : eBankCheckEntity) {
                            DetailInfoExtFieldsHelper.setDetailInfoEntry((DynamicObject)detail, (DynamicObject)dynamicObject, (Map)detailInfoFieldsMap);
                        }
                    }
                }
            }
            Date traceDate = tAutoMatchInfoParam.getBizDate();
            String filedName = "acttradedate";
            if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> filedName.equals(o.getName()))) {
                Date exchangedate = tRecedBill.getDate(filedName);
                if (exchangedate != null && exchangedate.compareTo(traceDate) > 0) {
                    traceDate = exchangedate;
                }
                tRecedBill.set(filedName, (Object)traceDate);
            }
        }
    }

    @Override
    public void cancel(List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
    }
}

