/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service.tcc.impl;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.sdk.tmc.bei.util.MatchResultBean;
import kd.sdk.tmc.bei.util.RecPayRuleMatchUtil;
import kd.tmc.bei.business.helper.AutoMatchHelper;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.common.enums.BillStatusEnum;
import kd.tmc.bei.common.enums.ReceredWayEnum;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.bei.service.tcc.IAutoMatchTccService;
import kd.tmc.bei.service.tcc.TccLockEnum;
import kd.tmc.fbp.common.enums.MatchStatusEnum;
import kd.tmc.fbp.common.enums.ReceredtypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransDetailTccServiceImpl
implements IAutoMatchTccService {
    private static final Set<String> RecedBillType = Sets.newHashSet((Object[])new String[]{"cas_paybill_synonym", "cas_paybill_cash", "cas_paybill_spanmainpart", "cas_paybill_dcep"});
    private static final Set<String> RecPayBillType = Sets.newHashSet((Object[])new String[]{"cas_paybill", "cas_recbill", "cas_agentpaybill", "fca_transdownbill", "fca_transupbill", "cas_exchangebill", "ifm_transhandlebill"});
    private static final Log LOGGER = LogFactory.getLog(TransDetailTccServiceImpl.class);

    @Override
    public boolean lockOrRelease(TccLockEnum lock, List<AutoMatchInfoParam> tAutoMatchInfoParamList, String version) {
        LOGGER.info("TransDetailTccServiceImpl,tAutoMatchInfoParamList:{},version:{}", tAutoMatchInfoParamList, (Object)version);
        String tUpdateSql = "";
        if (TccLockEnum.TRY == lock) {
            tUpdateSql = "update t_bei_transdetail set freceredtype='1',fversion=? where freceredtype='0' and fversion=' ' and fid=?";
        } else if (TccLockEnum.CANCEL == lock) {
            tUpdateSql = "update t_bei_transdetail set freceredtype='0',fversion=' ' where freceredtype ='1' and fversion=? and fid=?";
        } else if (TccLockEnum.CONFIRM == lock) {
            tUpdateSql = "update t_bei_transdetail set fversion=' ' where  fversion=? and fid=?";
        } else if (TccLockEnum.REVERSE_TRY == lock) {
            tUpdateSql = "update t_bei_transdetail set freceredtype='1',fversion=? where freceredtype='3' and fversion=' ' and fid=?";
        } else if (TccLockEnum.REVERSE_CONFIRM == lock) {
            tUpdateSql = "update t_bei_transdetail set fversion=' ' where  fversion=? and fid=?";
        } else if (TccLockEnum.REVERSE_CANCEL == lock) {
            tUpdateSql = "update t_bei_transdetail set freceredtype='3',fversion=' ' where freceredtype ='1' and fversion=? and fid=?";
        }
        Set billIdSet = tAutoMatchInfoParamList.stream().map(AutoMatchInfoParam::getTransDetailId).collect(Collectors.toSet());
        List paramList = billIdSet.stream().map(id -> new Object[]{version, id}).collect(Collectors.toList());
        return AutoMatchServiceHelper.executeBatchSql((String)"bei_transdetail_cas", (String)tUpdateSql, paramList);
    }

    @Override
    public void update(DynamicObject tRecedBill, AutoMatchInfoParam tAutoMatchInfoParam, String receredway, CommonParam tComParam) {
        DynamicObject[] transDetails;
        List tAutoMatchInfoParamList = AutoMatchServiceHelper.getAutoMatchInfoList((CommonParam)tComParam);
        Set autoRecPayBizBillIdSet = (Set)tComParam.get((Object)"autoRecPayBizBillId");
        Map<String, List<Long>> tAutoRecPayMap = TransDetailTccServiceImpl.getAutoRecPayMap(autoRecPayBizBillIdSet, tAutoMatchInfoParamList);
        Map<Object, String> tRuleNameMap = TransDetailTccServiceImpl.getRuleNameMap(tComParam);
        Map<Long, List<AutoMatchInfoParam>> tAutoMatchInfoParamMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getTransDetailId));
        for (DynamicObject detail : transDetails = BusinessDataServiceHelper.load((Object[])tAutoMatchInfoParamMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"))) {
            TransDetailTccServiceImpl.updateTransDetail(true, detail, receredway, tRuleNameMap.get(detail.getLong("id")));
            this.updateConfirmAmount(detail, receredway, tAutoMatchInfoParamMap.get(detail.getLong("id")));
            tAutoMatchInfoParamMap.get(detail.getLong("id")).forEach(item -> {
                if (tAutoRecPayMap.containsKey(item.getRecedBillType()) && ((List)tAutoRecPayMap.get(item.getRecedBillType())).contains(item.getRecedBillId())) {
                    detail.set("autorecorpay", (Object)"1");
                }
                if (ReceredWayEnum.BEIPAY.getValue().equals(receredway)) {
                    detail.set("bankcheckflag", (Object)item.getBankCheckFlag());
                }
                BigDecimal amount = Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredway) ? BigDecimal.ZERO : item.getAmount();
                AutoMatchHelper.setRecedBillEntry((DynamicObject)detail, (String)item.getRecedBillType(), (String)item.getRecedBillNumber(), (Long)item.getRecedBillId(), (Long)item.getRecedBillEntryId(), (String)item.getTraceType(), (BigDecimal)amount, (String)item.getThisOpnumber(), (String)item.getDirection());
            });
        }
        SaveServiceHelper.save((DynamicObject[])transDetails);
    }

    @Override
    public void cancel(List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
        Object[] details1;
        LOGGER.info("TransDetailTccServiceImpl cancel");
        Map<Long, List<AutoMatchInfoParam>> tAutoMatchInfoParamMap = tAutoMatchInfoParamList.stream().collect(Collectors.groupingBy(AutoMatchInfoParam::getTransDetailId));
        DynamicObject[] transDetails = BusinessDataServiceHelper.load((Object[])tAutoMatchInfoParamMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
        List recedbillnumberSet = AutoMatchHelper.getRecedBillNumber((DynamicObject[])((DynamicObject[])Arrays.stream(transDetails).filter(dataEntity -> ReceredWayEnum.HANDMERGE.getValue().equals(dataEntity.getString("receredway"))).toArray(DynamicObject[]::new)));
        for (DynamicObject detail : transDetails) {
            TransDetailTccServiceImpl.updateTransDetail(false, detail, detail.getString("receredway"), null);
        }
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(Arrays.asList(transDetails));
        if (!(EmptyUtil.isEmpty((Collection)recedbillnumberSet) || recedbillnumberSet.isEmpty() || EmptyUtil.isEmpty((Object[])(details1 = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)("id,recedbilltype,recedbillnumber,receredtype,isreced,receredway,ishandlink,autorecorpay,rulename,smartmatch,iskdretflag," + AutoMatchHelper.getMatchFieldStringKeys()), (QFilter[])new QFilter[]{new QFilter("recedbillentry.e_recedbillnumber", "in", (Object)recedbillnumberSet)}))))) {
            Set<Long> removeIds = tAutoMatchInfoParamMap.keySet();
            DynamicObject[] details = BusinessDataServiceHelper.load((Object[])Arrays.stream(details1).filter(o -> !removeIds.contains(o.getLong("id"))).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
            if (details.length > 0) {
                for (DynamicObject detail : details) {
                    TransDetailTccServiceImpl.updateTransDetail(false, detail, detail.getString("receredway"), null);
                }
                detailList.addAll(Arrays.asList(details));
            }
        }
        List matchResultBeanList = RecPayRuleMatchUtil.match((Object[])detailList.stream().map(DataEntityBase::getPkValue).toArray());
        Map<Object, String> matchResultMap = matchResultBeanList.stream().collect(Collectors.toMap(MatchResultBean::getId, MatchResultBean::getNewRuleName, (k, v) -> v));
        for (DynamicObject detail : detailList) {
            detail.set("rulename", (Object)matchResultMap.get(detail.getPkValue()));
        }
        SaveServiceHelper.save((DynamicObject[])detailList.toArray(new DynamicObject[0]));
    }

    private void updateConfirmAmount(DynamicObject detail, String receredway, List<AutoMatchInfoParam> params) {
        BigDecimal noSameTotalAmt;
        BigDecimal amount;
        BigDecimal confirmAmount = detail.getBigDecimal("confirmamount");
        if (EmptyUtil.isNoEmpty((BigDecimal)detail.getBigDecimal("creditamount"))) {
            amount = detail.getBigDecimal("creditamount");
            noSameTotalAmt = params.stream().filter(o -> "pay".equals(o.getDirection())).map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sameTotalAmt = params.stream().filter(o -> "rec".equals(o.getDirection())).map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (EmptyUtil.isEmpty((BigDecimal)noSameTotalAmt) && EmptyUtil.isEmpty((BigDecimal)sameTotalAmt)) {
                BigDecimal allTotalAmt = params.stream().map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                confirmAmount = confirmAmount.add(allTotalAmt);
            } else {
                confirmAmount = confirmAmount.subtract(noSameTotalAmt).add(sameTotalAmt);
            }
        } else {
            amount = detail.getBigDecimal("debitamount");
            noSameTotalAmt = params.stream().filter(o -> "rec".equals(o.getDirection())).map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sameTotalAmt = params.stream().filter(o -> "pay".equals(o.getDirection())).map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (EmptyUtil.isEmpty((BigDecimal)noSameTotalAmt) && EmptyUtil.isEmpty((BigDecimal)sameTotalAmt)) {
                BigDecimal allTotalAmt = params.stream().map(AutoMatchInfoParam::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                confirmAmount = confirmAmount.add(allTotalAmt);
            } else {
                confirmAmount = confirmAmount.subtract(noSameTotalAmt).add(sameTotalAmt);
            }
        }
        if (Arrays.asList(ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredway)) {
            confirmAmount = amount;
        }
        BigDecimal unConfirmAmount = amount.subtract(confirmAmount);
        detail.set("confirmamount", (Object)confirmAmount);
        detail.set("unconfirmamount", (Object)unConfirmAmount);
        if (BigDecimal.ZERO.compareTo(confirmAmount) == 0) {
            detail.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
        }
        if (BigDecimal.ZERO.compareTo(unConfirmAmount) == 0) {
            detail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
        }
    }

    private static void updateTransDetail(boolean isDoExecute, DynamicObject detail, String receredway, String rulename) {
        if (isDoExecute) {
            detail.set("receredtype", (Object)ReceredtypeEnum.ACCOUNTED.getValue());
            detail.set("receredway", (Object)receredway);
            detail.set("rulename", (Object)rulename);
        } else {
            if (!detail.getBoolean("ishandlink")) {
                detail.set("isreced", (Object)false);
            }
            BigDecimal confirmAmount = detail.getBigDecimal("confirmamount");
            detail.set("confirmamount", (Object)BigDecimal.ZERO);
            detail.set("unconfirmamount", (Object)confirmAmount);
            detail.set("receredtype", (Object)ReceredtypeEnum.Pending.getValue());
            detail.set("ishandlink", (Object)false);
            detail.set("receredway", null);
            detail.set("recedbillnumber", null);
            detail.set("rulename", null);
            detail.set("autorecorpay", (Object)"0");
            AutoMatchHelper.deleteRecedBillEntry((DynamicObject)detail);
        }
        if (Arrays.asList(ReceredWayEnum.HANDMATCH.getValue(), ReceredWayEnum.DIFFERMATCH.getValue(), ReceredWayEnum.REVERSEMATCH.getValue(), ReceredWayEnum.SINGLEMATCH.getValue()).contains(receredway)) {
            if (isDoExecute) {
                detail.set("ishandlink", (Object)true);
            }
        } else if (ReceredWayEnum.AUTOMATCH.getValue().equals(receredway)) {
            if (isDoExecute) {
                detail.set("smartmatch", (Object)MatchStatusEnum.SMARTMATCH.getValue());
            } else {
                detail.set("smartmatch", (Object)MatchStatusEnum.UNSMARTMATCH.getValue());
            }
        } else if (ReceredWayEnum.BEIPAY.getValue().equals(receredway) && isDoExecute) {
            detail.set("iskdretflag", (Object)"1");
        }
    }

    private static Map<String, List<Long>> getAutoRecPayMap(Set<Object> autoRecPayBizBillIdSet, List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
        HashMap<String, List<Long>> tAutoRecPayMap = new HashMap<String, List<Long>>(2);
        if (autoRecPayBizBillIdSet != null) {
            Map tRecedBillsIdMap = tAutoMatchInfoParamList.stream().filter(o -> autoRecPayBizBillIdSet.contains(o.getRecedBillId())).collect(Collectors.groupingBy(AutoMatchInfoParam::getRecedBillType, Collectors.mapping(AutoMatchInfoParam::getRecedBillId, Collectors.toList())));
            for (Map.Entry tRecedBillsEntry : tRecedBillsIdMap.entrySet()) {
                String key = TransDetailTccServiceImpl.getRecedBillType(tRecedBillsEntry.getKey());
                if (!RecPayBillType.contains(key)) continue;
                DynamicObjectCollection tRecedBills = QueryServiceHelper.query((String)key, (String)"id", (QFilter[])new QFilter("id", "in", tRecedBillsEntry.getValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).toArray());
                tAutoRecPayMap.put(tRecedBillsEntry.getKey(), tRecedBills.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
            }
        }
        return tAutoRecPayMap;
    }

    private static String getRecedBillType(String key) {
        if (RecedBillType.contains(key)) {
            return "cas_paybill";
        }
        return key;
    }

    private static Map<Object, String> getRuleNameMap(CommonParam tComParam) {
        HashMap<Object, String> tRuleNameMap = new HashMap<Object, String>(0);
        try {
            Object rulename = tComParam.get((Object)"rulename");
            if (!"null".equals(rulename) && rulename != null) {
                tRuleNameMap.putAll((Map)rulename);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6getRuleNameMap\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return tRuleNameMap;
    }
}

