/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.bei.service.tcc.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.bei.business.helper.AutoMatchServiceHelper;
import kd.tmc.bei.business.helper.MatchAmountDealHelper;
import kd.tmc.bei.common.param.AutoMatchInfoParam;
import kd.tmc.bei.service.tcc.IAutoMatchTccService;
import kd.tmc.bei.service.tcc.TccLockEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class TransHandleTccServiceImpl
implements IAutoMatchTccService {
    private static final Log LOGGER = LogFactory.getLog(TransHandleTccServiceImpl.class);

    @Override
    public boolean lockOrRelease(TccLockEnum lock, List<AutoMatchInfoParam> tAutoMatchInfoParamList, String version) {
        LOGGER.info("TransHandleTccServiceImpl,tAutoMatchInfoParamList:{},version:{}", tAutoMatchInfoParamList, (Object)version);
        List collectInHead = tAutoMatchInfoParamList.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getRecedBillEntryId())).collect(Collectors.toList());
        if (!collectInHead.isEmpty()) {
            String tUpdateSql = TransHandleTccServiceImpl.getUpdateSql(lock);
            Set billIdSet = collectInHead.stream().map(AutoMatchInfoParam::getRecedBillId).collect(Collectors.toSet());
            List paramList = billIdSet.stream().map(id -> new Object[]{version, id}).collect(Collectors.toList());
            return AutoMatchServiceHelper.executeBatchSql((String)"ifm_transhandlebill", (String)tUpdateSql, paramList);
        }
        return true;
    }

    @Override
    public void update(DynamicObject tRecedBill, AutoMatchInfoParam tAutoMatchInfoParam, String receredway, CommonParam tComParam) {
        MatchAmountDealHelper.matchManyToOne((DynamicObject)tRecedBill, (String)AutoMatchServiceHelper.getBunessType((String)tAutoMatchInfoParam.getSourceEntity(), (String)receredway), (BigDecimal)tAutoMatchInfoParam.getAmount(), (String)tAutoMatchInfoParam.getRecedBillType(), (String)receredway);
        String bankcheckBill = tRecedBill.getString("beibankcheckflag");
        tRecedBill.set("beibankcheckflag", (Object)AutoMatchServiceHelper.getbankcheckBill((String)bankcheckBill, (String)tAutoMatchInfoParam.getBankCheckFlag(), (int)1024));
        Date traceDate = tAutoMatchInfoParam.getBizDate();
        String filedName = "acttradedate";
        if (tRecedBill.getDataEntityType().getProperties().stream().anyMatch(o -> filedName.equals(o.getName()))) {
            Date exchangedate = tRecedBill.getDate(filedName);
            if (exchangedate != null && exchangedate.compareTo(traceDate) > 0) {
                traceDate = exchangedate;
            }
            tRecedBill.set(filedName, (Object)traceDate);
        }
    }

    @Override
    public void cancel(List<AutoMatchInfoParam> tAutoMatchInfoParamList) {
    }

    private static String getUpdateSql(TccLockEnum lock) {
        String updateSql = TccLockEnum.TRY == lock ? "UPDATE t_ifm_transhandle_e set fversion=?,fispreflag='1' where fversion= ' ' and fmatchflag in ('0','2') and fispreflag='0' and fid=?" : "UPDATE t_ifm_transhandle_e set fversion=' ',fispreflag='0' where fversion=? and fispreflag='1' and fid=?";
        return updateSql;
    }
}

